/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgftotex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.tex.TexWriter;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class SgfToTex {
    public static void main(String[] stringArray) {
        try {
            OutputStream outputStream;
            InputStream inputStream;
            String[] stringArray2 = new String[]{"config:", "force", "help", "pass", "title:", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                SgfToTex.printUsage(System.out);
                System.exit(0);
            }
            if (options.isSet("version")) {
                System.out.println("SgfToTex " + Version.get());
                System.exit(0);
            }
            boolean bl = options.isSet("pass");
            boolean bl2 = options.isSet("force");
            String string = options.getString("title", "");
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() > 2) {
                SgfToTex.printUsage(System.err);
                System.exit(-1);
            }
            String string2 = null;
            if (arrayList.size() == 0) {
                inputStream = System.in;
                outputStream = System.out;
            } else {
                string2 = (String)arrayList.get(0);
                File file = new File(string2);
                inputStream = new FileInputStream(file);
                String string3 = arrayList.size() == 1 ? FileUtils.replaceExtension(file, "sgf", "tex") : (String)arrayList.get(1);
                File file2 = new File(string3);
                if (file2.exists() && !bl2) {
                    throw new Exception("File " + file2 + " already exists");
                }
                outputStream = new FileOutputStream(file2);
                if (string.equals("")) {
                    string = FileUtils.removeExtension(new File(file2.getName()), "tex");
                }
            }
            SgfToTex.convert(inputStream, string2, outputStream, string, bl);
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private SgfToTex() {
    }

    private static void convert(InputStream inputStream, String string, OutputStream outputStream, String string2, boolean bl) throws SgfReader.SgfError {
        SgfReader sgfReader = new SgfReader(inputStream, string, null, 0L);
        new TexWriter(string2, outputStream, sgfReader.getGameTree(), bl);
    }

    private static void printUsage(PrintStream printStream) {
        printStream.print("Usage: java -jar sgftotex.jar [file.sgf [file.tex]]\n\n-config  config file\n-force   overwrite existing files\n-help    display this help and exit\n-pass    use \\pass command\n-title   use title\n-version print version and exit\n");
    }
}

