/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;
import java.io.File;

/**
*@author Ruediger Klehn
*/
// read in system variables and detect a wrong format before Java makes a big problem of it 
// not yet "oop"
public class SysVar {
  
  public static String get(String key, int type){  // 0 = boolean {null}, 1 = String {""}, 2 = integer {0}, 3 = path {""}
    String contt = System.getenv(key);
    boolean bool;
    int integ;
    if (contt == null || contt.equals("")) return "";
    // here was the source for exceptions: if (in Linux) I (re-)set a variable NAME="", it is not null AND doesn't give a boolean or integer
    if (type == 0){
      if (contt.toLowerCase().equals("false") || contt.toLowerCase().equals("true") ) return contt; 
      // all, which is not true is false; I like it more exact
      d.b.g("Cannot get boolean value from system variable " + key + ": " + contt);
      return "";
    }
    if (type == 1) return contt;
    if (type == 2){
      try {
        return Integer.valueOf(contt).toString();
      }
      catch(Exception e) {
        d.b.g("Cannot get integer value from system variable " + key + ": " + contt);
        return "";
      }
    }
    if (type == 3){
      if (new File(contt).exists()) return contt;
      else{
        d.b.g("Path from system variable " + key + " not found: " + contt);
        return "";
      }
    }
    return "";
  }
}