class SushiNet::StoreBanner < Borges::Component

  TITLE = 'sushiNet'
  SUBTITLE = 'Fresh, raw fish delivered to your door'

  attr_accessor :search_text

  def initialize(frame)
    @frame = frame
    @search_text = ''
  end

  def render_banner_on(r)
    r.div_named 'title', TITLE
    r.div_named 'subtitle', SUBTITLE
  end

  def render_content_on(r)
    r.title TITLE
    r.table do
      r.table_row do
        r.element_id 'search'
        r.table_data do render_search_on r end

        r.element_id 'banner'
        r.table_data do render_banner_on r end
      end
    end
  end

  def render_search_on(r)
    r.form do
      r.small do
        r.bold 'Search: '
        r.text_input_on :search_text, self
        r.default_action_on :search, self
      end
    end
  end

  def search
    @frame.search @search_text
  end

end # class SushiNet::StoreBanner

