require 'benchmark'
require 'profiler'
require 'stringio'

module Profiler__
  def self.profile
    io = StringIO.new
    start_profile
    yield
    print_profile io
    return io.string
  end
end

class Profiler
  def self.profile
    benchmark_result = nil
    profile_result = nil

    benchmark_result = Benchmark.measure do
      new.start
    end

    profile_result = Profiler__.profile do
      new.start
    end

    result = ''
    result << "Bencmark:\n"
    result << benchmark_result.to_s
    result << '-' * 80 << "\n"
    result << "Profile:\n"
    result << profile_result
  end
end

