<?php
/**
 * @entity asp.ASPUser
 */
abstract class ASPUserDAO extends ASPSOY2DAO{
	
	/**
	 * @return id
	 */
	abstract function insert(ASPUser $bean);
	
	/**
	 * @return object
	 */
	abstract function getById($id);
	
	/**
	 * @return object
	 */
	abstract function getByEmail($email);
	
	/**
	 * @return object
	 * @query #email# = :email and #password# = :password
	 */
	abstract function login($email,$password);
	
	/**
	 * @order last_login_date desc
	 */
	abstract function get();
	
	/**
	 * @query last_login_date is not null
	 * @order last_login_date desc
	 */
	abstract function getActiveUsers();
	
	/**
	 * @query last_login_date is null
	 * @order id asc
	 */
	abstract function getInactiveUsers();
	
	abstract function update(ASPUser $bean);
    
    abstract function delete($id);
    

    
}
?>