<?php
/**
 * File containing the ezcWebdavGetCollectionResponse class.
 *
 * @package Webdav
 * @version 1.1.4
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */
/**
 * Class generated by the backend to respond to GET requests on collection resources.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavGetRequest} it might react with an instance of {@link
 * ezcWebdavGetResourceResponse} for non-collection resources or {@link
 * ezcWebdavGetCollectionResponse} for collection resources or by producing an
 * error.
 *
 * @version 1.1.4
 * @package Webdav
 */
class ezcWebdavGetCollectionResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     * 
     * Creates a new repsonse object for the given $collection resource.
     * 
     * @param ezcWebdavCollection $collection 
     * @return void
     */
    public function __construct( ezcWebdavCollection $collection )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );

        $this->collection = $collection;
        $this->setHeader( 'Content-Length', '4096' );
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'collection':
                if ( ! $propertyValue instanceof ezcWebdavCollection )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavCollection' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
