/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32InputStream
extends InputStream {
    private final InputStream delegate;
    private final CRC32 crc32 = new CRC32();

    public CRC32InputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public int getCRC32() {
        return (int)this.crc32.getValue();
    }

    @Override
    public int read() {
        try {
            int value = this.delegate.read();
            if (value != -1) {
                this.crc32.update(value);
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b) {
        try {
            int result = this.delegate.read(b);
            if (result != -1) {
                this.crc32.update(b, 0, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int length) {
        try {
            int result = this.delegate.read(b, off, length);
            this.crc32.update(b, off, result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long skip(long n) {
        try {
            return this.delegate.skip(n);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int available() {
        try {
            return this.delegate.available();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void mark(int readLimit) {
        this.delegate.mark(readLimit);
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

