/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.util.function.Supplier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLayoutValidator;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.RunTasksRequirements;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.launcher.exec.QueryModelRequirements;
import org.gradle.launcher.exec.RunActionRequirements;
import org.gradle.launcher.exec.RunPhasedActionRequirements;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class BuildTreeLifecycleBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildTreeModelControllerServices buildTreeModelControllerServices;
    private final BuildLayoutValidator buildLayoutValidator;
    private final ValueSnapshotter valueSnapshotter;

    public BuildTreeLifecycleBuildActionExecutor(BuildTreeModelControllerServices buildTreeModelControllerServices, BuildLayoutValidator buildLayoutValidator, ValueSnapshotter valueSnapshotter) {
        this.buildTreeModelControllerServices = buildTreeModelControllerServices;
        this.buildLayoutValidator = buildLayoutValidator;
        this.valueSnapshotter = valueSnapshotter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        BuildActionRunner.Result result = null;
        try {
            this.buildLayoutValidator.validate(action.getStartParameter());
            BuildActionModelRequirements actionRequirements = this.buildActionModelRequirementsFor(action);
            BuildTreeModelControllerServices.Supplier modelServices = this.buildTreeModelControllerServices.servicesForBuildTree(actionRequirements);
            BuildInvocationScopeId buildInvocationScopeId = new BuildInvocationScopeId(UniqueId.generate());
            try (BuildTreeState buildTree = new BuildTreeState(buildInvocationScopeId, buildSession.getServices(), modelServices);){
                result = (BuildActionRunner.Result)buildTree.run(context -> context.execute(action));
            }
        }
        catch (Throwable t) {
            if (result == null) {
                throw UncheckedException.throwAsUncheckedException(t);
            }
            throw UncheckedException.throwAsUncheckedException(result.addFailure(t).getBuildFailure());
        }
        return result;
    }

    private BuildActionModelRequirements buildActionModelRequirementsFor(BuildAction action) {
        if (action instanceof BuildModelAction && action.isCreateModel()) {
            BuildModelAction buildModelAction = (BuildModelAction)action;
            String payload = buildModelAction.getModelName();
            return new QueryModelRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        if (action instanceof ClientProvidedBuildAction) {
            SerializedPayload payload = ((ClientProvidedBuildAction)action).getAction();
            return new RunActionRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        if (action instanceof ClientProvidedPhasedAction) {
            SerializedPayload payload = ((ClientProvidedPhasedAction)action).getPhasedAction();
            return new RunPhasedActionRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        return new RunTasksRequirements(action.getStartParameter());
    }

    private Supplier<HashCode> payloadHashProvider(Object payload) {
        ValueSnapshotter valueSnapshotter = this.valueSnapshotter;
        return () -> Hashing.hashHashable((Hashable)valueSnapshotter.snapshot(payload));
    }
}

