/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.apache.tools.ant.types.optional.imageio.ColorMapper;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;

public class Text
extends ImageOperation
implements DrawOperation {
    private static final int DEFAULT_POINT = 10;
    private String string = "";
    private String font = "Arial";
    private int point = 10;
    private boolean bold = false;
    private boolean italic = false;
    private String color = "black";

    public void setString(String str) {
        this.string = str;
    }

    public void setFont(String f) {
        this.font = f;
    }

    public void setPoint(String p) {
        this.point = Integer.parseInt(p);
    }

    public void setColor(String c) {
        this.color = c;
    }

    public void setBold(boolean state) {
        this.bold = state;
    }

    public void setItalic(boolean state) {
        this.italic = state;
    }

    @Override
    public BufferedImage executeDrawOperation() {
        this.log("\tCreating Text \"" + this.string + "\"");
        int width = 1;
        int height = 1;
        BufferedImage bi = new BufferedImage(width, height, 7);
        Graphics2D graphics = bi.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Font f = this.createFont();
        FontMetrics fmetrics = graphics.getFontMetrics(f);
        height = fmetrics.getMaxAscent() + fmetrics.getMaxDescent();
        width = fmetrics.stringWidth(this.string);
        bi = new BufferedImage(width, height, 7);
        graphics = bi.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setFont(f);
        graphics.setColor(ColorMapper.getColorByName(this.color));
        graphics.drawString(this.string, 0, height - fmetrics.getMaxDescent());
        return bi;
    }

    private Font createFont() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        }
        if (this.italic) {
            style |= 2;
        }
        return new Font(this.font, style, this.point);
    }
}

