#ifndef FRT_INTERNAL_H
#define FRT_INTERNAL_H

/* Constants */
#define ABS                                FRT_ABS
#define ALLOC_AND_ZERO                     FRT_ALLOC_AND_ZERO
#define ALLOC_AND_ZERO_N                   FRT_ALLOC_AND_ZERO_N
#define ARG_ERROR                          FRT_ARG_ERROR
#define ARY_INIT_CAPA                      FRT_ARY_INIT_CAPA
#define ARY_META_CNT                       FRT_ARY_META_CNT
#define ATTR_ALWAYS_INLINE                 FRT_ATTR_ALWAYS_INLINE
#define ATTR_CONST                         FRT_ATTR_CONST
#define ATTR_PURE                          FRT_ATTR_PURE
#define BC_MUST                            FRT_BC_MUST
#define BC_MUST_NOT                        FRT_BC_MUST_NOT
#define BC_SHOULD                          FRT_BC_SHOULD
#define BODY                               FRT_BODY
#define BOOLEAN_CLAUSES_START_CAPA         FRT_BOOLEAN_CLAUSES_START_CAPA
#define BOOLEAN_QUERY                      FRT_BOOLEAN_QUERY
#define BUFFER_SIZE                        FRT_BUFFER_SIZE
#define BV_INIT_CAPA                       FRT_BV_INIT_CAPA
#define BV_OP                              FRT_BV_OP
#define BYTE_FIELD_INDEX_CLASS             FRT_BYTE_FIELD_INDEX_CLASS
#define COMMIT_LOCK_NAME                   FRT_COMMIT_LOCK_NAME
#define CONSTANT_QUERY                     FRT_CONSTANT_QUERY
#define CW_INIT_CAPA                       FRT_CW_INIT_CAPA
#define DBL2S                              FRT_DBL2S
#define DEFAULT_MAX_CLAUSE_COUNT           FRT_DEFAULT_MAX_CLAUSE_COUNT
#define DEF_MAX_TERMS                      FRT_DEF_MAX_TERMS
#define DEF_MIN_SIM                        FRT_DEF_MIN_SIM
#define DEF_PRE_LEN                        FRT_DEF_PRE_LEN
#define DEREF                              FRT_DEREF
#define DF_INIT_CAPA                       FRT_DF_INIT_CAPA
#define DOC_INIT_CAPA                      FRT_DOC_INIT_CAPA
#define EMPTY_STRING                       FRT_EMPTY_STRING
#define ENDTRY                             FRT_ENDTRY
#define ENGLISH_STOP_WORDS                 FRT_ENGLISH_STOP_WORDS
#define EOF_ERROR                          FRT_EOF_ERROR
#define EOF_ERROR_MSG                      FRT_EOF_ERROR_MSG
#define EXCEPTION                          FRT_EXCEPTION
#define EXCEPT_H                           FRT_EXCEPT_H
#define EXPLANATION_DETAILS_START_SIZE     FRT_EXPLANATION_DETAILS_START_SIZE
#define EXTENDED_ENGLISH_STOP_WORDS        FRT_EXTENDED_ENGLISH_STOP_WORDS
#define EXTERNC                            FRT_EXTERNC
#define FERRET_ERROR                       FRT_FERRET_ERROR
#define FILE_NOT_FOUND_ERROR               FRT_FILE_NOT_FOUND_ERROR
#define FILTERED_QUERY                     FRT_FILTERED_QUERY
#define FINALLY                            FRT_FINALLY
#define FI_IS_COMPRESSED_BM                FRT_FI_IS_COMPRESSED_BM
#define FI_IS_INDEXED_BM                   FRT_FI_IS_INDEXED_BM
#define FI_IS_STORED_BM                    FRT_FI_IS_STORED_BM
#define FI_IS_TOKENIZED_BM                 FRT_FI_IS_TOKENIZED_BM
#define FI_OMIT_NORMS_BM                   FRT_FI_OMIT_NORMS_BM
#define FI_STORE_OFFSETS_BM                FRT_FI_STORE_OFFSETS_BM
#define FI_STORE_POSITIONS_BM              FRT_FI_STORE_POSITIONS_BM
#define FI_STORE_TERM_VECTOR_BM            FRT_FI_STORE_TERM_VECTOR_BM
#define FLOAT_FIELD_INDEX_CLASS            FRT_FLOAT_FIELD_INDEX_CLASS
#define FULL_DANISH_STOP_WORDS             FRT_FULL_DANISH_STOP_WORDS
#define FULL_DUTCH_STOP_WORDS              FRT_FULL_DUTCH_STOP_WORDS
#define FULL_ENGLISH_STOP_WORDS            FRT_FULL_ENGLISH_STOP_WORDS
#define FULL_FINNISH_STOP_WORDS            FRT_FULL_FINNISH_STOP_WORDS
#define FULL_FRENCH_STOP_WORDS             FRT_FULL_FRENCH_STOP_WORDS
#define FULL_GERMAN_STOP_WORDS             FRT_FULL_GERMAN_STOP_WORDS
#define FULL_HUNGARIAN_STOP_WORDS          FRT_FULL_HUNGARIAN_STOP_WORDS
#define FULL_ITALIAN_STOP_WORDS            FRT_FULL_ITALIAN_STOP_WORDS
#define FULL_NORWEGIAN_STOP_WORDS          FRT_FULL_NORWEGIAN_STOP_WORDS
#define FULL_PORTUGUESE_STOP_WORDS         FRT_FULL_PORTUGUESE_STOP_WORDS
#define FULL_RUSSIAN_STOP_WORDS            FRT_FULL_RUSSIAN_STOP_WORDS
#define FULL_RUSSIAN_STOP_WORDS_KOI8_R     FRT_FULL_RUSSIAN_STOP_WORDS_KOI8_R
#define FULL_SPANISH_STOP_WORDS            FRT_FULL_SPANISH_STOP_WORDS
#define FULL_SWEDISH_STOP_WORDS            FRT_FULL_SWEDISH_STOP_WORDS
#define FUZZY_QUERY                        FRT_FUZZY_QUERY
#define HANDLED                            FRT_HANDLED
#define HASH_KEY_DOES_NOT_EXIST            FRT_HASH_KEY_DOES_NOT_EXIST
#define HASH_KEY_EQUAL                     FRT_HASH_KEY_EQUAL
#define HASH_KEY_SAME                      FRT_HASH_KEY_SAME
#define HASH_MINSIZE                       FRT_HASH_MINSIZE
#define HAS_GNUC_VARARGS                   FRT_HAS_GNUC_VARARGS
#define HAS_ISO_VARARGS                    FRT_HAS_ISO_VARARGS
#define HAS_VARARGS                        FRT_HAS_VARARGS
#define HS_MIN_SIZE                        FRT_HS_MIN_SIZE
#define I                                  FRT_I
#define INDEX_ERROR                        FRT_INDEX_ERROR
#define INDEX_INTERVAL                     FRT_INDEX_INTERVAL
#define INDEX_NO                           FRT_INDEX_NO
#define INDEX_UNTOKENIZED                  FRT_INDEX_UNTOKENIZED
#define INDEX_UNTOKENIZED_OMIT_NORMS       FRT_INDEX_UNTOKENIZED_OMIT_NORMS
#define INDEX_YES                          FRT_INDEX_YES
#define INDEX_YES_OMIT_NORMS               FRT_INDEX_YES_OMIT_NORMS
#define INLINE                             FRT_INLINE
#define INTEGER_FIELD_INDEX_CLASS          FRT_INTEGER_FIELD_INDEX_CLASS
#define IO_ERROR                           FRT_IO_ERROR
#define IS_C99                             FRT_IS_C99
#define LOCK_ERROR                         FRT_LOCK_ERROR
#define LOCK_EXT                           FRT_LOCK_EXT
#define LOCK_PREFIX                        FRT_LOCK_PREFIX
#define MATCH_ALL_QUERY                    FRT_MATCH_ALL_QUERY
#define MATCH_VECTOR_INIT_CAPA             FRT_MATCH_VECTOR_INIT_CAPA
#define MAX                                FRT_MAX
#define MAX3                               FRT_MAX3
#define MAX_FILE_PATH                      FRT_MAX_FILE_PATH
#define MAX_WORD_SIZE                      FRT_MAX_WORD_SIZE
#define MEM_ERROR                          FRT_MEM_ERROR
#define MIN                                FRT_MIN
#define MIN3                               FRT_MIN3
#define MP_ALLOC                           FRT_MP_ALLOC
#define MP_ALLOC_AND_ZERO                  FRT_MP_ALLOC_AND_ZERO
#define MP_ALLOC_AND_ZERO_N                FRT_MP_ALLOC_AND_ZERO_N
#define MP_ALLOC_N                         FRT_MP_ALLOC_N
#define MP_BUF_SIZE                        FRT_MP_BUF_SIZE
#define MP_INIT_CAPA                       FRT_MP_INIT_CAPA
#define MULTI_TERM_QUERY                   FRT_MULTI_TERM_QUERY
#define MULTI_TERM_QUERY_MAX_TERMS         FRT_MULTI_TERM_QUERY_MAX_TERMS
#define MUTEX_INITIALIZER                  FRT_MUTEX_INITIALIZER
#define MUTEX_RECURSIVE_INITIALIZER        FRT_MUTEX_RECURSIVE_INITIALIZER
#define NELEMS                             FRT_NELEMS
#define NEXT_NUM                           FRT_NEXT_NUM
#define OFF_T_PFX                          FRT_OFF_T_PFX
#define PARSE_ERROR                        FRT_PARSE_ERROR
#define PHQ_INIT_CAPA                      FRT_PHQ_INIT_CAPA
#define PHRASE_QUERY                       FRT_PHRASE_QUERY
#define PQ_ADDED                           FRT_PQ_ADDED
#define PQ_DROPPED                         FRT_PQ_DROPPED
#define PQ_INSERTED                        FRT_PQ_INSERTED
#define PREFIX_QUERY                       FRT_PREFIX_QUERY
#define PREFIX_QUERY_MAX_TERMS             FRT_PREFIX_QUERY_MAX_TERMS
#define PREV_NUM                           FRT_PREV_NUM
#define QP_CONC_WORDS                      FRT_QP_CONC_WORDS
#define QP_MAX_CLAUSES                     FRT_QP_MAX_CLAUSES
#define QUERY_STRING_START_SIZE            FRT_QUERY_STRING_START_SIZE
#define RAISE                              FRT_RAISE
#define RANGE_QUERY                        FRT_RANGE_QUERY
#define RECAPA                             FRT_RECAPA
#define REF                                FRT_REF
#define RETURN_EARLY                       FRT_RETURN_EARLY
#define S                                  FRT_S
#define SCANNER                            FRT_SCANNER
#define SCORER_NULLIFY                     FRT_SCORER_NULLIFY
#define SEGMENTS_FILE_NAME                 FRT_SEGMENTS_FILE_NAME
#define SEGMENT_NAME_MAX_LENGTH            FRT_SEGMENT_NAME_MAX_LENGTH
#define SKIP_INTERVAL                      FRT_SKIP_INTERVAL
#define SLOW_DOWN                          FRT_SLOW_DOWN
#define SORT_FIELD_DOC                     FRT_SORT_FIELD_DOC
#define SORT_FIELD_DOC_REV                 FRT_SORT_FIELD_DOC_REV
#define SORT_FIELD_SCORE                   FRT_SORT_FIELD_SCORE
#define SORT_FIELD_SCORE_REV               FRT_SORT_FIELD_SCORE_REV
#define SORT_TYPE_AUTO                     FRT_SORT_TYPE_AUTO
#define SORT_TYPE_BYTE                     FRT_SORT_TYPE_BYTE
#define SORT_TYPE_DOC                      FRT_SORT_TYPE_DOC
#define SORT_TYPE_FLOAT                    FRT_SORT_TYPE_FLOAT
#define SORT_TYPE_INTEGER                  FRT_SORT_TYPE_INTEGER
#define SORT_TYPE_SCORE                    FRT_SORT_TYPE_SCORE
#define SORT_TYPE_STRING                   FRT_SORT_TYPE_STRING
#define SPAN_FIRST_QUERY                   FRT_SPAN_FIRST_QUERY
#define SPAN_MULTI_TERM_QUERY              FRT_SPAN_MULTI_TERM_QUERY
#define SPAN_MULTI_TERM_QUERY_CAPA         FRT_SPAN_MULTI_TERM_QUERY_CAPA
#define SPAN_NEAR_QUERY                    FRT_SPAN_NEAR_QUERY
#define SPAN_NOT_QUERY                     FRT_SPAN_NOT_QUERY
#define SPAN_OR_QUERY                      FRT_SPAN_OR_QUERY
#define SPAN_PREFIX_QUERY                  FRT_SPAN_PREFIX_QUERY
#define SPAN_PREFIX_QUERY_MAX_TERMS        FRT_SPAN_PREFIX_QUERY_MAX_TERMS
#define SPAN_TERM_QUERY                    FRT_SPAN_TERM_QUERY
#define STATE_ERROR                        FRT_STATE_ERROR
#define STORE_COMPRESS                     FRT_STORE_COMPRESS
#define STORE_NO                           FRT_STORE_NO
#define STORE_YES                          FRT_STORE_YES
#define STRING_FIELD_INDEX_CLASS           FRT_STRING_FIELD_INDEX_CLASS
#define STT_ASCII                          FRT_STT_ASCII
#define STT_MB                             FRT_STT_MB
#define STT_UTF8                           FRT_STT_UTF8
#define TERM_QUERY                         FRT_TERM_QUERY
#define TERM_VECTOR_NO                     FRT_TERM_VECTOR_NO
#define TERM_VECTOR_WITH_OFFSETS           FRT_TERM_VECTOR_WITH_OFFSETS
#define TERM_VECTOR_WITH_POSITIONS         FRT_TERM_VECTOR_WITH_POSITIONS
#define TERM_VECTOR_WITH_POSITIONS_OFFSETS FRT_TERM_VECTOR_WITH_POSITIONS_OFFSETS
#define TERM_VECTOR_YES                    FRT_TERM_VECTOR_YES
#define TE_BUCKET_INIT_CAPA                FRT_TE_BUCKET_INIT_CAPA
#define THREAD_ONCE_INIT                   FRT_THREAD_ONCE_INIT
#define TO_WORD                            FRT_TO_WORD
#define TRY                                FRT_TRY
#define TV_FIELD_INIT_CAPA                 FRT_TV_FIELD_INIT_CAPA
#define TYPED_RANGE_QUERY                  FRT_TYPED_RANGE_QUERY
#define TYPICAL_LONGEST_WORD               FRT_TYPICAL_LONGEST_WORD
#define UNSUPPORTED_ERROR                  FRT_UNSUPPORTED_ERROR
#define UNSUPPORTED_ERROR_MSG              FRT_UNSUPPORTED_ERROR_MSG
#define VEXIT                              FRT_VEXIT
#define WILD_CARD_QUERY                    FRT_WILD_CARD_QUERY
#define WILD_CARD_QUERY_MAX_TERMS          FRT_WILD_CARD_QUERY_MAX_TERMS
#define WILD_CHAR                          FRT_WILD_CHAR
#define WILD_STRING                        FRT_WILD_STRING
#define WRITE_LOCK_NAME                    FRT_WRITE_LOCK_NAME
#define XCATCHALL                          FRT_XCATCHALL
#define XENDTRY                            FRT_XENDTRY
#define XEXIT                              FRT_XEXIT
#define XFINALLY                           FRT_XFINALLY
#define XMSG_BUFFER_SIZE                   FRT_XMSG_BUFFER_SIZE
#define ZEROSET                            FRT_ZEROSET
#define ZEROSET_N                          FRT_ZEROSET_N

/* Types */
#define Analyzer                FrtAnalyzer
#define BCType                  FrtBCType
#define BitVector               FrtBitVector
#define BooleanClause           FrtBooleanClause
#define BooleanQuery            FrtBooleanQuery
#define Boost                   FrtBoost
#define Buffer                  FrtBuffer
#define CWFileEntry             FrtCWFileEntry
#define CacheObject             FrtCacheObject
#define CachedTokenStream       FrtCachedTokenStream
#define Comparable              FrtComparable
#define CompoundInStream        FrtCompoundInStream
#define CompoundStore           FrtCompoundStore
#define CompoundWriter          FrtCompoundWriter
#define Config                  FrtConfig
#define ConstantScoreQuery      FrtConstantScoreQuery
#define DelTerm                 FrtDelTerm
#define Deleter                 FrtDeleter
#define DeterministicState      FrtDeterministicState
#define DocField                FrtDocField
#define DocWriter               FrtDocWriter
#define Document                FrtDocument
#define Explanation             FrtExplanation
#define FieldDoc                FrtFieldDoc
#define FieldIndex              FrtFieldIndex
#define FieldIndexClass         FrtFieldIndexClass
#define FieldInfo               FrtFieldInfo
#define FieldInfos              FrtFieldInfos
#define FieldInverter           FrtFieldInverter
#define FieldStack              FrtFieldStack
#define FieldsReader            FrtFieldsReader
#define FieldsWriter            FrtFieldsWriter
#define Filter                  FrtFilter
#define FilteredQuery           FrtFilteredQuery
#define FuzzyQuery              FrtFuzzyQuery
#define Hash                    FrtHash
#define HashEntry               FrtHashEntry
#define HashKeyStatus           FrtHashKeyStatus
#define HashSet                 FrtHashSet
#define HashSetEntry            FrtHashSetEntry
#define Hit                     FrtHit
#define HyphenFilter            FrtHyphenFilter
#define InStream                FrtInStream
#define InStreamMethods         FrtInStreamMethods
#define Index                   FrtIndex
#define IndexReader             FrtIndexReader
#define IndexSearcher           FrtIndexSearcher
#define IndexValue              FrtIndexValue
#define IndexWriter             FrtIndexWriter
#define LazyDoc                 FrtLazyDoc
#define LazyDocField            FrtLazyDocField
#define LazyDocFieldData        FrtLazyDocFieldData
#define LegacyStandardTokenizer FrtLegacyStandardTokenizer
#define Lock                    FrtLock
#define MTQMaxTerms             FrtMTQMaxTerms
#define MTQSubQuery             FrtMTQSubQuery
#define Mapping                 FrtMapping
#define MappingFilter           FrtMappingFilter
#define MatchAllQuery           FrtMatchAllQuery
#define MatchRange              FrtMatchRange
#define MatchVector             FrtMatchVector
#define MemoryPool              FrtMemoryPool
#define MultiByteTokenStream    FrtMultiByteTokenStream
#define MultiMapper             FrtMultiMapper
#define MultiReader             FrtMultiReader
#define MultiSearcher           FrtMultiSearcher
#define MultiTermQuery          FrtMultiTermQuery
#define Occurence               FrtOccurence
#define Offset                  FrtOffset
#define OutStream               FrtOutStream
#define OutStreamMethods        FrtOutStreamMethods
#define PerFieldAnalyzer        FrtPerFieldAnalyzer
#define PhrasePosition          FrtPhrasePosition
#define PhraseQuery             FrtPhraseQuery
#define PostFilter              FrtPostFilter
#define Posting                 FrtPosting
#define PostingList             FrtPostingList
#define PrefixQuery             FrtPrefixQuery
#define PriorityQueue           FrtPriorityQueue
#define PriorityQueueInsertEnum FrtPriorityQueueInsertEnum
#define QParser                 FrtQParser
#define Query                   FrtQuery
#define QueryParser             FrtQueryParser
#define QueryType               FrtQueryType
#define RAMFile                 FrtRAMFile
#define RangeQuery              FrtRangeQuery
#define Scorer                  FrtScorer
#define Searcher                FrtSearcher
#define SegmentFieldIndex       FrtSegmentFieldIndex
#define SegmentInfo             FrtSegmentInfo
#define SegmentInfos            FrtSegmentInfos
#define SegmentTermDocEnum      FrtSegmentTermDocEnum
#define SegmentTermEnum         FrtSegmentTermEnum
#define SegmentTermIndex        FrtSegmentTermIndex
#define Similarity              FrtSimilarity
#define Sort                    FrtSort
#define SortField               FrtSortField
#define SpanEnum                FrtSpanEnum
#define SpanFirstQuery          FrtSpanFirstQuery
#define SpanMultiTermQuery      FrtSpanMultiTermQuery
#define SpanNearQuery           FrtSpanNearQuery
#define SpanNotQuery            FrtSpanNotQuery
#define SpanOrQuery             FrtSpanOrQuery
#define SpanPrefixQuery         FrtSpanPrefixQuery
#define SpanQuery               FrtSpanQuery
#define SpanTermQuery           FrtSpanTermQuery
#define StandardTokenizer       FrtStandardTokenizer
#define StandardTokenizerType   FrtStandardTokenizerType
#define State                   FrtState
#define StemFilter              FrtStemFilter
#define StopFilter              FrtStopFilter
#define Store                   FrtStore
#define StoreValue              FrtStoreValue
#define StringIndex             FrtStringIndex
#define Symbol                  FrtSymbol
#define TVField                 FrtTVField
#define TVTerm                  FrtTVTerm
#define Term                    FrtTerm
#define TermDocEnum             FrtTermDocEnum
#define TermEnum                FrtTermEnum
#define TermInfo                FrtTermInfo
#define TermInfosReader         FrtTermInfosReader
#define TermInfosWriter         FrtTermInfosWriter
#define TermQuery               FrtTermQuery
#define TermVector              FrtTermVector
#define TermVectorValue         FrtTermVectorValue
#define TermWriter              FrtTermWriter
#define Token                   FrtToken
#define TokenFilter             FrtTokenFilter
#define TokenStream             FrtTokenStream
#define TopDocs                 FrtTopDocs
#define TypedRangeQuery         FrtTypedRangeQuery
#define Weight                  FrtWeight
#define WildCardQuery           FrtWildCardQuery
#define __Symbol                Frt__Symbol

/* Functions */
#define a_deref                                        frt_a_deref
#define a_get_ts                                       frt_a_get_ts
#define a_standard_destroy                             frt_a_standard_destroy
#define analyzer_new                                   frt_analyzer_new
#define ary_capa                                       frt_ary_capa
#define ary_delete                                     frt_ary_delete
#define ary_delete_i                                   frt_ary_delete_i
#define ary_destroy                                    frt_ary_destroy
#define ary_destroy_i                                  frt_ary_destroy_i
#define ary_each                                       frt_ary_each
#define ary_each_rev                                   frt_ary_each_rev
#define ary_free                                       frt_ary_free
#define ary_get                                        frt_ary_get
#define ary_get_i                                      frt_ary_get_i
#define ary_grow                                       frt_ary_grow
#define ary_last                                       frt_ary_last
#define ary_new                                        frt_ary_new
#define ary_new_capa                                   frt_ary_new_capa
#define ary_new_i                                      frt_ary_new_i
#define ary_new_type                                   frt_ary_new_type
#define ary_new_type_capa                              frt_ary_new_type_capa
#define ary_pop                                        frt_ary_pop
#define ary_pop_i                                      frt_ary_pop_i
#define ary_push                                       frt_ary_push
#define ary_push_i                                     frt_ary_push_i
#define ary_remove                                     frt_ary_remove
#define ary_remove_i                                   frt_ary_remove_i
#define ary_resize                                     frt_ary_resize
#define ary_resize_i                                   frt_ary_resize_i
#define ary_rsz                                        frt_ary_rsz
#define ary_set                                        frt_ary_set
#define ary_set_i                                      frt_ary_set_i
#define ary_shift                                      frt_ary_shift
#define ary_shift_i                                    frt_ary_shift_i
#define ary_size                                       frt_ary_size
#define ary_sort                                       frt_ary_sort
#define ary_start                                      frt_ary_start
#define ary_sz                                         frt_ary_sz
#define ary_type_size                                  frt_ary_type_size
#define ary_unshift                                    frt_ary_unshift
#define ary_unshift_i                                  frt_ary_unshift_i
#define bc_deref                                       frt_bc_deref
#define bc_new                                         frt_bc_new
#define bc_set_occur                                   frt_bc_set_occur
#define bq_add_clause                                  frt_bq_add_clause
#define bq_add_clause_nr                               frt_bq_add_clause_nr
#define bq_add_query                                   frt_bq_add_query
#define bq_add_query_nr                                frt_bq_add_query_nr
#define bq_new                                         frt_bq_new
#define bq_new_max                                     frt_bq_new_max
#define bv_and                                         frt_bv_and
#define bv_and_ext                                     frt_bv_and_ext
#define bv_and_i                                       frt_bv_and_i
#define bv_and_x                                       frt_bv_and_x
#define bv_capa                                        frt_bv_capa
#define bv_clear                                       frt_bv_clear
#define bv_destroy                                     frt_bv_destroy
#define bv_eq                                          frt_bv_eq
#define bv_get                                         frt_bv_get
#define bv_hash                                        frt_bv_hash
#define bv_new                                         frt_bv_new
#define bv_new_capa                                    frt_bv_new_capa
#define bv_not                                         frt_bv_not
#define bv_not_i                                       frt_bv_not_i
#define bv_not_x                                       frt_bv_not_x
#define bv_or                                          frt_bv_or
#define bv_or_ext                                      frt_bv_or_ext
#define bv_or_i                                        frt_bv_or_i
#define bv_or_x                                        frt_bv_or_x
#define bv_recount                                     frt_bv_recount
#define bv_scan_next                                   frt_bv_scan_next
#define bv_scan_next_from                              frt_bv_scan_next_from
#define bv_scan_next_unset                             frt_bv_scan_next_unset
#define bv_scan_next_unset_from                        frt_bv_scan_next_unset_from
#define bv_scan_reset                                  frt_bv_scan_reset
#define bv_set                                         frt_bv_set
#define bv_set_fast                                    frt_bv_set_fast
#define bv_set_value                                   frt_bv_set_value
#define bv_unset                                       frt_bv_unset
#define bv_xor                                         frt_bv_xor
#define bv_xor_ext                                     frt_bv_xor_ext
#define bv_xor_i                                       frt_bv_xor_i
#define bv_xor_x                                       frt_bv_xor_x
#define byte2float                                     frt_byte2float
#define cache_destroy                                  frt_cache_destroy
#define clean_up                                       frt_clean_up
#define close_lock                                     frt_close_lock
#define co_create                                      frt_co_create
#define co_hash_create                                 frt_co_hash_create
#define count_leading_ones                             frt_count_leading_ones
#define count_leading_zeros                            frt_count_leading_zeros
#define count_ones                                     frt_count_ones
#define count_trailing_ones                            frt_count_trailing_ones
#define count_trailing_zeros                           frt_count_trailing_zeros
#define count_zeros                                    frt_count_zeros
#define csq_new                                        frt_csq_new
#define csq_new_nr                                     frt_csq_new_nr
#define cw_add_file                                    frt_cw_add_file
#define cw_close                                       frt_cw_close
#define dbl_to_s                                       frt_dbl_to_s
#define default_config                                 frt_default_config
#define deleter_clear_pending_files                    frt_deleter_clear_pending_files
#define deleter_commit_pending_files                   frt_deleter_commit_pending_files
#define deleter_delete_file                            frt_deleter_delete_file
#define deleter_delete_files                           frt_deleter_delete_files
#define deleter_destroy                                frt_deleter_destroy
#define deleter_find_deletable_files                   frt_deleter_find_deletable_files
#define deleter_new                                    frt_deleter_new
#define df_add_data                                    frt_df_add_data
#define df_add_data_len                                frt_df_add_data_len
#define df_destroy                                     frt_df_destroy
#define df_new                                         frt_df_new
#define df_to_s                                        frt_df_to_s
#define do_clean_up                                    frt_do_clean_up
#define doc_add_field                                  frt_doc_add_field
#define doc_destroy                                    frt_doc_destroy
#define doc_get_field                                  frt_doc_get_field
#define doc_new                                        frt_doc_new
#define doc_to_s                                       frt_doc_to_s
#define dummy_free                                     frt_dummy_free
#define dw_add_doc                                     frt_dw_add_doc
#define dw_close                                       frt_dw_close
#define dw_get_fld_inv                                 frt_dw_get_fld_inv
#define dw_invert_field                                frt_dw_invert_field
#define dw_new_segment                                 frt_dw_new_segment
#define dw_open                                        frt_dw_open
#define dw_reset_postings                              frt_dw_reset_postings
#define ecalloc                                        frt_ecalloc
#define emalloc                                        frt_emalloc
#define ensure_reader_open                             frt_ensure_reader_open
#define ensure_searcher_open                           frt_ensure_searcher_open
#define ensure_writer_open                             frt_ensure_writer_open
#define epstrdup                                       frt_epstrdup
#define eq_ft                                          frt_eq_ft
#define erealloc                                       frt_erealloc
#define estrcat                                        frt_estrcat
#define estrdup                                        frt_estrdup
#define expl_add_detail                                frt_expl_add_detail
#define expl_destroy                                   frt_expl_destroy
#define expl_new                                       frt_expl_new
#define expl_to_html                                   frt_expl_to_html
#define expl_to_s                                      frt_expl_to_s
#define expl_to_s_depth                                frt_expl_to_s_depth
#define fd_destroy                                     frt_fd_destroy
#define fdshq_lt                                       frt_fdshq_lt
#define fi_deref                                       frt_fi_deref
#define fi_new                                         frt_fi_new
#define fi_to_s                                        frt_fi_to_s
#define field_index_get                                frt_field_index_get
#define file_is_lock                                   frt_file_is_lock
#define file_name_filter_is_index_file                 frt_file_name_filter_is_index_file
#define filt_create                                    frt_filt_create
#define filt_deref                                     frt_filt_deref
#define filt_destroy_i                                 frt_filt_destroy_i
#define filt_eq                                        frt_filt_eq
#define filt_get_bv                                    frt_filt_get_bv
#define filt_hash                                      frt_filt_hash
#define filter_clone_size                              frt_filter_clone_size
#define filter_ft                                      frt_filter_ft
#define fis_add_field                                  frt_fis_add_field
#define fis_by_number                                  frt_fis_by_number
#define fis_deref                                      frt_fis_deref
#define fis_get_field                                  frt_fis_get_field
#define fis_get_field_num                              frt_fis_get_field_num
#define fis_get_or_add_field                           frt_fis_get_or_add_field
#define fis_new                                        frt_fis_new
#define fis_read                                       frt_fis_read
#define fis_to_s                                       frt_fis_to_s
#define fis_write                                      frt_fis_write
#define float2byte                                     frt_float2byte
#define float2int                                      frt_float2int
#define fn_for_generation                              frt_fn_for_generation
#define fq_new                                         frt_fq_new
#define fr_clone                                       frt_fr_clone
#define fr_close                                       frt_fr_close
#define fr_get_doc                                     frt_fr_get_doc
#define fr_get_field_tv                                frt_fr_get_field_tv
#define fr_get_lazy_doc                                frt_fr_get_lazy_doc
#define fr_get_tv                                      frt_fr_get_tv
#define fr_open                                        frt_fr_open
#define free_ft                                        frt_free_ft
#define fshq_pq_destroy                                frt_fshq_pq_destroy
#define fshq_pq_down                                   frt_fshq_pq_down
#define fshq_pq_insert                                 frt_fshq_pq_insert
#define fshq_pq_new                                    frt_fshq_pq_new
#define fshq_pq_pop                                    frt_fshq_pq_pop
#define fshq_pq_pop_fd                                 frt_fshq_pq_pop_fd
#define fuzq_new                                       frt_fuzq_new
#define fuzq_new_conf                                  frt_fuzq_new_conf
#define fuzq_score                                     frt_fuzq_score
#define fw_add_doc                                     frt_fw_add_doc
#define fw_add_postings                                frt_fw_add_postings
#define fw_close                                       frt_fw_close
#define fw_open                                        frt_fw_open
#define fw_write_tv_index                              frt_fw_write_tv_index
#define get_float_value                                frt_get_float_value
#define get_integer_value                              frt_get_integer_value
#define get_stacktrace                                 frt_get_stacktrace
#define get_string_value                               frt_get_string_value
#define h_clear                                        frt_h_clear
#define h_clone                                        frt_h_clone
#define h_clone_ft                                     frt_h_clone_ft
#define h_del                                          frt_h_del
#define h_del_int                                      frt_h_del_int
#define h_destroy                                      frt_h_destroy
#define h_each                                         frt_h_each
#define h_each_key_val_ft                              frt_h_each_key_val_ft
#define h_get                                          frt_h_get
#define h_get_int                                      frt_h_get_int
#define h_has_key                                      frt_h_has_key
#define h_has_key_int                                  frt_h_has_key_int
#define h_lookup                                       frt_h_lookup
#define h_lookup_ft                                    frt_h_lookup_ft
#define h_new                                          frt_h_new
#define h_new_int                                      frt_h_new_int
#define h_new_ptr                                      frt_h_new_ptr
#define h_new_str                                      frt_h_new_str
#define h_rem                                          frt_h_rem
#define h_rem_int                                      frt_h_rem_int
#define h_set                                          frt_h_set
#define h_set_ext                                      frt_h_set_ext
#define h_set_int                                      frt_h_set_int
#define h_set_safe                                     frt_h_set_safe
#define h_set_safe_int                                 frt_h_set_safe_int
#define h_str_print_keys                               frt_h_str_print_keys
#define hash_finalize                                  frt_hash_finalize
#define hash_ft                                        frt_hash_ft
#define hlp_string_diff                                frt_hlp_string_diff
#define hs_add                                         frt_hs_add
#define hs_add_safe                                    frt_hs_add_safe
#define hs_clear                                       frt_hs_clear
#define hs_del                                         frt_hs_del
#define hs_destroy                                     frt_hs_destroy
#define hs_exists                                      frt_hs_exists
#define hs_free                                        frt_hs_free
#define hs_merge                                       frt_hs_merge
#define hs_new                                         frt_hs_new
#define hs_new_ptr                                     frt_hs_new_ptr
#define hs_new_str                                     frt_hs_new_str
#define hs_orig                                        frt_hs_orig
#define hs_rem                                         frt_hs_rem
#define hyphen_filter_new                              frt_hyphen_filter_new
#define i16                                            frt_i16
#define i32                                            frt_i32
#define i64                                            frt_i64
#define icmp                                           frt_icmp
#define icmp_risky                                     frt_icmp_risky
#define imalloc                                        frt_imalloc
#define index_add_array                                frt_index_add_array
#define index_add_doc                                  frt_index_add_doc
#define index_add_string                               frt_index_add_string
#define index_auto_flush_ir                            frt_index_auto_flush_ir
#define index_auto_flush_iw                            frt_index_auto_flush_iw
#define index_create                                   frt_index_create
#define index_delete                                   frt_index_delete
#define index_delete_id                                frt_index_delete_id
#define index_delete_query                             frt_index_delete_query
#define index_delete_query_str                         frt_index_delete_query_str
#define index_delete_term                              frt_index_delete_term
#define index_destroy                                  frt_index_destroy
#define index_explain                                  frt_index_explain
#define index_flush                                    frt_index_flush
#define index_get_doc                                  frt_index_get_doc
#define index_get_doc_id                               frt_index_get_doc_id
#define index_get_doc_term                             frt_index_get_doc_term
#define index_get_doc_ts                               frt_index_get_doc_ts
#define index_get_query                                frt_index_get_query
#define index_has_del                                  frt_index_has_del
#define index_is_deleted                               frt_index_is_deleted
#define index_is_locked                                frt_index_is_locked
#define index_new                                      frt_index_new
#define index_optimize                                 frt_index_optimize
#define index_search_str                               frt_index_search_str
#define index_size                                     frt_index_size
#define index_term_id                                  frt_index_term_id
#define init                                           frt_init
#define int2float                                      frt_int2float
#define intern                                         frt_intern
#define intern_and_free                                frt_intern_and_free
#define ir_add_cache                                   frt_ir_add_cache
#define ir_close                                       frt_ir_close
#define ir_commit                                      frt_ir_commit
#define ir_create                                      frt_ir_create
#define ir_delete_doc                                  frt_ir_delete_doc
#define ir_destroy                                     frt_ir_destroy
#define ir_doc_freq                                    frt_ir_doc_freq
#define ir_get_doc_with_term                           frt_ir_get_doc_with_term
#define ir_get_field_num                               frt_ir_get_field_num
#define ir_get_norms                                   frt_ir_get_norms
#define ir_get_norms_i                                 frt_ir_get_norms_i
#define ir_get_norms_into                              frt_ir_get_norms_into
#define ir_index_exists                                frt_ir_index_exists
#define ir_is_latest                                   frt_ir_is_latest
#define ir_open                                        frt_ir_open
#define ir_set_norm                                    frt_ir_set_norm
#define ir_term_docs_for                               frt_ir_term_docs_for
#define ir_term_positions_for                          frt_ir_term_positions_for
#define ir_terms                                       frt_ir_terms
#define ir_terms_from                                  frt_ir_terms_from
#define ir_undelete_all                                frt_ir_undelete_all
#define is2os_copy_bytes                               frt_is2os_copy_bytes
#define is2os_copy_vints                               frt_is2os_copy_vints
#define is_clone                                       frt_is_clone
#define is_close                                       frt_is_close
#define is_new                                         frt_is_new
#define is_pos                                         frt_is_pos
#define is_read_byte                                   frt_is_read_byte
#define is_read_bytes                                  frt_is_read_bytes
#define is_read_i32                                    frt_is_read_i32
#define is_read_i64                                    frt_is_read_i64
#define is_read_string                                 frt_is_read_string
#define is_read_string_safe                            frt_is_read_string_safe
#define is_read_u32                                    frt_is_read_u32
#define is_read_u64                                    frt_is_read_u64
#define is_read_vint                                   frt_is_read_vint
#define is_read_vll                                    frt_is_read_vll
#define is_read_voff_t                                 frt_is_read_voff_t
#define is_seek                                        frt_is_seek
#define is_skip_vints                                  frt_is_skip_vints
#define isea_doc_freq                                  frt_isea_doc_freq
#define isea_new                                       frt_isea_new
#define iw_add_doc                                     frt_iw_add_doc
#define iw_add_readers                                 frt_iw_add_readers
#define iw_close                                       frt_iw_close
#define iw_commit                                      frt_iw_commit
#define iw_delete_term                                 frt_iw_delete_term
#define iw_delete_terms                                frt_iw_delete_terms
#define iw_doc_count                                   frt_iw_doc_count
#define iw_open                                        frt_iw_open
#define iw_optimize                                    frt_iw_optimize
#define lazy_df_get_bytes                              frt_lazy_df_get_bytes
#define lazy_df_get_data                               frt_lazy_df_get_data
#define lazy_doc_close                                 frt_lazy_doc_close
#define lazy_doc_get                                   frt_lazy_doc_get
#define legacy_standard_analyzer_new                   frt_legacy_standard_analyzer_new
#define legacy_standard_analyzer_new_with_words        frt_legacy_standard_analyzer_new_with_words
#define legacy_standard_analyzer_new_with_words_len    frt_legacy_standard_analyzer_new_with_words_len
#define legacy_standard_tokenizer_new                  frt_legacy_standard_tokenizer_new
#define letter_analyzer_new                            frt_letter_analyzer_new
#define letter_tokenizer_new                           frt_letter_tokenizer_new
#define lmalloc                                        frt_lmalloc
#define lowercase_filter_new                           frt_lowercase_filter_new
#define lt_ft                                          frt_lt_ft
#define mapping_filter_add                             frt_mapping_filter_add
#define mapping_filter_new                             frt_mapping_filter_new
#define maq_new                                        frt_maq_new
#define matchv_add                                     frt_matchv_add
#define matchv_compact                                 frt_matchv_compact
#define matchv_compact_with_breaks                     frt_matchv_compact_with_breaks
#define matchv_destroy                                 frt_matchv_destroy
#define matchv_new                                     frt_matchv_new
#define matchv_sort                                    frt_matchv_sort
#define max2                                           frt_max2
#define max3                                           frt_max3
#define mb_legacy_standard_analyzer_new                frt_mb_legacy_standard_analyzer_new
#define mb_legacy_standard_analyzer_new_with_words     frt_mb_legacy_standard_analyzer_new_with_words
#define mb_legacy_standard_analyzer_new_with_words_len frt_mb_legacy_standard_analyzer_new_with_words_len
#define mb_legacy_standard_tokenizer_new               frt_mb_legacy_standard_tokenizer_new
#define mb_letter_analyzer_new                         frt_mb_letter_analyzer_new
#define mb_letter_tokenizer_new                        frt_mb_letter_tokenizer_new
#define mb_lowercase_filter_new                        frt_mb_lowercase_filter_new
#define mb_standard_analyzer_new                       frt_mb_standard_analyzer_new
#define mb_standard_analyzer_new_with_words            frt_mb_standard_analyzer_new_with_words
#define mb_standard_analyzer_new_with_words_len        frt_mb_standard_analyzer_new_with_words_len
#define mb_standard_tokenizer_new                      frt_mb_standard_tokenizer_new
#define mb_whitespace_analyzer_new                     frt_mb_whitespace_analyzer_new
#define mb_whitespace_tokenizer_new                    frt_mb_whitespace_tokenizer_new
#define micro_sleep                                    frt_micro_sleep
#define min2                                           frt_min2
#define min3                                           frt_min3
#define mp_alloc                                       frt_mp_alloc
#define mp_destroy                                     frt_mp_destroy
#define mp_memdup                                      frt_mp_memdup
#define mp_new                                         frt_mp_new
#define mp_new_capa                                    frt_mp_new_capa
#define mp_reset                                       frt_mp_reset
#define mp_strdup                                      frt_mp_strdup
#define mp_strndup                                     frt_mp_strndup
#define mp_used                                        frt_mp_used
#define mr_get_field_num                               frt_mr_get_field_num
#define mr_open                                        frt_mr_open
#define msea_new                                       frt_msea_new
#define mtdpe_new                                      frt_mtdpe_new
#define mte_new                                        frt_mte_new
#define mulmap_add_mapping                             frt_mulmap_add_mapping
#define mulmap_compile                                 frt_mulmap_compile
#define mulmap_destroy                                 frt_mulmap_destroy
#define mulmap_dynamic_map                             frt_mulmap_dynamic_map
#define mulmap_map                                     frt_mulmap_map
#define mulmap_map_len                                 frt_mulmap_map_len
#define mulmap_new                                     frt_mulmap_new
#define multi_tq_add_term                              frt_multi_tq_add_term
#define multi_tq_add_term_boost                        frt_multi_tq_add_term_boost
#define multi_tq_new                                   frt_multi_tq_new
#define multi_tq_new_conf                              frt_multi_tq_new_conf
#define mutex_destroy                                  frt_mutex_destroy
#define mutex_init                                     frt_mutex_init
#define mutex_lock                                     frt_mutex_lock
#define mutex_t                                        frt_mutex_t
#define mutex_trylock                                  frt_mutex_trylock
#define mutex_unlock                                   frt_mutex_unlock
#define non_analyzer_new                               frt_non_analyzer_new
#define non_tokenizer_new                              frt_non_tokenizer_new
#define offset_new                                     frt_offset_new
#define open_cmpd_store                                frt_open_cmpd_store
#define open_cw                                        frt_open_cw
#define open_fs_store                                  frt_open_fs_store
#define open_lock                                      frt_open_lock
#define open_ram_store                                 frt_open_ram_store
#define open_ram_store_and_copy                        frt_open_ram_store_and_copy
#define os_close                                       frt_os_close
#define os_flush                                       frt_os_flush
#define os_new                                         frt_os_new
#define os_pos                                         frt_os_pos
#define os_seek                                        frt_os_seek
#define os_write_byte                                  frt_os_write_byte
#define os_write_bytes                                 frt_os_write_bytes
#define os_write_i32                                   frt_os_write_i32
#define os_write_i64                                   frt_os_write_i64
#define os_write_string                                frt_os_write_string
#define os_write_string_len                            frt_os_write_string_len
#define os_write_u32                                   frt_os_write_u32
#define os_write_u64                                   frt_os_write_u64
#define os_write_vint                                  frt_os_write_vint
#define os_write_vll                                   frt_os_write_vll
#define os_write_voff_t                                frt_os_write_voff_t
#define p_new                                          frt_p_new
#define per_field_analyzer_new                         frt_per_field_analyzer_new
#define pfa_add_field                                  frt_pfa_add_field
#define phq_add_term                                   frt_phq_add_term
#define phq_add_term_abs                               frt_phq_add_term_abs
#define phq_append_multi_term                          frt_phq_append_multi_term
#define phq_new                                        frt_phq_new
#define phq_set_slop                                   frt_phq_set_slop
#define pl_add_occ                                     frt_pl_add_occ
#define pl_cmp                                         frt_pl_cmp
#define pl_new                                         frt_pl_new
#define pq_clear                                       frt_pq_clear
#define pq_clone                                       frt_pq_clone
#define pq_destroy                                     frt_pq_destroy
#define pq_down                                        frt_pq_down
#define pq_free                                        frt_pq_free
#define pq_full                                        frt_pq_full
#define pq_insert                                      frt_pq_insert
#define pq_new                                         frt_pq_new
#define pq_pop                                         frt_pq_pop
#define pq_push                                        frt_pq_push
#define pq_top                                         frt_pq_top
#define prefixq_new                                    frt_prefixq_new
#define print_stacktrace                               frt_print_stacktrace
#define progname                                       frt_progname
#define ptr_eq                                         frt_ptr_eq
#define ptr_hash                                       frt_ptr_hash
#define q_combine                                      frt_q_combine
#define q_create                                       frt_q_create
#define q_create_weight_unsup                          frt_q_create_weight_unsup
#define q_deref                                        frt_q_deref
#define q_destroy_i                                    frt_q_destroy_i
#define q_eq                                           frt_q_eq
#define q_get_query_name                               frt_q_get_query_name
#define q_get_similarity_i                             frt_q_get_similarity_i
#define q_hash                                         frt_q_hash
#define q_new                                          frt_q_new
#define q_weight                                       frt_q_weight
#define qfilt_new                                      frt_qfilt_new
#define qfilt_new_nr                                   frt_qfilt_new_nr
#define qp_add_field                                   frt_qp_add_field
#define qp_clean_str                                   frt_qp_clean_str
#define qp_default_fuzzy_min_sim                       frt_qp_default_fuzzy_min_sim
#define qp_default_fuzzy_pre_len                       frt_qp_default_fuzzy_pre_len
#define qp_destroy                                     frt_qp_destroy
#define qp_new                                         frt_qp_new
#define qp_parse                                       frt_qp_parse
#define ram_destroy_buffer                             frt_ram_destroy_buffer
#define ram_new_buffer                                 frt_ram_new_buffer
#define ramo_length                                    frt_ramo_length
#define ramo_reset                                     frt_ramo_reset
#define ramo_write_to                                  frt_ramo_write_to
#define register_for_cleanup                           frt_register_for_cleanup
#define rfilt_new                                      frt_rfilt_new
#define round2                                         frt_round2
#define rq_new                                         frt_rq_new
#define rq_new_less                                    frt_rq_new_less
#define rq_new_more                                    frt_rq_new_more
#define scmp                                           frt_scmp
#define scorer_create                                  frt_scorer_create
#define scorer_destroy_i                               frt_scorer_destroy_i
#define scorer_doc_cmp                                 frt_scorer_doc_cmp
#define scorer_doc_less_than                           frt_scorer_doc_less_than
#define scorer_less_than                               frt_scorer_less_than
#define scorer_new                                     frt_scorer_new
#define searcher_close                                 frt_searcher_close
#define searcher_doc_freq                              frt_searcher_doc_freq
#define searcher_explain                               frt_searcher_explain
#define searcher_explain_w                             frt_searcher_explain_w
#define searcher_get_doc                               frt_searcher_get_doc
#define searcher_get_lazy_doc                          frt_searcher_get_lazy_doc
#define searcher_get_match_vector                      frt_searcher_get_match_vector
#define searcher_get_similarity                        frt_searcher_get_similarity
#define searcher_highlight                             frt_searcher_highlight
#define searcher_max_doc                               frt_searcher_max_doc
#define searcher_rewrite                               frt_searcher_rewrite
#define searcher_search                                frt_searcher_search
#define searcher_search_each                           frt_searcher_search_each
#define searcher_search_fd                             frt_searcher_search_fd
#define searcher_search_unscored                       frt_searcher_search_unscored
#define setprogname                                    frt_setprogname
#define sfi_close                                      frt_sfi_close
#define sfi_open                                       frt_sfi_open
#define si_advance_norm_gen                            frt_si_advance_norm_gen
#define si_deref                                       frt_si_deref
#define si_has_deletions                               frt_si_has_deletions
#define si_has_separate_norms                          frt_si_has_separate_norms
#define si_new                                         frt_si_new
#define si_uses_compound_file                          frt_si_uses_compound_file
#define sim_coord                                      frt_sim_coord
#define sim_create_default                             frt_sim_create_default
#define sim_decode_norm                                frt_sim_decode_norm
#define sim_destroy                                    frt_sim_destroy
#define sim_encode_norm                                frt_sim_encode_norm
#define sim_idf                                        frt_sim_idf
#define sim_idf_phrase                                 frt_sim_idf_phrase
#define sim_idf_term                                   frt_sim_idf_term
#define sim_length_norm                                frt_sim_length_norm
#define sim_query_norm                                 frt_sim_query_norm
#define sim_sloppy_freq                                frt_sim_sloppy_freq
#define sim_tf                                         frt_sim_tf
#define sis_add_si                                     frt_sis_add_si
#define sis_clear                                      frt_sis_clear
#define sis_curr_seg_file_name                         frt_sis_curr_seg_file_name
#define sis_current_segment_generation                 frt_sis_current_segment_generation
#define sis_del_at                                     frt_sis_del_at
#define sis_del_from_to                                frt_sis_del_from_to
#define sis_destroy                                    frt_sis_destroy
#define sis_new                                        frt_sis_new
#define sis_new_segment                                frt_sis_new_segment
#define sis_put                                        frt_sis_put
#define sis_read                                       frt_sis_read
#define sis_read_current_version                       frt_sis_read_current_version
#define sis_write                                      frt_sis_write
#define sort_add_sort_field                            frt_sort_add_sort_field
#define sort_clear                                     frt_sort_clear
#define sort_destroy                                   frt_sort_destroy
#define sort_field_auto_new                            frt_sort_field_auto_new
#define sort_field_byte_new                            frt_sort_field_byte_new
#define sort_field_destroy                             frt_sort_field_destroy
#define sort_field_doc_new                             frt_sort_field_doc_new
#define sort_field_float_new                           frt_sort_field_float_new
#define sort_field_int_new                             frt_sort_field_int_new
#define sort_field_new                                 frt_sort_field_new
#define sort_field_score_new                           frt_sort_field_score_new
#define sort_field_string_new                          frt_sort_field_string_new
#define sort_field_to_s                                frt_sort_field_to_s
#define sort_new                                       frt_sort_new
#define sort_to_s                                      frt_sort_to_s
#define spanfq_new                                     frt_spanfq_new
#define spanfq_new_nr                                  frt_spanfq_new_nr
#define spanmtq_add_term                               frt_spanmtq_add_term
#define spanmtq_new                                    frt_spanmtq_new
#define spanmtq_new_conf                               frt_spanmtq_new_conf
#define spannq_add_clause                              frt_spannq_add_clause
#define spannq_add_clause_nr                           frt_spannq_add_clause_nr
#define spannq_new                                     frt_spannq_new
#define spanoq_add_clause                              frt_spanoq_add_clause
#define spanoq_add_clause_nr                           frt_spanoq_add_clause_nr
#define spanoq_new                                     frt_spanoq_new
#define spanprq_new                                    frt_spanprq_new
#define spantq_new                                     frt_spantq_new
#define spanxq_new                                     frt_spanxq_new
#define spanxq_new_nr                                  frt_spanxq_new_nr
#define standard_analyzer_new                          frt_standard_analyzer_new
#define standard_analyzer_new_with_words               frt_standard_analyzer_new_with_words
#define standard_analyzer_new_with_words_len           frt_standard_analyzer_new_with_words_len
#define standard_tokenizer_new                         frt_standard_tokenizer_new
#define std_scan                                       frt_std_scan
#define std_scan_mb                                    frt_std_scan_mb
#define std_scan_utf8                                  frt_std_scan_utf8
#define stde_new                                       frt_stde_new
#define ste_clone                                      frt_ste_clone
#define ste_close                                      frt_ste_close
#define ste_new                                        frt_ste_new
#define stem_filter_new                                frt_stem_filter_new
#define stop_filter_new                                frt_stop_filter_new
#define stop_filter_new_with_words                     frt_stop_filter_new_with_words
#define stop_filter_new_with_words_len                 frt_stop_filter_new_with_words_len
#define store_deref                                    frt_store_deref
#define store_destroy                                  frt_store_destroy
#define store_new                                      frt_store_new
#define store_to_s                                     frt_store_to_s
#define stpe_new                                       frt_stpe_new
#define str_hash                                       frt_str_hash
#define strapp                                         frt_strapp
#define strfmt                                         frt_strfmt
#define strsort                                        frt_strsort
#define sym_hash                                       frt_sym_hash
#define sym_len                                        frt_sym_len
#define symbol_init                                    frt_symbol_init
#define td_destroy                                     frt_td_destroy
#define td_new                                         frt_td_new
#define td_to_s                                        frt_td_to_s
#define te_get_term                                    frt_te_get_term
#define te_get_ti                                      frt_te_get_ti
#define term_destroy                                   frt_term_destroy
#define term_eq                                        frt_term_eq
#define term_hash                                      frt_term_hash
#define term_new                                       frt_term_new
#define tf_new_i                                       frt_tf_new_i
#define thread_exit                                    frt_thread_exit
#define thread_getspecific                             frt_thread_getspecific
#define thread_key_create                              frt_thread_key_create
#define thread_key_delete                              frt_thread_key_delete
#define thread_key_t                                   frt_thread_key_t
#define thread_once                                    frt_thread_once
#define thread_once_t                                  frt_thread_once_t
#define thread_setspecific                             frt_thread_setspecific
#define ti_set                                         frt_ti_set
#define tir_close                                      frt_tir_close
#define tir_get_term                                   frt_tir_get_term
#define tir_get_ti                                     frt_tir_get_ti
#define tir_open                                       frt_tir_open
#define tir_set_field                                  frt_tir_set_field
#define tiw_add                                        frt_tiw_add
#define tiw_close                                      frt_tiw_close
#define tiw_open                                       frt_tiw_open
#define tiw_start_field                                frt_tiw_start_field
#define tk_cmp                                         frt_tk_cmp
#define tk_destroy                                     frt_tk_destroy
#define tk_eq                                          frt_tk_eq
#define tk_new                                         frt_tk_new
#define tk_set                                         frt_tk_set
#define tk_set_no_len                                  frt_tk_set_no_len
#define tq_new                                         frt_tq_new
#define trfilt_new                                     frt_trfilt_new
#define trq_new                                        frt_trq_new
#define trq_new_less                                   frt_trq_new_less
#define trq_new_more                                   frt_trq_new_more
#define ts_clone                                       frt_ts_clone
#define ts_clone_size                                  frt_ts_clone_size
#define ts_deref                                       frt_ts_deref
#define ts_new                                         frt_ts_new
#define ts_new_i                                       frt_ts_new_i
#define ts_next                                        frt_ts_next
#define tv_destroy                                     frt_tv_destroy
#define tv_get_term_index                              frt_tv_get_term_index
#define tv_get_tv_term                                 frt_tv_get_tv_term
#define tv_scan_to_term_index                          frt_tv_scan_to_term_index
#define u16                                            frt_u16
#define u32                                            frt_u32
#define u32malloc                                      frt_u32malloc
#define u64                                            frt_u64
#define u64malloc                                      frt_u64malloc
#define uchar                                          frt_uchar
#define utf8_standard_analyzer_new                     frt_utf8_standard_analyzer_new
#define utf8_standard_analyzer_new_with_words          frt_utf8_standard_analyzer_new_with_words
#define utf8_standard_analyzer_new_with_words_len      frt_utf8_standard_analyzer_new_with_words_len
#define utf8_standard_tokenizer_new                    frt_utf8_standard_tokenizer_new
#define vexit                                          frt_vexit
#define vstrfmt                                        frt_vstrfmt
#define w_create                                       frt_w_create
#define w_destroy                                      frt_w_destroy
#define w_get_query                                    frt_w_get_query
#define w_get_value                                    frt_w_get_value
#define w_normalize                                    frt_w_normalize
#define w_sum_of_squared_weights                       frt_w_sum_of_squared_weights
#define wc_match                                       frt_wc_match
#define wcq_new                                        frt_wcq_new
#define weprintf                                       frt_weprintf
#define whitespace_analyzer_new                        frt_whitespace_analyzer_new
#define whitespace_tokenizer_new                       frt_whitespace_tokenizer_new
#define with_lock                                      frt_with_lock
#define with_lock_name                                 frt_with_lock_name
#define x_abort_on_exception                           frt_x_abort_on_exception
#define x_do_logging                                   frt_x_do_logging
#define x_exception_stream                             frt_x_exception_stream
#define x_has_aborted                                  frt_x_has_aborted
#define xcontext_t                                     frt_xcontext_t
#define xexit                                          frt_xexit
#define xmsg_buffer                                    frt_xmsg_buffer
#define xmsg_buffer_final                              frt_xmsg_buffer_final
#define xpop_context                                   frt_xpop_context
#define xpush_context                                  frt_xpush_context
#define xraise                                         frt_xraise

#endif
