#
# benchmark.rb
#
#   Copyright (c) 1999-2002 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#
#   $Id: benchmark.rb,v 1.2 2002/01/05 06:19:34 aamine Exp $
#
# Usage:
#
#   str = 'test string'
#   benchmark( 'strdup', 10_0000 ) {
#       str.dup
#   }
#

if Process.respond_to? :times then
  TIMES_MODULE = Process
else
  TIMES_MODULE = Time
end

def benchmark( label, times, &block )
  GC.disable
  mod = TIMES_MODULE
  begtime = mod.times.utime
  times.times( &block )
  endtime = mod.times.utime
  GC.enable
  $stderr.printf "%-10s: %f sec\n", label, endtime - begtime
end
