/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.gui.AttributeEditor;

public abstract class AbstractAttributeEditorHandler<T>
implements Disposable {
    protected DrawingEditor drawingEditor;
    protected DrawingView view;
    protected DrawingView activeView;
    protected AttributeEditor<T> attributeEditor;
    protected AttributeKey<T> attributeKey;
    protected int updateDepth;
    protected LinkedList<Object> attributeRestoreData = new LinkedList();
    protected Map<AttributeKey, Object> defaultAttributes;
    private boolean isUpdateDrawingEditorDefaults;
    private Set<Figure> figuresOfInterest;
    private EventHandler eventHandler = new EventHandler();

    public AbstractAttributeEditorHandler(AttributeKey<T> attributeKey, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor) {
        this(attributeKey, attributeEditor, drawingEditor, true);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> attributeKey, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor, boolean bl) {
        this(attributeKey, null, attributeEditor, drawingEditor, bl);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> attributeKey, Map<AttributeKey, Object> map, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor, boolean bl) {
        this.defaultAttributes = map == null ? Collections.emptyMap() : map;
        attributeEditor.setAttributeValue(attributeKey.getDefaultValue());
        this.setAttributeKey(attributeKey);
        this.setAttributeEditor(attributeEditor);
        this.setDrawingEditor(drawingEditor);
        this.isUpdateDrawingEditorDefaults = bl;
    }

    public void setDrawingEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.drawingEditor;
        if (this.drawingEditor != null) {
            this.drawingEditor.removePropertyChangeListener(this.eventHandler);
        }
        this.drawingEditor = drawingEditor;
        if (this.drawingEditor != null) {
            this.drawingEditor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
        }
        this.updateActiveView();
    }

    public DrawingEditor getDrawingEditor() {
        return this.drawingEditor;
    }

    public void setView(DrawingView drawingView) {
        this.view = drawingView;
        this.updateActiveView();
    }

    public DrawingView getView() {
        return this.view;
    }

    public void setUpdateDrawingEditorDefaults(boolean bl) {
        this.isUpdateDrawingEditorDefaults = bl;
    }

    public boolean isUpdateDrawingEditorDefaults() {
        return this.isUpdateDrawingEditorDefaults;
    }

    protected DrawingView getActiveView() {
        if (this.getView() != null) {
            return this.getView();
        }
        return this.drawingEditor.getActiveView();
    }

    public void setAttributeEditor(AttributeEditor<T> attributeEditor) {
        if (this.attributeEditor != null) {
            this.attributeEditor.removePropertyChangeListener(this.eventHandler);
        }
        this.attributeEditor = attributeEditor;
        if (this.attributeEditor != null) {
            this.attributeEditor.addPropertyChangeListener(this.eventHandler);
        }
    }

    public AttributeEditor<T> getAttributeEditor() {
        return this.attributeEditor;
    }

    public AttributeKey<T> getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(AttributeKey<T> attributeKey) {
        this.attributeKey = attributeKey;
    }

    protected void updateActiveView() {
        DrawingView drawingView = this.view != null ? this.view : (this.drawingEditor != null && this.drawingEditor.getActiveView() != null ? this.drawingEditor.getActiveView() : null);
        DrawingView drawingView2 = this.activeView;
        if (this.activeView != null) {
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView.removeFigureSelectionListener(this.eventHandler);
            if (this.figuresOfInterest != null) {
                for (Figure figure : this.figuresOfInterest) {
                    figure.removeFigureListener(this.eventHandler);
                }
            }
        }
        this.activeView = drawingView;
        if (this.activeView != null) {
            this.activeView.addPropertyChangeListener(this.eventHandler);
            this.activeView.addFigureSelectionListener(this.eventHandler);
            this.figuresOfInterest = this.getEditedFigures();
            for (Figure figure : this.figuresOfInterest) {
                figure.addFigureListener(this.eventHandler);
            }
        }
        this.attributeRestoreData = null;
        this.updateAttributeEditor();
    }

    protected abstract Set<Figure> getEditedFigures();

    protected void updateAttributeEditor() {
        if (this.updateDepth++ == 0) {
            Set<Figure> set = this.getEditedFigures();
            if (this.activeView == null || set.isEmpty()) {
                this.attributeEditor.getComponent().setEnabled(false);
            } else {
                this.attributeEditor.getComponent().setEnabled(true);
                T t = set.iterator().next().get(this.attributeKey);
                boolean bl = false;
                for (Figure figure : set) {
                    T t2 = figure.get(this.attributeKey);
                    if ((t2 != null && t != null || t2 == t) && (t2 == null || t == null || t2.equals(t))) continue;
                    bl = true;
                    break;
                }
                this.attributeEditor.setAttributeValue(t);
                this.attributeEditor.setMultipleValues(bl);
            }
        }
        --this.updateDepth;
    }

    protected void updateFigures() {
        if (this.updateDepth++ == 0) {
            Set<Figure> set = this.getEditedFigures();
            if (this.activeView != null && !set.isEmpty()) {
                T t = this.attributeEditor.getAttributeValue();
                if (this.attributeRestoreData == null) {
                    this.attributeRestoreData = new LinkedList();
                    for (Figure figure : set) {
                        this.attributeRestoreData.add(figure.getAttributesRestoreData());
                    }
                }
                for (Figure figure : set) {
                    figure.willChange();
                    figure.set(this.attributeKey, t);
                    for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
                        figure.set(entry.getKey(), entry.getValue());
                    }
                    figure.changed();
                }
                if (this.drawingEditor != null && this.isUpdateDrawingEditorDefaults) {
                    this.drawingEditor.setDefaultAttribute(this.attributeKey, t);
                }
                this.getActiveView().getDrawing().fireUndoableEditHappened(new UndoableAttributeEdit<T>(new HashSet<Figure>(set), this.attributeKey, t, this.attributeRestoreData));
                if (!this.attributeEditor.getValueIsAdjusting()) {
                    this.attributeRestoreData = null;
                }
            }
        }
        --this.updateDepth;
    }

    @Override
    public void dispose() {
        this.setDrawingEditor(null);
    }

    protected class EventHandler
    extends FigureAdapter
    implements FigureSelectionListener,
    PropertyChangeListener {
        protected EventHandler() {
        }

        @Override
        public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
            AbstractAttributeEditorHandler.this.attributeRestoreData = null;
            if (AbstractAttributeEditorHandler.this.figuresOfInterest != null) {
                for (Figure figure : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                    figure.removeFigureListener(this);
                }
            }
            AbstractAttributeEditorHandler.this.figuresOfInterest = AbstractAttributeEditorHandler.this.getEditedFigures();
            for (Figure figure : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                figure.addFigureListener(this);
            }
            AbstractAttributeEditorHandler.this.updateAttributeEditor();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object == AbstractAttributeEditorHandler.this.drawingEditor && string == "activeView") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (object == AbstractAttributeEditorHandler.this.attributeEditor && string == "attributeValue") {
                AbstractAttributeEditorHandler.this.updateFigures();
            } else if (object == AbstractAttributeEditorHandler.this.activeView && string == "drawing") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (AbstractAttributeEditorHandler.this.figuresOfInterest != null && AbstractAttributeEditorHandler.this.figuresOfInterest.contains(object)) {
                AbstractAttributeEditorHandler.this.updateFigures();
            }
        }

        @Override
        public void attributeChanged(FigureEvent figureEvent) {
            if (figureEvent.getAttribute() == AbstractAttributeEditorHandler.this.attributeKey) {
                AbstractAttributeEditorHandler.this.updateAttributeEditor();
            }
        }
    }

    private static class UndoableAttributeEdit<T>
    extends AbstractUndoableEdit {
        private Set<Figure> editedFigures;
        private AttributeKey<T> attributeKey;
        private T editRedoValue;
        protected LinkedList<Object> editUndoData;

        public UndoableAttributeEdit(Set<Figure> set, AttributeKey<T> attributeKey, T t, LinkedList<Object> linkedList) {
            this.editedFigures = set;
            this.attributeKey = attributeKey;
            this.editRedoValue = t;
            this.editUndoData = linkedList;
        }

        @Override
        public String getPresentationName() {
            return this.attributeKey.getPresentationName();
        }

        @Override
        public void undo() throws CannotRedoException {
            super.undo();
            Iterator iterator = this.editUndoData.iterator();
            for (Figure figure : this.editedFigures) {
                figure.willChange();
                figure.restoreAttributesTo(iterator.next());
                figure.changed();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (Figure figure : this.editedFigures) {
                figure.set(this.attributeKey, this.editRedoValue);
            }
        }

        @Override
        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof UndoableAttributeEdit) {
                return ((UndoableAttributeEdit)undoableEdit).editUndoData == this.editUndoData;
            }
            return false;
        }
    }
}

