/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configurationcache.ConfigurationCacheAction;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheProblemsException;
import org.gradle.configurationcache.ConfigurationCacheReport;
import org.gradle.configurationcache.TooManyConfigurationCacheProblemsException;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems$BuildFinishedProblemsHandler$WhenMappings;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002/0B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J+\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0014\b\u0002\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%\"\u00020&H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0014\u0010*\u001a\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-*\b\u0012\u0004\u0012\u00020\u001d0-H\u0002R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "Ljava/lang/AutoCloseable;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "report", "Lorg/gradle/configurationcache/ConfigurationCacheReport;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/ConfigurationCacheReport;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/internal/event/ListenerManager;)V", "buildFinishedHandler", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$BuildFinishedProblemsHandler;", "cacheAction", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "invalidateStoredState", "Lkotlin/Function0;", "", "isFailOnProblems", "", "isFailingBuildDueToSerializationError", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "postBuildHandler", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "problems", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "close", "failingBuildDueToSerializationError", "loading", "log", "msg", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onProblem", "problem", "storing", "invalidateState", "causes", "", "", "BuildFinishedProblemsHandler", "PostBuildProblemsHandler", "configuration-cache"})
public final class ConfigurationCacheProblems
implements ProblemsListener,
AutoCloseable {
    private final BuildFinishedProblemsHandler buildFinishedHandler;
    private final PostBuildProblemsHandler postBuildHandler;
    private final CopyOnWriteArrayList<PropertyProblem> problems;
    private boolean isFailOnProblems;
    private boolean isFailingBuildDueToSerializationError;
    private ConfigurationCacheAction cacheAction;
    private Function0<Unit> invalidateStoredState;
    private final Logger logger;
    private final ConfigurationCacheStartParameter startParameter;
    private final ConfigurationCacheReport report;
    private final ConfigurationCacheKey cacheKey;
    private final ListenerManager listenerManager;

    @Override
    public void close() {
        this.listenerManager.removeListener((Object)this.buildFinishedHandler);
        this.listenerManager.removeListener((Object)this.postBuildHandler);
    }

    public final void storing(@NotNull Function0<Unit> invalidateState) {
        Intrinsics.checkNotNullParameter(invalidateState, (String)"invalidateState");
        this.cacheAction = ConfigurationCacheAction.STORE;
        this.invalidateStoredState = invalidateState;
    }

    public final void loading() {
        this.cacheAction = ConfigurationCacheAction.LOAD;
    }

    public final void failingBuildDueToSerializationError() {
        this.isFailingBuildDueToSerializationError = true;
        this.isFailOnProblems = false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Throwable> causes(List<PropertyProblem> $this$causes) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$causes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Throwable throwable;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PropertyProblem it = (PropertyProblem)element$iv$iv;
            boolean bl2 = false;
            if (it.getException() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable it$iv$iv = throwable;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)5);
    }

    @Override
    public void onProblem(@NotNull PropertyProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problems.add(problem);
    }

    private final void log(String msg, Object ... args) {
        this.logger.warn(msg, Arrays.copyOf(args, args.length));
    }

    static /* synthetic */ void log$default(ConfigurationCacheProblems configurationCacheProblems, String string2, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            objectArray = new Object[]{};
        }
        configurationCacheProblems.log(string2, objectArray);
    }

    public ConfigurationCacheProblems(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheReport report, @NotNull ConfigurationCacheKey cacheKey, @NotNull ListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.startParameter = startParameter;
        this.report = report;
        this.cacheKey = cacheKey;
        this.listenerManager = listenerManager;
        this.buildFinishedHandler = new BuildFinishedProblemsHandler();
        this.postBuildHandler = new PostBuildProblemsHandler();
        this.problems = new CopyOnWriteArrayList();
        this.isFailOnProblems = this.startParameter.getFailOnProblems();
        this.listenerManager.addListener((Object)this.buildFinishedHandler);
        this.listenerManager.addListener((Object)this.postBuildHandler);
        this.logger = Logging.getLogger(ConfigurationCacheProblems.class);
    }

    public static final /* synthetic */ void access$setCacheAction$p(ConfigurationCacheProblems $this, ConfigurationCacheAction configurationCacheAction) {
        $this.cacheAction = configurationCacheAction;
    }

    public static final /* synthetic */ void access$setFailOnProblems$p(ConfigurationCacheProblems $this, boolean bl) {
        $this.isFailOnProblems = bl;
    }

    public static final /* synthetic */ void access$setInvalidateStoredState$p(ConfigurationCacheProblems $this, Function0 function0) {
        $this.invalidateStoredState = function0;
    }

    public static final /* synthetic */ void access$setFailingBuildDueToSerializationError$p(ConfigurationCacheProblems $this, boolean bl) {
        $this.isFailingBuildDueToSerializationError = bl;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$BuildFinishedProblemsHandler;", "Lorg/gradle/BuildAdapter;", "(Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;)V", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "newProblemsException", "Lorg/gradle/configurationcache/ConfigurationCacheProblemsException;", "cacheActionText", "", "htmlReportFile", "Ljava/io/File;", "newTooManyProblemsException", "Lorg/gradle/configurationcache/TooManyConfigurationCacheProblemsException;", "outputDirectoryFor", "buildDir", "summaryText", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "configuration-cache"})
    private final class BuildFinishedProblemsHandler
    extends BuildAdapter {
        public void buildFinished(@NotNull BuildResult result) {
            boolean bl;
            boolean bl2;
            boolean tooManyProblems;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Gradle gradle = result.getGradle();
            if ((gradle != null ? gradle.getParent() : null) != null || ConfigurationCacheProblems.this.cacheAction == null || ConfigurationCacheProblems.this.problems.isEmpty()) {
                return;
            }
            boolean bl3 = tooManyProblems = ConfigurationCacheProblems.this.problems.size() > ConfigurationCacheProblems.this.startParameter.getMaxProblems();
            if (ConfigurationCacheProblems.this.cacheAction == ConfigurationCacheAction.STORE && (ConfigurationCacheProblems.this.isFailOnProblems || tooManyProblems)) {
                Function0 function0 = ConfigurationCacheProblems.this.invalidateStoredState;
                boolean bl4 = false;
                bl2 = false;
                bl2 = false;
                bl = false;
                if (function0 == null) {
                    boolean bl5 = false;
                    String string2 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                function0.invoke();
            }
            ConfigurationCacheAction configurationCacheAction = ConfigurationCacheProblems.this.cacheAction;
            bl2 = false;
            bl = false;
            bl = false;
            boolean bl6 = false;
            if (configurationCacheAction == null) {
                boolean bl7 = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String cacheActionText = this.summaryText(configurationCacheAction);
            Object object = result.getGradle();
            if (object == null || (object = object.getRootProject()) == null || (object = object.getBuildDir()) == null) {
                object = ConfigurationCacheProblems.this.startParameter.getRootDirectory();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.gradle?.rootProje\u2026rtParameter.rootDirectory");
            File outputDirectory = this.outputDirectoryFor((File)object);
            File htmlReportFile = ConfigurationCacheProblems.this.report.writeReportFileTo$configuration_cache(outputDirectory, cacheActionText, ConfigurationCacheProblems.this.problems);
            if (ConfigurationCacheProblems.this.isFailOnProblems) {
                throw (Throwable)((Object)this.newProblemsException(cacheActionText, htmlReportFile));
            }
            if (tooManyProblems) {
                throw (Throwable)((Object)this.newTooManyProblemsException(cacheActionText, htmlReportFile));
            }
            ConfigurationCacheProblems.this.logger.warn(ConfigurationCacheProblems.this.report.consoleSummaryFor$configuration_cache(cacheActionText, ConfigurationCacheProblems.this.problems, htmlReportFile));
        }

        private final String summaryText(ConfigurationCacheAction $this$summaryText) {
            String string2;
            switch (ConfigurationCacheProblems$BuildFinishedProblemsHandler$WhenMappings.$EnumSwitchMapping$0[$this$summaryText.ordinal()]) {
                case 1: {
                    string2 = "reusing";
                    break;
                }
                case 2: {
                    string2 = "storing";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string2;
        }

        private final ConfigurationCacheProblemsException newProblemsException(String cacheActionText, File htmlReportFile) {
            return new ConfigurationCacheProblemsException(ConfigurationCacheProblems.this.causes(ConfigurationCacheProblems.this.problems), cacheActionText, ConfigurationCacheProblems.this.problems, htmlReportFile);
        }

        private final TooManyConfigurationCacheProblemsException newTooManyProblemsException(String cacheActionText, File htmlReportFile) {
            return new TooManyConfigurationCacheProblemsException(ConfigurationCacheProblems.this.causes(ConfigurationCacheProblems.this.problems), cacheActionText, ConfigurationCacheProblems.this.problems, htmlReportFile);
        }

        private final File outputDirectoryFor(File buildDir) {
            File file;
            File file2 = FilesKt.resolve((File)buildDir, (String)("reports/configuration-cache/" + ConfigurationCacheProblems.this.cacheKey));
            boolean bl = false;
            boolean bl2 = false;
            File base = file2;
            boolean bl3 = false;
            if (!base.exists()) {
                file = base;
            } else {
                Object element$iv2;
                block3: {
                    Sequence $this$first$iv = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)1, (Function1)outputDirectoryFor.1.1.INSTANCE), (Function1)((Function1)new Function1<Integer, File>(base){
                        final /* synthetic */ File $base;

                        @NotNull
                        public final File invoke(int it) {
                            return FilesKt.resolveSibling((File)this.$base, (String)(this.$base.getName() + '-' + it));
                        }
                        {
                            this.$base = file;
                            super(1);
                        }
                    }));
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        File it = (File)element$iv2;
                        boolean bl4 = false;
                        if (!(!it.exists())) continue;
                        break block3;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                file = (File)element$iv2;
            }
            return file;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "Lorg/gradle/initialization/RootBuildLifecycleListener;", "(Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;)V", "problemCount", "", "getProblemCount", "()Ljava/lang/String;", "afterStart", "", "gradle", "Lorg/gradle/api/internal/GradleInternal;", "beforeComplete", "configuration-cache"})
    private final class PostBuildProblemsHandler
    implements RootBuildLifecycleListener {
        public void afterStart(@NotNull GradleInternal gradle) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        }

        public void beforeComplete(@NotNull GradleInternal gradle) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            if (ConfigurationCacheProblems.this.cacheAction == null) {
                return;
            }
            Collection collection = ConfigurationCacheProblems.this.problems;
            boolean bl = false;
            boolean hasProblems = !collection.isEmpty();
            boolean hasTooManyProblems = ConfigurationCacheProblems.this.problems.size() > ConfigurationCacheProblems.this.startParameter.getMaxProblems();
            if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError && !hasProblems) {
                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded.", null, 2, null);
            } else if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError) {
                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", this.getProblemCount());
            } else if (ConfigurationCacheProblems.this.cacheAction == ConfigurationCacheAction.STORE && ConfigurationCacheProblems.this.isFailOnProblems && hasProblems) {
                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", this.getProblemCount());
            } else if (ConfigurationCacheProblems.this.cacheAction == ConfigurationCacheAction.STORE && hasTooManyProblems) {
                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with too many problems ({}).", this.getProblemCount());
            } else if (ConfigurationCacheProblems.this.cacheAction == ConfigurationCacheAction.LOAD && !hasProblems) {
                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry reused.", null, 2, null);
            } else if (ConfigurationCacheProblems.this.cacheAction == ConfigurationCacheAction.LOAD) {
                ConfigurationCacheProblems.this.log("Configuration cache entry reused with {}.", this.getProblemCount());
            } else if (!hasProblems) {
                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry stored.", null, 2, null);
            } else {
                ConfigurationCacheProblems.this.log("Configuration cache entry stored with {}.", this.getProblemCount());
            }
        }

        private final String getProblemCount() {
            return ConfigurationCacheProblems.this.problems.size() == 1 ? "1 problem" : ConfigurationCacheProblems.this.problems.size() + " problems";
        }
    }
}

