/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.sax;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CountingErrorHandler
implements ErrorHandler {
    private ErrorHandler errorHandler;
    private int fatalErrorCount = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private boolean hadErrorOrFatalError = false;

    public CountingErrorHandler() {
        this(null);
    }

    public CountingErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void reset() {
        this.fatalErrorCount = 0;
        this.errorCount = 0;
        this.warningCount = 0;
        this.hadErrorOrFatalError = false;
    }

    public boolean getHadErrorOrFatalError() {
        return this.hadErrorOrFatalError;
    }

    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void warning(SAXParseException exception) throws SAXException {
        ++this.warningCount;
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        ++this.errorCount;
        this.hadErrorOrFatalError = true;
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        ++this.fatalErrorCount;
        this.hadErrorOrFatalError = true;
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }
}

