/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.swingframework.IDrawingProvider;

public class DrawingExporter {
    private static final double margin = 0.0;
    private static final int PDF_RESOLUTION = 72;
    private static final int PNG_RESOLUTION = 300;
    private static final int SCREEN_RESOLUTION = Toolkit.getDefaultToolkit().getScreenResolution();
    private static DrawingExporter instance;

    public static DrawingExporter getInstance() {
        if (instance == null) {
            instance = new DrawingExporter();
        }
        return instance;
    }

    private DrawingExporter() {
    }

    public void print(final IDrawingProvider provider) throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        final int pageCount = provider.getPageCount();
        printJob.setPrintable(new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                if (pageIndex >= pageCount) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)graphics;
                Dimension d = provider.getSize();
                double pageRatio = pageFormat.getWidth() / pageFormat.getHeight();
                double imageRatio = d.getWidth() / d.getHeight();
                double scale = imageRatio > pageRatio ? (pageFormat.getWidth() - 0.0) / d.getWidth() : (pageFormat.getHeight() - 0.0) / d.getHeight();
                if (scale > 1.0) {
                    scale = 1.0;
                }
                g2d.translate(pageFormat.getImageableX() + 0.0, pageFormat.getImageableY() + 0.0);
                g2d.setFont(new Font("Tahoma", 0, 6));
                FontMetrics metrics = g2d.getFontMetrics();
                g2d.setColor(Color.gray);
                if (scale < 1.0) {
                    String warningStr = "Note: image has been scaled down to fit the page.";
                    g2d.drawString(warningStr, 0, (int)(d.getHeight() * scale + (double)metrics.getHeight()));
                }
                g2d.scale(scale, scale);
                provider.draw(pageIndex, g2d);
                return 0;
            }
        });
        if (printJob.printDialog()) {
            printJob.print();
        }
    }

    public void exportPDF(IDrawingProvider provider, File file) throws FileNotFoundException, DocumentException {
        Dimension d = provider.getSize();
        float factor = 72.0f / (float)SCREEN_RESOLUTION;
        float totalWidth = (float)((double)factor * (0.0 + d.getWidth()));
        float totalHeight = (float)((double)factor * (0.0 + d.getHeight()));
        Document document = new Document(new Rectangle(totalWidth, totalHeight));
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
        document.open();
        DefaultFontMapper mapper = new DefaultFontMapper(){

            public DefaultFontMapper.BaseFontParameters getBaseFontParameters(String arg0) {
                DefaultFontMapper.BaseFontParameters p = super.getBaseFontParameters(arg0);
                if (p != null) {
                    p.encoding = "Identity-H";
                }
                return p;
            }
        };
        if (Utils.isWindows()) {
            mapper.insertDirectory(System.getenv("windir") + "\\Fonts");
        } else if (Utils.isMac()) {
            mapper.insertDirectory("$HOME/Library/Fonts");
        } else if (Utils.isUnix()) {
            mapper.insertDirectory("/usr/share/fonts/truetype/");
        }
        for (int i = 0; i < provider.getPageCount(); ++i) {
            if (i > 0) {
                document.newPage();
            }
            PdfContentByte contentByte = writer.getDirectContent();
            PdfTemplate template = contentByte.createTemplate(totalWidth, totalHeight);
            Graphics2D g2d = template.createGraphics((float)((double)factor * d.getWidth()), (float)((double)factor * d.getHeight()), (FontMapper)mapper);
            g2d.scale(factor, factor);
            provider.draw(i, g2d);
            contentByte.addTemplate(template, 0.0f, 0.0f);
            g2d.dispose();
        }
        document.close();
    }

    public void exportPNG(IDrawingProvider provider, File file) {
        try {
            int pageCount = provider.getPageCount();
            Dimension d = provider.getSize();
            double factor = 300.0f / (float)SCREEN_RESOLUTION;
            if (pageCount == 1) {
                BufferedImage image = new BufferedImage((int)(d.getWidth() * factor), (int)(d.getHeight() * factor), 1);
                Graphics2D g2d = (Graphics2D)image.getGraphics();
                g2d.scale(factor, factor);
                provider.draw(0, g2d);
                g2d.dispose();
                ImageIO.write((RenderedImage)image, "PNG", file);
            } else {
                for (int i = 0; i < pageCount; ++i) {
                    BufferedImage image = new BufferedImage((int)(d.getWidth() * factor), (int)(d.getHeight() * factor), 1);
                    Graphics2D g2d = (Graphics2D)image.getGraphics();
                    g2d.scale(factor, factor);
                    provider.draw(i, g2d);
                    g2d.translate(0, (int)(d.getHeight() * factor));
                    g2d.dispose();
                    ImageIO.write((RenderedImage)image, "PNG", new File(file.getAbsolutePath().replaceAll("\\.png", "_" + (i + 1) + ".png")));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error exporting: " + e);
        }
    }
}

