/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import java.io.ByteArrayOutputStream;

public class EMSA_PKCS1_V1_5
implements Cloneable {
    private static final byte[] MD2_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private static final byte[] MD5_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] SHA160_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] SHA256_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SHA384_PREFIX = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static final byte[] SHA512_PREFIX = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    private IMessageDigest hash;
    private int hLen;
    private byte[] prefix;

    private EMSA_PKCS1_V1_5(IMessageDigest hash) {
        this.hash = hash;
        this.hLen = hash.hashSize();
        String name = hash.name();
        if (name.equals("md2")) {
            this.prefix = MD2_PREFIX;
        } else if (name.equals("md5")) {
            this.prefix = MD5_PREFIX;
        } else if (name.equals("sha-160")) {
            this.prefix = SHA160_PREFIX;
        } else if (name.equals("sha-256")) {
            this.prefix = SHA256_PREFIX;
        } else if (name.equals("sha-384")) {
            this.prefix = SHA384_PREFIX;
        } else if (name.equals("sha-512")) {
            this.prefix = SHA512_PREFIX;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static final EMSA_PKCS1_V1_5 getInstance(String mdName) {
        IMessageDigest hash = HashFactory.getInstance(mdName);
        String name = hash.name();
        if (!(name.equals("md2") || name.equals("md5") || name.equals("sha-160") || name.equals("sha-256") || name.equals("sha-384") || name.equals("sha-512"))) {
            throw new UnsupportedOperationException("hash with no ID");
        }
        return new EMSA_PKCS1_V1_5(hash);
    }

    public Object clone() {
        return EMSA_PKCS1_V1_5.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] mHash, int emLen) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.prefix, 0, this.prefix.length);
        baos.write(mHash, 0, mHash.length);
        byte[] T = baos.toByteArray();
        int tLen = T.length;
        if (emLen < tLen + 11) {
            throw new IllegalArgumentException("emLen too short");
        }
        byte[] PS = new byte[emLen - tLen - 3];
        for (int i = 0; i < PS.length; ++i) {
            PS[i] = -1;
        }
        baos.reset();
        baos.write(0);
        baos.write(1);
        baos.write(PS, 0, PS.length);
        baos.write(0);
        baos.write(T, 0, tLen);
        byte[] result = baos.toByteArray();
        baos.reset();
        return result;
    }
}

