/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CConvo;
import org.igoweb.igoweb.client.CDetailsChannel;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.CGameListEntry;
import org.igoweb.igoweb.client.CGlobalGames;
import org.igoweb.igoweb.client.CPlayback;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.ConnMutex;
import org.igoweb.igoweb.client.Connector;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.igoweb.client.swing.ClientWindow;
import org.igoweb.igoweb.client.swing.ConvoPanel;
import org.igoweb.igoweb.client.swing.GlobalGamePanel;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.GuiConnMutex;
import org.igoweb.igoweb.client.swing.MessagesWindow;
import org.igoweb.igoweb.client.swing.ResumeMenu;
import org.igoweb.igoweb.client.swing.RoomPanel;
import org.igoweb.igoweb.shared.ClientType;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;
import org.igoweb.util.swing.TBlock;

public abstract class GuiClient
implements EventListener {
    private static final String CLIENT_ID_PREF = "Z}TC_?~D";
    private static final String FINAL_ERROR_NAME = "bsYpZ5fJ";
    private ClientWindow clientWin;
    private final Client client;
    private boolean finalErr = false;
    private ResumeMenu resumeMenu;
    private final SingletonWindow tournNotifyWin = new SingletonWindow();
    private final EventListener gameListener = this::gameEvent;

    public GuiClient(String userName, String password, ClientType clientType, Connector connector) {
        this(userName, password, clientType, connector, Prefs.getLong(CLIENT_ID_PREF, 0L));
    }

    public GuiClient(String userName, String password, ClientType clientType, Connector connector, long clientId) {
        this.client = this.buildClient(userName, password, clientType, clientId, new GuiConnMutex(), connector);
        this.buildGuiClientUtil();
        this.client.addListener(this);
    }

    public void go() {
        this.client.go();
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 12: 
            case 13: 
            case 14: {
                GuiClientUtil.messageReceived(event, this.clientWin);
                break;
            }
            case 110: {
                GuiClientUtil.messageReceived(Defs.getString(Defs.isApp() ? -903340475 : -903340476, Defs.getString(2031923656)), 13, this.clientWin);
                break;
            }
            case 111: {
                this.setFinalError(GuiClientUtil.messageReceived(Defs.getString(Defs.isApp() ? -903340473 : -903340474, Defs.getString(2031923656)), 14, null));
                break;
            }
            case 97: {
                GuiClientUtil.messageReceived(Defs.getString(2031923640), 13, this.clientWin);
                break;
            }
            case 93: {
                this.setFinalError(GuiClientUtil.messageReceived((String)event.arg, 14, null));
                break;
            }
            case 86: {
                this.clientWin = new ClientWindow(this.client);
                this.clientWin.setVisible(true);
                this.clientWin.loginSuccess();
                this.resumeMenu = this.buildResumeMenu();
                this.client.getMyTags();
                this.client.getMe().addListener(arg -> this.clientWin.updateMe());
                break;
            }
            case 87: {
                if (!this.finalErr && event.arg == null) {
                    if (this.clientWin != null) {
                        this.clientWin.dispose();
                    }
                } else {
                    this.disableAllWidgets();
                }
                if (this.finalErr || event.arg == null) break;
                this.setFinalError(GuiClientUtil.messageReceived((String)event.arg, 14, null));
                break;
            }
            case 90: {
                ((CRoom)event.arg).addListener(this);
                break;
            }
            case 91: {
                ChatPane.announce(event, this.clientWin);
                break;
            }
            case 88: {
                this.buildViewUserWindow((CDetailsChannel)event.arg, this.clientWin);
                break;
            }
            case 94: {
                CConvo convo = (CConvo)event.arg;
                if (!convo.isRequested && !this.client.getFriendsGroup(0).contains(convo.peer.name) && convo.peer.getAuthLevel() < 3) {
                    if (!this.clientWin.isNewChatOk(convo.peer)) {
                        convo.sendNoChats();
                        convo = null;
                    } else if (this.client.getFriendsGroup(1).contains(convo.peer.name)) {
                        convo.sendUnjoinRequest();
                        convo = null;
                    }
                }
                if (convo == null) break;
                this.clientWin.addChat(new ConvoPanel(convo, this.client, this.clientWin), convo.isRequested);
                break;
            }
            case 95: {
                GuiClientUtil.messageReceived(Defs.getString(2031923689), 13, this.clientWin).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent winEvent) {
                        GuiClient.this.client.sendKeepAlive();
                    }
                });
                break;
            }
            case 15: {
                this.clientWin.addChat(this.buildRoomPanel((CRoom)event.source, this.resumeMenu), true);
                break;
            }
            case 96: {
                ((CGameListEntry)event.arg).addListener(this.gameListener);
                break;
            }
            case 100: {
                new MessagesWindow(this.clientWin, (ArrayList)event.arg, this.client);
                break;
            }
            case 104: {
                GameSummary gsum = (GameSummary)event.arg;
                new MsgOut(Defs.getString(-903340640), Defs.getString(2031923639, gsum.getLocalDesc()), 3, (Component)this.clientWin, new String[]{Defs.getString(1436228521), Defs.getString(1436228522)}, buttonEvent -> {
                    if (buttonEvent.getActionCommand().equals(Defs.getString(1436228521))) {
                        this.client.sendJoinRequest(gsum.id);
                    }
                });
                break;
            }
            case 105: {
                GuiClient.internalError((Throwable)event.arg);
                break;
            }
            case 106: {
                Prefs.putLong(CLIENT_ID_PREF, (Long)event.arg);
                break;
            }
            case 109: {
                Object[] args = (Object[])event.arg;
                CRoom room = (CRoom)args[0];
                CGame game = (CGame)args[1];
                boolean isLate = (Boolean)args[2];
                this.tournNotifyWin.setWindow(new MsgOut(Defs.getString(isLate ? -903340547 : -903340709), Defs.getString(isLate ? -903340488 : -903340487, room.getName()), 3, (Component)this.clientWin, new String[]{Defs.getString(1436228521), Defs.getString(1436228522)}, buttonEvent -> {
                    if (buttonEvent.getActionCommand().equals(Defs.getString(1436228521))) {
                        game.sendJoinRequest();
                    }
                }));
                break;
            }
            case 112: 
            case 113: {
                this.clientWin.setPlaybackList(this.client.getPlaybackList());
                break;
            }
            case 120: {
                ((CPlayback)event.arg).addListener(this.gameListener);
                break;
            }
            case 121: {
                this.clientWin.addChat(this.buildGlobalGamePanel((CGlobalGames)event.arg), true);
                break;
            }
            case 127: {
                CChannel channel = (CChannel)event.arg;
                GuiClientUtil.messageReceived(Defs.getString(2031923674, channel == null ? "-" : channel.getDescription()), 14, this.clientWin);
                break;
            }
            case 134: {
                GuiClientUtil.messageReceived(Defs.getString(event.arg instanceof CRoom ? -903340603 : 2031923658, Config.get("webHost")), 13, this.clientWin);
                break;
            }
            case 129: {
                this.clientWin.updateAutomatchStatus();
            }
        }
    }

    public ClientWindow getClientWindow() {
        return this.clientWin;
    }

    private void gameEvent(Event event) {
        Object channel = event.source;
        switch (event.type) {
            case 15: {
                if (channel instanceof CGame) {
                    CGame cGame = (CGame)channel;
                    if (cGame.getOriginalGame() != null) break;
                    this.buildGameWindow(cGame);
                    break;
                }
                if (!(channel instanceof CPlayback)) break;
                this.buildPlaybackWindow((CPlayback)channel);
            }
        }
    }

    public Client getClient() {
        return this.client;
    }

    private void setFinalError(MsgOut msgOut) {
        this.finalErr = true;
        msgOut.setName(FINAL_ERROR_NAME);
        msgOut.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                if (GuiClient.this.clientWin != null) {
                    GuiClient.this.clientWin.dispose();
                }
            }
        });
        GuiClientUtil.addToWindowList(this.client, msgOut);
    }

    private void disableAllWidgets() {
        Component stillEnabledWidget;
        Stack<Component[]> compLists = new Stack<Component[]>();
        for (JFrame window : GuiClientUtil.get((Client)this.client).windowList.getWindows()) {
            if (FINAL_ERROR_NAME.equals(window.getName())) continue;
            compLists.push(window.getContentPane().getComponents());
        }
        Component component = stillEnabledWidget = this.clientWin == null ? null : this.clientWin.getAlwaysEnabledWidget();
        while (!compLists.isEmpty()) {
            Component[] comps;
            for (Component comp : comps = (Component[])compLists.pop()) {
                if (comp != stillEnabledWidget) {
                    comp.setEnabled(false);
                }
                if (!(comp instanceof Container)) continue;
                compLists.push(((Container)comp).getComponents());
            }
        }
    }

    public static void internalError(Throwable error) {
        String msg;
        error.printStackTrace();
        CharArrayWriter stackDump = new CharArrayWriter();
        error.printStackTrace(new PrintWriter((Writer)stackDump, true));
        AFrame f = new AFrame(Defs.getString(1436228515));
        if (error instanceof OutOfMemoryError) {
            msg = Defs.getString(-903340539, Config.get("adminEmail"));
        } else {
            String beta = Config.get("version.beta");
            String bugfix = Config.get("version.bugfix");
            msg = Defs.getString(-903340779, new Object[]{stackDump.toString(), Integer.valueOf(Config.get("version.major")), Integer.valueOf(Config.get("version.minor")), beta == null ? Integer.valueOf(bugfix) : bugfix + beta, System.getProperty("java.vendor"), System.getProperty("java.version"), Config.get("adminEmail")});
        }
        f.getContentPane().add(new JScrollPane(new TBlock(msg, 60), 22, 31));
        f.pack();
        f.setVisible(true);
    }

    protected abstract void buildViewUserWindow(CDetailsChannel var1, AFrame var2);

    protected abstract RoomPanel buildRoomPanel(CRoom var1, ResumeMenu var2);

    protected abstract Client buildClient(String var1, String var2, ClientType var3, long var4, ConnMutex var6, Connector var7);

    protected abstract void buildGameWindow(CGame var1);

    protected abstract void buildPlaybackWindow(CPlayback var1);

    protected abstract ResumeMenu buildResumeMenu();

    protected abstract GuiClientUtil buildGuiClientUtil();

    protected abstract GlobalGamePanel buildGlobalGamePanel(CGlobalGames var1);
}

