/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ConfigFileParser {
    private static final boolean DEBUG = false;
    private ConfigFileTokenizer cft;
    private Map map;

    private static final void debug(String string) {
    }

    public final Map getLoginModulesMap() {
        return this.map;
    }

    public final void parse(Reader reader) throws IOException {
        this.initParser(reader);
        while (this.parseAppOrOtherEntry()) {
        }
    }

    private final void initParser(Reader reader) throws IOException {
        this.map.clear();
        this.cft = new ConfigFileTokenizer(reader);
    }

    private final boolean parseAppOrOtherEntry() throws IOException {
        List list2;
        int n = this.cft.nextToken();
        if (n == -1) {
            return false;
        }
        if (n != -3) {
            this.cft.pushBack();
            return false;
        }
        String string = this.cft.sval;
        ConfigFileParser.debug("DEBUG: APP_NAME_OR_OTHER = " + string);
        if (this.cft.nextToken() != 123) {
            this.abort("Missing '{' after APP_NAME_OR_OTHER");
        }
        ArrayList arrayList = new ArrayList();
        while (this.parseACE(arrayList)) {
        }
        n = this.cft.nextToken();
        if (n != 125) {
            this.abort("Was expecting '}' but found " + (char)n);
        }
        if ((n = this.cft.nextToken()) != 59) {
            this.abort("Was expecting ';' but found " + (char)n);
        }
        if ((list2 = (List)this.map.get(string)) == null) {
            list2 = new ArrayList();
            this.map.put(string, list2);
        }
        list2.addAll(arrayList);
        return string.equalsIgnoreCase("other") ^ true;
    }

    private final boolean parseACE(List list2) throws IOException {
        int n = this.cft.nextToken();
        if (n != -3) {
            this.cft.pushBack();
            return false;
        }
        String string = this.validateClassName(this.cft.sval);
        ConfigFileParser.debug("DEBUG: MODULE_CLASS = " + string);
        if (this.cft.nextToken() != -3) {
            this.abort("Was expecting FLAG but found none");
        }
        String string2 = this.cft.sval;
        ConfigFileParser.debug("DEBUG: FLAG = " + string2);
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = null;
        if (string2.equalsIgnoreCase("required")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (string2.equalsIgnoreCase("requisite")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (string2.equalsIgnoreCase("sufficient")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (string2.equalsIgnoreCase("optional")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            this.abort("Unknown Flag: " + string2);
        }
        HashMap hashMap = new HashMap();
        n = this.cft.nextToken();
        while (n != 59) {
            if (n != -3) {
                this.abort("Was expecting PARAM_NAME but got '" + (char)n + '\'');
            }
            String string3 = this.cft.sval;
            ConfigFileParser.debug("DEBUG: PARAM_NAME = " + string3);
            if (this.cft.nextToken() != 61) {
                this.abort("Missing '=' after PARAM_NAME");
            }
            if ((n = this.cft.nextToken()) != 34 && n != 39) {
                ConfigFileParser.debug(" WARN: Was expecting a quoted string but got no quote character. Assume unquoted string");
            }
            String string4 = this.expandParamValue(this.cft.sval);
            ConfigFileParser.debug("DEBUG: PARAM_VALUE = " + string4);
            hashMap.put(string3, string4);
            n = this.cft.nextToken();
        }
        AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(string, loginModuleControlFlag, hashMap);
        ConfigFileParser.debug("DEBUG: LOGIN_MODULE_ENTRY = " + appConfigurationEntry);
        list2.add(appConfigurationEntry);
        return true;
    }

    private final void abort(String string) throws IOException {
        ConfigFileParser.debug("ERROR: " + string);
        ConfigFileParser.debug("DEBUG: Map (so far) = " + String.valueOf(this.map));
        throw new IOException(string);
    }

    private final String validateClassName(String string) throws IOException {
        if (string.startsWith(".") || string.endsWith(".")) {
            this.abort("MODULE_CLASS MUST NOT start or end with a '.'");
        }
        String[] stringArray = string.split(".");
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (Character.isJavaIdentifierStart(string.toCharArray()[0])) {
                this.abort("");
            }
            ++n;
        }
        return string;
    }

    private final String expandParamValue(String string) {
        String string2 = string;
        try {
            int n = 0;
            while (n < string2.length()) {
                int n2 = string.indexOf("${", n);
                if (n2 == -1) break;
                int n3 = string.indexOf("}", n2 + 2);
                if (n3 == -1) {
                    ConfigFileParser.debug(" WARN: Found a ${ prefix with no } suffix. Ignore");
                    break;
                }
                String string3 = string.substring(n2 + 2, n3);
                ConfigFileParser.debug("DEBUG: Found a reference to System property " + string3);
                String string4 = System.getProperty(string3);
                ConfigFileParser.debug("DEBUG: Resolved " + string3 + " to '" + string4 + '\'');
                if (string4 != null) {
                    string2 = string.substring(0, n2) + string4 + string.substring(n3 + 1);
                    n = n2 + string4.length();
                    continue;
                }
                n = n3 + 1;
            }
        }
        catch (Exception exception) {
            ConfigFileParser.debug(" WARN: Exception while expanding " + string + ". Ignore: " + exception);
        }
        return string2;
    }

    private final /* synthetic */ void this() {
        this.map = new HashMap();
    }

    public ConfigFileParser() {
        this.this();
    }
}

