/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class CachingToolingImplementationLoader
implements ToolingImplementationLoader,
Closeable {
    private final ToolingImplementationLoader loader;
    private final Map<ClassPath, ConsumerConnection> connections = new HashMap<ClassPath, ConsumerConnection>();

    public CachingToolingImplementationLoader(ToolingImplementationLoader loader) {
        this.loader = loader;
    }

    @Override
    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
        ClassPath classpath = distribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, connectionParameters.getGradleUserHomeDir(), cancellationToken);
        ConsumerConnection connection = this.connections.get(classpath);
        if (connection == null) {
            connection = this.loader.create(distribution, progressLoggerFactory, progressListener, connectionParameters, cancellationToken);
            this.connections.put(classpath, connection);
        }
        return connection;
    }

    @Override
    public void close() {
        try {
            CompositeStoppable.stoppable(this.connections.values()).stop();
        }
        finally {
            this.connections.clear();
        }
    }
}

