/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNameChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public final class JsNameChecker
implements DeclarationChecker {
    @NotNull
    public static final JsNameChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block11: {
            DeclarationDescriptor declarationDescriptor;
            PsiElement jsNamePsi;
            BindingTrace trace;
            block12: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    trace = context2.getTrace();
                    if (descriptor2 instanceof PropertyDescriptor) {
                        int namedAccessorCount;
                        int n;
                        List<PropertyAccessorDescriptor> list2 = ((PropertyDescriptor)descriptor2).getAccessors();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.accessors");
                        Iterable $this$count$iv = list2;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                                boolean bl = false;
                                if (!(AnnotationsUtils.getJsName(it) != null)) continue;
                                int n2 = ++count$iv;
                                boolean bl2 = false;
                                if (n2 >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = namedAccessorCount = count$iv;
                        }
                        if (namedAccessorCount > 0 && namedAccessorCount < ((PropertyDescriptor)descriptor2).getAccessors().size()) {
                            trace.report(ErrorsJs.JS_NAME_IS_NOT_ON_ALL_ACCESSORS.on(declaration2));
                        }
                    }
                    AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation(descriptor2);
                    if (annotationDescriptor == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor, (String)"AnnotationsUtils.getJsNa\u2026ion(descriptor) ?: return");
                    AnnotationDescriptor jsName = annotationDescriptor;
                    PsiElement psiElement = KotlinSourceElementKt.getPsi(jsName.getSource());
                    if (psiElement == null) {
                        psiElement = jsNamePsi = (PsiElement)declaration2;
                    }
                    if (AnnotationsUtils.getNameForAnnotatedObject(descriptor2, PredefinedAnnotation.NATIVE) != null) {
                        trace.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_NAMED_NATIVE.on(jsNamePsi));
                    }
                    if (descriptor2 instanceof CallableMemberDescriptor) {
                        Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
                        Collection<? extends CallableMemberDescriptor> collection2 = collection;
                        boolean bl = false;
                        if (!collection2.isEmpty()) {
                            trace.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_OVERRIDE.on(jsNamePsi));
                        }
                    }
                    if (!((declarationDescriptor = descriptor2) instanceof ConstructorDescriptor)) break block10;
                    if (!((ConstructorDescriptor)descriptor2).isPrimary()) break block11;
                    trace.report(ErrorsJs.JS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED.on(jsNamePsi));
                    break block11;
                }
                if (!(declarationDescriptor instanceof PropertyAccessorDescriptor)) break block12;
                if (AnnotationsUtils.getJsName(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty()) == null) break block11;
                trace.report(ErrorsJs.JS_NAME_ON_ACCESSOR_AND_PROPERTY.on(jsNamePsi));
                break block11;
            }
            if (!(declarationDescriptor instanceof PropertyDescriptor) || !DescriptorUtilsKt.isExtension(descriptor2)) break block11;
            trace.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY.on(jsNamePsi));
        }
    }

    private JsNameChecker() {
    }

    static {
        JsNameChecker jsNameChecker;
        INSTANCE = jsNameChecker = new JsNameChecker();
    }
}

