/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;

public final class ExceptionUtil
extends ExceptionUtilRt {
    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e.getCause() == null) {
                Throwable throwable = e;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e = e.getCause();
        }
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable t) {
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string2 = writer.getBuffer().toString();
        if (string2 == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) {
        ExceptionUtilRt.rethrowUnchecked(t);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

