<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2022 Bennet Becker <dev@bennet.cc>
 *
 * @author Bennet Becker <dev@bennet.cc>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
namespace OCP\Mail\Headers;

/**
 * Keyword values for the Auto-Submitted email header, as per RFC 3834.
 *
 * The value "auto-notified" as per RFC 5436 is deliberately omitted as it is
 * meant of notification of the sieve system.
 *
 * @link https://www.iana.org/assignments/auto-submitted-keywords/auto-submitted-keywords.xhtml
 *
 * @since 26.0.0
 */
final class AutoSubmitted {
	/**
	 * Name of the Header as used in the final message later
	 *
	 * @var string
	 * @since 26.0.0
	 */
	public const HEADER = 'Auto-Submitted';

	/**
	 * Indicates that a message was NOT automatically generated, but was
	 * created by a human (or following human interaction). It is the equivalent
	 * to the absence of an Auto-Submitted header altogether.
	 *
	 * @var string
	 * @since 26.0.0
	 */
	public const VALUE_NO = 'no';

	/**
	 * Indicates that a message was generated by an automatic process, and is
	 * not a direct response to another message
	 *
	 * @var string
	 * @since 26.0.0
	 */
	public const VALUE_AUTO_GENERATED = 'auto-generated';

	/**
	 * Indicates that a message was automatically generated as a direct response
	 * to another message.
	 *
	 * @var string
	 * @since 26.0.0
	 */
	public const VALUE_AUTO_REPLIED = 'auto-replied';
}
