# This file was auto-generated by lib/generators/tasks/generate.rb

module Slack
  module Endpoint
    module Team
      #
      # Gets the access logs for the current team.
      #
      # @option options [Object] :before
      #   End of time range of logs to include in results (inclusive).
      # @option options [Object] :count
      #   Number of items to return per page.
      # @option options [Object] :page
      #   Page number of results to return.
      # @see https://api.slack.com/methods/team.accessLogs
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.accessLogs.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.accessLogs.json
      def team_accessLogs(options={})
        post("team.accessLogs", options)
      end

      #
      # Gets billable users information for the current team.
      #
      # @option options [Object] :user
      #   A user to retrieve the billable information for. Defaults to all users.
      # @see https://api.slack.com/methods/team.billableInfo
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.billableInfo.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.billableInfo.json
      def team_billableInfo(options={})
        post("team.billableInfo", options)
      end

      #
      # Gets information about the current team.
      #
      # @see https://api.slack.com/methods/team.info
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.info.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.info.json
      def team_info(options={})
        post("team.info", options)
      end

      #
      # Gets the integration logs for the current team.
      #
      # @option options [Object] :app_id
      #   Filter logs to this Slack app. Defaults to all logs.
      # @option options [Object] :change_type
      #   Filter logs with this change type. Defaults to all logs.
      # @option options [Object] :count
      #   Number of items to return per page.
      # @option options [Object] :page
      #   Page number of results to return.
      # @option options [Object] :service_id
      #   Filter logs to this service. Defaults to all logs.
      # @option options [Object] :user
      #   Filter logs generated by this user’s actions. Defaults to all logs.
      # @see https://api.slack.com/methods/team.integrationLogs
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.integrationLogs.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.integrationLogs.json
      def team_integrationLogs(options={})
        post("team.integrationLogs", options)
      end

      #
      # Retrieve a team's profile.
      #
      # @option options [Object] :visibility
      #   Filter by visibility.
      # @see https://api.slack.com/methods/team.profile.get
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.profile.get.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/team.profile.get.json
      def team_profile_get(options={})
        post("team.profile.get", options)
      end

    end
  end
end
