/*
 * Decompiled with CFR 0.152.
 */
package phase;

import main.Par;
import phase.CodedSteps;
import phase.FixedPhaseData;
import phase.PhaseData;

public class PbwtIbsData {
    private static final int BURNIN_CANDIDATES = 100;
    private static final int MAX_PHASE_CANDIDATES = 90;
    private static final int MIN_PHASE_CANDIDATES = 5;
    private static final float MAX_BACKOFF_CM = 0.3f;
    private final CodedSteps codedSteps;
    private final int nHaps;
    private final int nTargHaps;
    private final int nCandidates;
    private final int nOverlapSteps;
    private final int maxBackoffSteps;
    private final int stepsPerBatch;
    private final int nBatches;

    public PbwtIbsData(PhaseData phaseData, CodedSteps codedSteps) {
        PbwtIbsData.checkConsistency(phaseData, codedSteps);
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        Par par = fixedPhaseData.par();
        int n = codedSteps.steps().size();
        int n2 = par.nthreads();
        int n3 = par.burnin() + par.iterations();
        this.codedSteps = codedSteps;
        this.nHaps = fixedPhaseData.nHaps();
        this.nTargHaps = phaseData.fpd().targGT().nHaps();
        this.nCandidates = phaseData.it() < n3 ? PbwtIbsData.nCandidates1(phaseData) : PbwtIbsData.nCandidates2(phaseData);
        this.nOverlapSteps = (int)Math.rint(par.buffer() / fixedPhaseData.ibsStep());
        this.maxBackoffSteps = (int)Math.rint(0.3f / fixedPhaseData.ibsStep());
        this.stepsPerBatch = (n + n2 - 1) / n2;
        this.nBatches = (n + this.stepsPerBatch - 1) / this.stepsPerBatch;
    }

    private static void checkConsistency(PhaseData phaseData, CodedSteps codedSteps) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        if (fixedPhaseData.stage1Steps() != codedSteps.steps() || fixedPhaseData.stage1XRefGT() != codedSteps.refHaps() || fixedPhaseData.targGT().samples() != codedSteps.targSamples()) {
            throw new IllegalArgumentException("inconsistent data");
        }
    }

    private static int nCandidates1(PhaseData phaseData) {
        Par par;
        int n = 100;
        int n2 = phaseData.it();
        if (n2 >= (par = phaseData.fpd().par()).burnin()) {
            double d = par.burnin() + par.iterations() - n2;
            double d2 = d / (double)par.iterations();
            n = (int)Math.round(d2 * 90.0);
            n = Math.max(n, 5);
        }
        return Math.min(n, phaseData.fpd().nHaps());
    }

    private static int nCandidates2(PhaseData phaseData) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        int n = fixedPhaseData.nHaps();
        float f = fixedPhaseData.par().rare();
        float f2 = 0.5f;
        int n2 = (int)Math.floor(f2 * f * (float)n);
        n2 = Math.max(n2, 5);
        return Math.min(n2, n);
    }

    public CodedSteps codedSteps() {
        return this.codedSteps;
    }

    public int nHaps() {
        return this.nHaps;
    }

    public int nTargHaps() {
        return this.nTargHaps;
    }

    public int nCandidates() {
        return this.nCandidates;
    }

    public int nOverlapSteps() {
        return this.nOverlapSteps;
    }

    public int maxBackoffSteps() {
        return this.maxBackoffSteps;
    }

    public int stepsPerBatch() {
        return this.stepsPerBatch;
    }

    public int nBatches() {
        return this.nBatches;
    }
}

