/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MeterProgressBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class MeterProgressBarUI
extends BasicProgressBarUI {
    protected Color _cellBackground;
    protected Color _cellForeground;
    protected int _cellLength;
    protected int _cellSpacing;
    private PropertyChangeListener _propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new MeterProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.progressBar, "MeterProgressBar.border");
        LookAndFeel.installColors(this.progressBar, "MeterProgressBar.background", "MeterProgressBar.foreground");
        this._cellForeground = UIDefaultsLookup.getColor("MeterProgressBar.cellForeground");
        this._cellBackground = UIDefaultsLookup.getColor("MeterProgressBar.cellBackground");
        this._cellLength = UIDefaultsLookup.getInt("MeterProgressBar.cellLength");
        this._cellSpacing = UIDefaultsLookup.getInt("MeterProgressBar.cellSpacing");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this._cellBackground = null;
        this._cellForeground = null;
    }

    protected void installListeners() {
        super.installListeners();
        this._propertyChangeListener = new PropertyChangeHandler();
        this.progressBar.addPropertyChangeListener(this._propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.progressBar.removePropertyChangeListener(this._propertyChangeListener);
        super.uninstallListeners();
    }

    public void paint(Graphics g2, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        int orientation = this.progressBar.getOrientation();
        float width = orientation == 0 ? (float)barRectHeight : (float)barRectWidth;
        Graphics2D g22 = (Graphics2D)g2.create();
        g22.setColor(this._cellBackground);
        g22.setStroke(new BasicStroke(width, 0, 2));
        if (orientation == 0) {
            g22.drawLine(b.left, barRectHeight / 2 + b.top, b.left + barRectWidth, barRectHeight / 2 + b.top);
        } else {
            g22.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight, barRectWidth / 2 + b.left, b.top);
        }
        if (((MeterProgressBar)c).getStyle() == 0) {
            g22.setColor(this._cellForeground);
            if (orientation == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    g22.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
                } else {
                    g22.drawLine(barRectWidth + b.left, barRectHeight / 2 + b.top, barRectWidth + b.left - amountFull, barRectHeight / 2 + b.top);
                }
            } else {
                g22.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight, barRectWidth / 2 + b.left, b.top + barRectHeight - amountFull);
            }
        } else {
            g22.setStroke(new BasicStroke(1.0f, 0, 2));
            if (orientation == 0) {
                Rectangle rect = new Rectangle(b.left, b.top, amountFull, barRectHeight / 2);
                if (!c.getComponentOrientation().isLeftToRight()) {
                    rect.x += barRectWidth - amountFull;
                }
                JideSwingUtilities.fillGradient(g22, rect, this._cellForeground, this._cellBackground, true);
                rect.y += barRectHeight / 2;
                JideSwingUtilities.fillGradient(g22, rect, this._cellBackground, this._cellForeground, true);
            } else {
                Rectangle rect = new Rectangle(b.left, b.top + barRectHeight - amountFull, barRectWidth / 2, amountFull);
                JideSwingUtilities.fillGradient(g22, rect, this._cellForeground, this._cellBackground, false);
                rect.x += barRectWidth / 2;
                JideSwingUtilities.fillGradient(g22, rect, this._cellBackground, this._cellForeground, false);
            }
        }
        g22.setColor(this.progressBar.getBackground());
        g22.setStroke(new BasicStroke(width, 0, 2, 0.0f, new float[]{this._cellLength, this._cellSpacing}, 0.0f));
        if (orientation == 0) {
            g22.drawLine(b.left - this._cellSpacing, barRectHeight / 2 + b.top, b.left + barRectWidth, barRectHeight / 2 + b.top);
        } else {
            g22.drawLine(barRectWidth / 2 + b.left, b.top + barRectHeight + this._cellSpacing, barRectWidth / 2 + b.left, b.top);
        }
        g22.dispose();
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("style".equals(evt.getPropertyName())) {
                MeterProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

