/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import org.apache.ivy.osgi.updatesite.xml.Require;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser {
    public static EclipseFeature parse(InputStream in) throws IOException, SAXException {
        FeatureHandler handler = new FeatureHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return handler.feature;
    }

    private static class ImportHandler
    extends DelegatingHandler {
        Require require;
        private static final String IMPORT = "import";
        private static final String FILTER = "filter";
        private static final String MATCH = "match";
        private static final String VERSION = "version";
        private static final String PLUGIN = "plugin";
        private static final String FEATURE = "feature";

        public ImportHandler() {
            super(IMPORT);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            this.require = new Require();
            String version = atts.getValue(VERSION);
            this.require.setFeature(atts.getValue(FEATURE));
            this.require.setPlugin(atts.getValue(PLUGIN));
            this.require.setVersion(new Version(version));
            this.require.setMatch(atts.getValue(MATCH));
            this.require.setFilter(atts.getValue(FILTER));
        }
    }

    static class RequiresHandler
    extends DelegatingHandler {
        private static final String REQUIRES = "requires";
        List<Require> requires = new ArrayList<Require>();

        public RequiresHandler() {
            super(REQUIRES);
            this.addChild(new ImportHandler(), new DelegatingHandler.ChildElementHandler<ImportHandler>(){

                @Override
                public void childHandled(ImportHandler child) {
                    RequiresHandler.this.requires.add(child.require);
                }
            });
        }
    }

    private static class CopyrightHandler
    extends DelegatingHandler {
        private static final String COPYRIGHT = "copyright";

        public CopyrightHandler() {
            super(COPYRIGHT);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
        }
    }

    private static class LicenseHandler
    extends DelegatingHandler {
        private static final String LICENSE = "license";

        public LicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
        }
    }

    private static class DescriptionHandler
    extends DelegatingHandler {
        private static final String DESCRIPTION = "description";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
        }
    }

    private static class PluginHandler
    extends DelegatingHandler {
        private static final String PLUGIN = "plugin";
        private static final String FILTER = "filter";
        private static final String FRAGMENT = "fragment";
        private static final String UNPACK = "unpack";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private EclipsePlugin plugin;

        public PluginHandler() {
            super(PLUGIN);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            this.plugin = new EclipsePlugin();
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            this.plugin.setId(id);
            this.plugin.setVersion(new Version(version));
            this.plugin.setUnpack(Boolean.valueOf(atts.getValue(UNPACK)));
            this.plugin.setFragment(atts.getValue(FRAGMENT));
            this.plugin.setFilter(atts.getValue(FILTER));
        }
    }

    static class FeatureHandler
    extends DelegatingHandler {
        private static final String FEATURE = "feature";
        private static final String COLOCATION_AFFINITY = "colocation-affinity";
        private static final String PRIMARY = "primary";
        private static final String EXCLUSIVE = "exclusive";
        private static final String PLUGIN = "plugin";
        private static final String APPLICATION = "application";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String PROVIDER_NAME = "provider-name";
        private static final String LABEL = "label";
        private static final String IMAGE = "image";
        EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new DescriptionHandler(), new DelegatingHandler.ChildElementHandler<DescriptionHandler>(){

                @Override
                public void childHandled(DescriptionHandler child) {
                    FeatureHandler.this.feature.setDescription(child.getBufferedChars().trim());
                }
            });
            this.addChild(new LicenseHandler(), new DelegatingHandler.ChildElementHandler<LicenseHandler>(){

                @Override
                public void childHandled(LicenseHandler child) {
                    FeatureHandler.this.feature.setLicense(child.getBufferedChars().trim());
                }
            });
            this.addChild(new CopyrightHandler(), new DelegatingHandler.ChildElementHandler<CopyrightHandler>(){

                @Override
                public void childHandled(CopyrightHandler child) {
                    FeatureHandler.this.feature.setCopyright(child.getBufferedChars().trim());
                }
            });
            this.addChild(new PluginHandler(), new DelegatingHandler.ChildElementHandler<PluginHandler>(){

                @Override
                public void childHandled(PluginHandler child) {
                    FeatureHandler.this.feature.addPlugin(child.plugin);
                }
            });
            this.addChild(new RequiresHandler(), new DelegatingHandler.ChildElementHandler<RequiresHandler>(){

                @Override
                public void childHandled(RequiresHandler child) {
                    for (Require require : child.requires) {
                        FeatureHandler.this.feature.addRequire(require);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            this.feature = new EclipseFeature(id, new Version(version));
            this.feature.setOS(atts.getValue(OS));
            this.feature.setWS(atts.getValue(WS));
            this.feature.setNL(atts.getValue(NL));
            this.feature.setArch(atts.getValue(ARCH));
            this.feature.setApplication(atts.getValue(APPLICATION));
            this.feature.setPlugin(atts.getValue(PLUGIN));
            this.feature.setExclusive(Boolean.valueOf(atts.getValue(EXCLUSIVE)));
            this.feature.setPrimary(Boolean.valueOf(atts.getValue(PRIMARY)));
            this.feature.setColocationAffinity(atts.getValue(COLOCATION_AFFINITY));
            this.feature.setProviderName(atts.getValue(PROVIDER_NAME));
            this.feature.setLabel(atts.getValue(LABEL));
            this.feature.setImage(atts.getValue(IMAGE));
        }
    }
}

