/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.text.rtf.ControlWordToken;
import javax.swing.text.rtf.TextToken;
import javax.swing.text.rtf.Token;

class RTFScanner {
    private Reader in;
    private StringBuffer buffer = new StringBuffer();

    public Token readToken() throws IOException {
        Token token = null;
        int c = this.in.read();
        switch (c) {
            case -1: {
                token = new Token(-1);
                break;
            }
            case 123: {
                token = new Token(1);
                break;
            }
            case 125: {
                token = new Token(2);
                break;
            }
            case 92: {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.append((char)c);
                token = this.readControlWord();
                break;
            }
            default: {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.append((char)c);
                token = this.readText();
                break;
            }
        }
        return token;
    }

    private final Token readControlWord() throws IOException {
        boolean readingName = true;
        String name = null;
        String param = null;
        while (true) {
            this.in.mark(1);
            int c = this.in.read();
            if (readingName && c >= 97 && c <= 122) {
                this.buffer.append((char)c);
                continue;
            }
            if (c < 48 || c > 57) break;
            if (readingName) {
                name = this.buffer.toString();
                this.buffer.delete(0, this.buffer.length());
                readingName = false;
            }
            this.buffer.append((char)c);
        }
        if (readingName) {
            name = this.buffer.toString();
        } else {
            param = this.buffer.toString();
        }
        this.buffer.delete(0, this.buffer.length());
        this.in.reset();
        ControlWordToken token = null;
        token = param == null ? new ControlWordToken(name) : new ControlWordToken(name, Integer.parseInt(param));
        return token;
    }

    private final Token readText() throws IOException {
        boolean readingText = true;
        while (readingText) {
            this.in.mark(1);
            int c = this.in.read();
            switch (c) {
                case -1: 
                case 92: 
                case 123: 
                case 125: {
                    readingText = false;
                    this.in.reset();
                    break;
                }
                default: {
                    this.buffer.append((char)c);
                    break;
                }
            }
        }
        String text = this.buffer.toString();
        TextToken token = new TextToken(text);
        this.buffer.delete(0, this.buffer.length());
        return token;
    }

    private RTFScanner() {
    }

    public RTFScanner(InputStream stream) {
        this();
        InputStreamReader reader = new InputStreamReader(stream);
        this.in = new BufferedReader(reader);
    }

    public RTFScanner(Reader reader) {
        this();
        this.in = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }
}

