/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = 4755994433709540381L;
    char[] content;
    private int count;
    private Vector positions;

    protected final Vector getPositionsInRange(Vector v, int offset, int length) {
        Vector refPos = new Vector();
        Iterator iter = this.positions.iterator();
        while (iter.hasNext()) {
            Position p = (Position)iter.next();
            if (offset > p.getOffset() || p.getOffset() > offset + length) continue;
            refPos.add(p);
        }
        return refPos;
    }

    public final Position createPosition(int offset) throws BadLocationException {
        if (offset < this.count || offset > this.count) {
            this.checkLocation(offset, 0);
        }
        StickyPosition sp = new StickyPosition(offset);
        this.positions.add(sp);
        return sp;
    }

    public final int length() {
        return this.count;
    }

    public final UndoableEdit insertString(int where, String str) throws BadLocationException {
        this.checkLocation(where, 0);
        if (where == this.count) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (str == null) {
            throw new NullPointerException();
        }
        char[] insert = str.toCharArray();
        char[] temp = new char[this.content.length + insert.length];
        this.count += insert.length;
        if (where > 0) {
            System.arraycopy(this.content, 0, temp, 0, where);
        }
        System.arraycopy(insert, 0, temp, where, insert.length);
        System.arraycopy(this.content, where, temp, where + insert.length, temp.length - where - insert.length);
        if (this.content.length < temp.length) {
            this.content = new char[temp.length];
        }
        System.arraycopy(temp, 0, this.content, 0, temp.length);
        Vector refPos = this.getPositionsInRange(this.positions, where, temp.length - where);
        Iterator iter = refPos.iterator();
        while (iter.hasNext()) {
            StickyPosition p = (StickyPosition)iter.next();
            p.setOffset(p.getOffset() + str.length());
        }
        InsertUndo iundo = new InsertUndo(where, insert.length);
        return iundo;
    }

    public final UndoableEdit remove(int where, int nitems) throws BadLocationException {
        this.checkLocation(where, nitems);
        char[] temp = new char[this.content.length - nitems];
        this.count -= nitems;
        RemoveUndo rundo = new RemoveUndo(where, new String(this.content, where, nitems));
        System.arraycopy(this.content, 0, temp, 0, where);
        System.arraycopy(this.content, where + nitems, temp, where, this.content.length - where - nitems);
        this.content = new char[temp.length];
        System.arraycopy(temp, 0, this.content, 0, this.content.length);
        Vector refPos = this.getPositionsInRange(this.positions, where, this.content.length + nitems - where);
        Iterator iter = refPos.iterator();
        while (iter.hasNext()) {
            StickyPosition p = (StickyPosition)iter.next();
            int result = p.getOffset() - nitems;
            p.setOffset(result);
            if (result >= 0) continue;
            this.positions.remove(p);
        }
        return rundo;
    }

    public final String getString(int where, int len) throws BadLocationException {
        this.checkLocation(where, len);
        return new String(this.content, where, len);
    }

    public final void getChars(int where, int len, Segment txt) throws BadLocationException {
        this.checkLocation(where, len);
        if (txt != null) {
            txt.array = this.content;
            txt.offset = where;
            txt.count = len;
        }
    }

    final void checkLocation(int where, int len) throws BadLocationException {
        if (where < 0) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (where > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        if (where + len > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
    }

    private final /* synthetic */ void this() {
        this.positions = new Vector();
    }

    public StringContent() {
        this(1);
    }

    public StringContent(int initialLength) {
        this.this();
        if (initialLength < 1) {
            initialLength = 1;
        }
        this.content = new char[initialLength];
        this.content[0] = 10;
        this.count = 1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StickyPosition
    implements Position {
        private int offset;

        void setOffset(int offset) {
            this.offset = this.offset >= 0 ? offset : -1;
        }

        public int getOffset() {
            int n = 0;
            if (this.offset >= 0) {
                n = this.offset;
            }
            return n;
        }

        private final /* synthetic */ void this() {
            this.offset = -1;
        }

        public StickyPosition(int offset) {
            this.this();
            this.offset = offset;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class InsertUndo
    extends AbstractUndoableEdit {
        private int start;
        private int length;
        private String redoContent;

        public void undo() {
            super.undo();
            try {
                StringContent.this.checkLocation(this.start, this.length);
                this.redoContent = new String(StringContent.this.content, this.start, this.length);
                StringContent.this.remove(this.start, this.length);
            }
            catch (BadLocationException b) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                StringContent.this.insertString(this.start, this.redoContent);
            }
            catch (BadLocationException b) {
                throw new CannotRedoException();
            }
        }

        public InsertUndo(int start, int length) {
            this.start = start;
            this.length = length;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RemoveUndo
    extends AbstractUndoableEdit {
        private int start;
        private String undoString;

        public void undo() {
            super.undo();
            try {
                StringContent.this.insertString(this.start, this.undoString);
            }
            catch (BadLocationException bad) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                int end = this.undoString.length();
                StringContent.this.remove(this.start, end);
            }
            catch (BadLocationException bad) {
                throw new CannotRedoException();
            }
        }

        public RemoveUndo(int start, String str) {
            this.start = start;
            this.undoString = str;
        }
    }
}

