/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resstats;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.resstats.ResStatsPanel;

public class ResStatsPanelImpl
extends JPanel
implements ResStatsPanel {
    private long executionTime;
    private long bodySize;
    private static final String UNKNOWN_NUM = "[x]";
    private final JTextField jtf_execTime = new JTextField("[x]");
    private final JTextField jtf_bodySize = new JTextField("[x]");

    @PostConstruct
    protected void init() {
        this.setLayout(new FlowLayout(0));
        this.jtf_execTime.setFont(UIUtil.FONT_BIG);
        this.jtf_bodySize.setFont(UIUtil.FONT_BIG);
        this.jtf_execTime.setEditable(false);
        this.jtf_bodySize.setEditable(false);
        JPanel jp = new JPanel(new GridLayout(2, 3));
        JLabel jl = new JLabel("Response time: ");
        jl.setFont(UIUtil.FONT_BIG);
        jp.add(jl);
        jp.add(this.jtf_execTime);
        jp.add(new JLabel(" ms"));
        jl = new JLabel("Body size: ");
        jl.setFont(UIUtil.FONT_BIG);
        jp.add(jl);
        jp.add(this.jtf_bodySize);
        jp.add(new JLabel(" bytes"));
        this.add(jp);
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public long getBodySize() {
        return this.bodySize;
    }

    @Override
    public void setExecutionTime(long time) {
        this.executionTime = time;
        String val = time == 0L ? UNKNOWN_NUM : String.valueOf(time);
        this.jtf_execTime.setText(val);
    }

    @Override
    public void setBodySize(long size) {
        this.bodySize = size;
        String val = size == 0L ? UNKNOWN_NUM : String.valueOf(size);
        this.jtf_bodySize.setText(val);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.setExecutionTime(0L);
        this.setBodySize(0L);
    }
}

