<?php

namespace Geeklog\Text\Wiki;

/**
 * Center rule end renderer for Xhtml
 * PHP versions 4 and 5
 *
 * @category   Text
 * @package    Text_Wiki
 * @author     Paul M. Jones <pmjones@php.net>
 * @license    http://www.gnu.org/copyleft/lesser.html  LGPL License 2.1
 * @version    CVS: $Id: Center.php 230212 2007-02-19 08:51:19Z mic $
 * @link       http://pear.php.net/package/Text_Wiki
 */

/**
 * This class renders centered content in XHTML.
 *
 * @category   Text
 * @package    Text_Wiki
 * @author     Paul M. Jones <pmjones@php.net>
 * @license    http://www.gnu.org/copyleft/lesser.html  LGPL License 2.1
 * @version    Release: @package_version@
 * @link       http://pear.php.net/package/Text_Wiki
 */
class Text_Wiki_Render_Xhtml_Center extends Text_Wiki_Render
{
    public $conf = array(
        'css' => null,
    );

    /**
     * Renders a token into text matching the requested format.
     *
     * @param array $options The "options" portion of the token (second
     *                       element).
     * @return string The text rendered from the token options.
     */
    public function token($options)
    {
        if ($options['type'] === 'start') {
            $css = $this->getConf('css');
            if ($css) {
                return "<div class=\"{$css}\">";
            } else {
                return '<div style="text-align: center;">';
            }
        }

        if ($options['type'] === 'end') {
            return '</div>';
        }

        return null;
    }
}
