require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_UFS_UFS_WAPBL_H_)) {
    eval 'sub _UFS_UFS_UFS_WAPBL_H_ () {1;}' unless defined(&_UFS_UFS_UFS_WAPBL_H_);
    if(defined(&_KERNEL_OPT)) {
	require './ufs/ufs/opt_wapbl.ph';
    }
    eval 'sub UFS_WAPBL_VERSION () {1;}' unless defined(&UFS_WAPBL_VERSION);
    eval 'sub UFS_WAPBL_JOURNALLOC_NONE () {0;}' unless defined(&UFS_WAPBL_JOURNALLOC_NONE);
    eval 'sub UFS_WAPBL_JOURNALLOC_END_PARTITION () {1;}' unless defined(&UFS_WAPBL_JOURNALLOC_END_PARTITION);
    eval 'sub UFS_WAPBL_EPART_ADDR () {0;}' unless defined(&UFS_WAPBL_EPART_ADDR);
    eval 'sub UFS_WAPBL_EPART_COUNT () {1;}' unless defined(&UFS_WAPBL_EPART_COUNT);
    eval 'sub UFS_WAPBL_EPART_BLKSZ () {2;}' unless defined(&UFS_WAPBL_EPART_BLKSZ);
    eval 'sub UFS_WAPBL_EPART_UNUSED () {3;}' unless defined(&UFS_WAPBL_EPART_UNUSED);
    eval 'sub UFS_WAPBL_JOURNALLOC_IN_FILESYSTEM () {2;}' unless defined(&UFS_WAPBL_JOURNALLOC_IN_FILESYSTEM);
    eval 'sub UFS_WAPBL_INFS_ADDR () {0;}' unless defined(&UFS_WAPBL_INFS_ADDR);
    eval 'sub UFS_WAPBL_INFS_COUNT () {1;}' unless defined(&UFS_WAPBL_INFS_COUNT);
    eval 'sub UFS_WAPBL_INFS_BLKSZ () {2;}' unless defined(&UFS_WAPBL_INFS_BLKSZ);
    eval 'sub UFS_WAPBL_INFS_INO () {3;}' unless defined(&UFS_WAPBL_INFS_INO);
    eval 'sub UFS_WAPBL_FLAGS_CREATE_LOG () {0x1;}' unless defined(&UFS_WAPBL_FLAGS_CREATE_LOG);
    eval 'sub UFS_WAPBL_FLAGS_CLEAR_LOG () {0x2;}' unless defined(&UFS_WAPBL_FLAGS_CLEAR_LOG);
    eval 'sub UFS_WAPBL_JOURNAL_SCALE () {1024;}' unless defined(&UFS_WAPBL_JOURNAL_SCALE);
    eval 'sub UFS_WAPBL_MIN_JOURNAL_SIZE () {(1024* 1024);}' unless defined(&UFS_WAPBL_MIN_JOURNAL_SIZE);
    eval 'sub UFS_WAPBL_MAX_JOURNAL_SIZE () {(64* 1024* 1024);}' unless defined(&UFS_WAPBL_MAX_JOURNAL_SIZE);
    if(defined(&WAPBL)) {
	eval 'sub ufs_wapbl_begin {
	    my($mp,$file,$line) = @_;
    	    eval q({  &if ( ($mp->{mnt_wapbl})) { \'int\'  &error;  &error =  &wapbl_begin( ($mp->{mnt_wapbl}), $file, $line);  &if ( &error)  &error; } 0; });
	}' unless defined(&ufs_wapbl_begin);
	eval 'sub ufs_wapbl_end {
	    my($mp) = @_;
    	    eval q({  &if ( ($mp->{mnt_wapbl})) {  &wapbl_end( ($mp->{mnt_wapbl})); } });
	}' unless defined(&ufs_wapbl_end);
	eval 'sub UFS_WAPBL_BEGIN {
	    my($mp) = @_;
    	    eval q( &ufs_wapbl_begin($mp,  &__func__,  &__LINE__));
	}' unless defined(&UFS_WAPBL_BEGIN);
	eval 'sub UFS_WAPBL_END {
	    my($mp) = @_;
    	    eval q( &ufs_wapbl_end($mp));
	}' unless defined(&UFS_WAPBL_END);
	eval 'sub UFS_WAPBL_UPDATE {
	    my($vp, $access, $modify, $flags) = @_;
    	    eval q( &if (($vp)-> ($v_mount->{mnt_wapbl})) {  &UFS_UPDATE($vp, $access, $modify, $flags); });
	}' unless defined(&UFS_WAPBL_UPDATE);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub UFS_WAPBL_JLOCK_ASSERT {
	        my($mp) = @_;
    		eval q( &if ( ($mp->{mnt_wapbl}))  &wapbl_jlock_assert( ($mp->{mnt_wapbl})));
	    }' unless defined(&UFS_WAPBL_JLOCK_ASSERT);
	    eval 'sub UFS_WAPBL_JUNLOCK_ASSERT {
	        my($mp) = @_;
    		eval q( &if ( ($mp->{mnt_wapbl}))  &wapbl_junlock_assert( ($mp->{mnt_wapbl})));
	    }' unless defined(&UFS_WAPBL_JUNLOCK_ASSERT);
	} else {
	    eval 'sub UFS_WAPBL_JLOCK_ASSERT {
	        my($mp) = @_;
    		eval q();
	    }' unless defined(&UFS_WAPBL_JLOCK_ASSERT);
	    eval 'sub UFS_WAPBL_JUNLOCK_ASSERT {
	        my($mp) = @_;
    		eval q();
	    }' unless defined(&UFS_WAPBL_JUNLOCK_ASSERT);
	}
	eval 'sub UFS_WAPBL_REGISTER_INODE {
	    my($mp, $ino, $mode) = @_;
    	    eval q( &if ( ($mp->{mnt_wapbl}))  &wapbl_register_inode( ($mp->{mnt_wapbl}), $ino, $mode));
	}' unless defined(&UFS_WAPBL_REGISTER_INODE);
	eval 'sub UFS_WAPBL_UNREGISTER_INODE {
	    my($mp, $ino, $mode) = @_;
    	    eval q( &if ( ($mp->{mnt_wapbl}))  &wapbl_unregister_inode( ($mp->{mnt_wapbl}), $ino, $mode));
	}' unless defined(&UFS_WAPBL_UNREGISTER_INODE);
	eval 'sub UFS_WAPBL_REGISTER_DEALLOCATION {
	    my($mp, $blk, $len, $cookiep) = @_;
    	    eval q(( ($mp->{mnt_wapbl})) ?  &wapbl_register_deallocation( ($mp->{mnt_wapbl}), $blk, $len,  &false, $cookiep) : 0);
	}' unless defined(&UFS_WAPBL_REGISTER_DEALLOCATION);
	eval 'sub UFS_WAPBL_REGISTER_DEALLOCATION_FORCE {
	    my($mp, $blk, $len) = @_;
    	    eval q(( ( ($mp->{mnt_wapbl})) ?  &wapbl_register_deallocation( ($mp->{mnt_wapbl}), $blk, $len,  &true,  &NULL) : 0));
	}' unless defined(&UFS_WAPBL_REGISTER_DEALLOCATION_FORCE);
	eval 'sub UFS_WAPBL_UNREGISTER_DEALLOCATION {
	    my($mp, $cookie) = @_;
    	    eval q( &if ( ($mp->{mnt_wapbl}))  &wapbl_unregister_deallocation( ($mp->{mnt_wapbl}), $cookie));
	}' unless defined(&UFS_WAPBL_UNREGISTER_DEALLOCATION);
    } else {
	eval 'sub UFS_WAPBL_BEGIN {
	    my($mp) = @_;
    	    eval q(( &__USE($mp), 0));
	}' unless defined(&UFS_WAPBL_BEGIN);
	eval 'sub UFS_WAPBL_END {
	    my($mp) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&UFS_WAPBL_END);
	eval 'sub UFS_WAPBL_UPDATE {
	    my($vp, $access, $modify, $flags) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&UFS_WAPBL_UPDATE);
	eval 'sub UFS_WAPBL_JLOCK_ASSERT {
	    my($mp) = @_;
    	    eval q();
	}' unless defined(&UFS_WAPBL_JLOCK_ASSERT);
	eval 'sub UFS_WAPBL_JUNLOCK_ASSERT {
	    my($mp) = @_;
    	    eval q();
	}' unless defined(&UFS_WAPBL_JUNLOCK_ASSERT);
	eval 'sub UFS_WAPBL_REGISTER_INODE {
	    my($mp, $ino, $mode) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&UFS_WAPBL_REGISTER_INODE);
	eval 'sub UFS_WAPBL_UNREGISTER_INODE {
	    my($mp, $ino, $mode) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&UFS_WAPBL_UNREGISTER_INODE);
	eval 'sub UFS_WAPBL_REGISTER_DEALLOCATION {
	    my($mp, $blk, $len, $cookiep) = @_;
    	    eval q(0);
	}' unless defined(&UFS_WAPBL_REGISTER_DEALLOCATION);
	eval 'sub UFS_WAPBL_REGISTER_DEALLOCATION_FORCE {
	    my($mp, $blk, $len) = @_;
    	    eval q(0);
	}' unless defined(&UFS_WAPBL_REGISTER_DEALLOCATION_FORCE);
	eval 'sub UFS_WAPBL_UNREGISTER_DEALLOCATION {
	    my($mp, $cookie) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&UFS_WAPBL_UNREGISTER_DEALLOCATION);
    }
}
1;
