define("tool_capability/search",["exports","core/pending","core/utils"],(function(_exports,_pending,_utils){var obj;
/**
   * Add search filtering of capabilities
   *
   * @module      tool_capability/search
   * @copyright   2023 Paul Holden <paulh@moodle.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_pending=(obj=_pending)&&obj.__esModule?obj:{default:obj};const Selectors_capabilityOverviewForm="#capability-overview-form",Selectors_capabilitySelect='[data-search="capability"]',Selectors_capabilitySearch='[data-action="search"]';_exports.init=()=>{const capabilityOverviewForm=document.querySelector(Selectors_capabilityOverviewForm);if(!capabilityOverviewForm)return;const capabilitySelect=capabilityOverviewForm.querySelector(Selectors_capabilitySelect),capabilitySearch=capabilityOverviewForm.querySelector(Selectors_capabilitySearch),capabilitySelectFilter=searchTerm=>{const pendingPromise=new _pending.default("tool_capability/search:filter");let capabilitySelected=[];capabilitySelect.querySelectorAll("option").forEach((option=>{option.selected&&capabilitySelected.push(option.value),option.remove()}));const availableCapabilities=JSON.parse(capabilitySelect.dataset.availableCapabilities),filteredCapabilities=Object.keys(availableCapabilities).reduce(((matches,capability)=>(availableCapabilities[capability].toLowerCase().includes(searchTerm)&&(matches[capability]=availableCapabilities[capability]),matches)),[]);Object.entries(filteredCapabilities).forEach((_ref=>{let[capability,capabilityText]=_ref;const option=document.createElement("option");option.value=capability,option.innerText=capabilityText,option.selected=capabilitySelected.indexOf(capability)>-1,capabilitySelect.append(option)})),pendingPromise.resolve()},availableCapabilities={};capabilitySelect.querySelectorAll("option").forEach((option=>{availableCapabilities[option.value]=option.text})),capabilitySelect.dataset.availableCapabilities=JSON.stringify(availableCapabilities);const capabilitySearchDebounce=(0,_utils.debounce)(capabilitySelectFilter,250);capabilitySearch.addEventListener("keyup",(event=>{const pendingPromise=new _pending.default("tool_capability/search:keyup");capabilitySearchDebounce(event.target.value.toLowerCase()),setTimeout((()=>{pendingPromise.resolve()}),250)})),""!==capabilitySearch.value&&capabilitySelectFilter(capabilitySearch.value.toLowerCase())}}));

//# sourceMappingURL=search.min.js.map