/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MidiSystem {
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiDeviceProvider;
    static /* synthetic */ Class class$javax$sound$midi$spi$SoundbankReader;
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiFileReader;
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiFileWriter;

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        Class clazz = class$javax$sound$midi$spi$MidiDeviceProvider;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiDeviceProvider = MidiSystem.class("[Ljavax.sound.midi.spi.MidiDeviceProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)iterator.next();
            MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
            int n = infoArray.length;
            while (n > 0) {
                arrayList.add(infoArray[--n]);
            }
        }
        return (MidiDevice.Info[])arrayList.toArray(new MidiDevice.Info[arrayList.size()]);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        Iterator iterator;
        Class clazz = class$javax$sound$midi$spi$MidiDeviceProvider;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiDeviceProvider = MidiSystem.class("[Ljavax.sound.midi.spi.MidiDeviceProvider;", false);
        }
        if (!(iterator = ServiceFactory.lookupProviders(clazz)).hasNext()) {
            throw new MidiUnavailableException("No MIDI device providers available.");
        }
        do {
            MidiDeviceProvider midiDeviceProvider;
            if (!(midiDeviceProvider = (MidiDeviceProvider)iterator.next()).isDeviceSupported(info)) continue;
            return midiDeviceProvider.getDevice(info);
        } while (iterator.hasNext());
        throw new IllegalArgumentException("MIDI device " + info + " not available.");
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            if (midiDevice instanceof Receiver) {
                return (Receiver)((Object)midiDevice);
            }
            ++n;
        }
        throw new MidiUnavailableException("No Receiver device available");
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            if (midiDevice instanceof Transmitter) {
                return (Transmitter)((Object)midiDevice);
            }
            ++n;
        }
        throw new MidiUnavailableException("No Transmitter device available");
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            if (midiDevice instanceof Synthesizer) {
                return (Synthesizer)midiDevice;
            }
            ++n;
        }
        throw new MidiUnavailableException("No Synthesizer device available");
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
            if (midiDevice instanceof Sequencer) {
                return (Sequencer)midiDevice;
            }
            ++n;
        }
        throw new MidiUnavailableException("No Sequencer device available");
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$SoundbankReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$SoundbankReader = MidiSystem.class("[Ljavax.sound.midi.spi.SoundbankReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = (SoundbankReader)iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$SoundbankReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$SoundbankReader = MidiSystem.class("[Ljavax.sound.midi.spi.SoundbankReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = (SoundbankReader)iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$SoundbankReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$SoundbankReader = MidiSystem.class("[Ljavax.sound.midi.spi.SoundbankReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = (SoundbankReader)iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(file);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from file " + file);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(inputStream);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from stream");
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(uRL);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(file);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from file " + file);
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            Sequence sequence = midiFileReader.getSequence(inputStream);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Can't read Sequence from stream");
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            Sequence sequence = midiFileReader.getSequence(uRL);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            Sequence sequence = midiFileReader.getSequence(file);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Can't read Sequence from file " + file);
    }

    public static int[] getMidiFileTypes() {
        Object object;
        boolean[] blArray = new boolean[3];
        int n = 0;
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            object = (MidiFileWriter)iterator.next();
            int[] nArray = ((MidiFileWriter)object).getMidiFileTypes();
            int n2 = nArray.length;
            while (n2 > 0) {
                int n3;
                if (blArray[n3 = nArray[--n2]]) continue;
                ++n;
                blArray[n3] = true;
            }
        }
        object = new int[n];
        int n4 = blArray.length;
        while (n4 > 0) {
            if (!blArray[--n4]) continue;
            object[--n] = n4;
        }
        return object;
    }

    public static boolean isFileTypeSupported(int n) {
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        Object object;
        boolean[] blArray = new boolean[3];
        int n = 0;
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            object = (MidiFileWriter)iterator.next();
            int[] nArray = ((MidiFileWriter)object).getMidiFileTypes(sequence);
            int n2 = nArray.length;
            while (n2 > 0) {
                int n3;
                if (blArray[n3 = nArray[--n2]]) continue;
                ++n;
                blArray[n3] = true;
            }
        }
        object = new int[n];
        int n4 = blArray.length;
        while (n4 > 0) {
            if (!blArray[--n4]) continue;
            object[--n] = n4;
        }
        return object;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return midiFileWriter.write(sequence, n, outputStream);
        }
        throw new IllegalArgumentException("File type " + n + " is not supported");
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = MidiSystem.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return midiFileWriter.write(sequence, n, file);
        }
        throw new IllegalArgumentException("File type " + n + " is not supported");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private MidiSystem() {
    }
}

