/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.keyring.GnuPrivateKeyring;
import gnu.javax.crypto.keyring.GnuPublicKeyring;
import gnu.javax.crypto.keyring.IKeyring;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;

public class GnuKeyring
extends KeyStoreSpi {
    private boolean loaded;
    private IKeyring keyring;

    public Enumeration engineAliases() {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return new Enumeration(){

                public final boolean hasMoreElements() {
                    return false;
                }

                public final Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        return this.keyring.aliases();
    }

    public boolean engineContainsAlias(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return false;
        }
        return this.keyring.containsAlias(string);
    }

    public void engineDeleteEntry(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring != null) {
            this.keyring.remove(string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return null;
        }
        if (!(this.keyring instanceof IPublicKeyring)) {
            throw new IllegalStateException("not a public keyring");
        }
        return ((IPublicKeyring)this.keyring).getCertificate(string);
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return null;
        }
        if (!(this.keyring instanceof IPublicKeyring)) {
            throw new IllegalStateException("not a public keyring");
        }
        Enumeration enumeration = this.keyring.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Certificate certificate2 = ((IPublicKeyring)this.keyring).getCertificate(string);
            if (!certificate.equals(certificate2)) continue;
            return string;
        }
        return null;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            this.keyring = new GnuPublicKeyring("HMAC-SHA-1", 20);
        }
        if (!(this.keyring instanceof IPublicKeyring)) {
            throw new IllegalStateException("not a public keyring");
        }
        ((IPublicKeyring)this.keyring).putCertificate(string, certificate);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return null;
        }
        if (!(this.keyring instanceof IPrivateKeyring)) {
            throw new IllegalStateException("not a private keyring");
        }
        return ((IPrivateKeyring)this.keyring).getCertPath(string);
    }

    public Date engineGetCreationDate(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return null;
        }
        List list2 = this.keyring.get(string);
        if (list2.size() == 0) {
            return null;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof PrimitiveEntry)) continue;
            return ((PrimitiveEntry)object).getCreationDate();
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return null;
        }
        if (!(this.keyring instanceof IPrivateKeyring)) {
            throw new IllegalStateException("not a private keyring");
        }
        if (cArray == null && ((IPrivateKeyring)this.keyring).containsPublicKey(string)) {
            return ((IPrivateKeyring)this.keyring).getPublicKey(string);
        }
        if (((IPrivateKeyring)this.keyring).containsPrivateKey(string)) {
            return ((IPrivateKeyring)this.keyring).getPrivateKey(string, cArray);
        }
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            this.keyring = new GnuPrivateKeyring("HMAC-SHA-1", 20, "AES", "OFB", 16);
        }
        if (!(this.keyring instanceof IPrivateKeyring)) {
            throw new IllegalStateException("not a private keyring");
        }
        if (key instanceof PublicKey) {
            ((IPrivateKeyring)this.keyring).putPublicKey(string, (PublicKey)key);
            return;
        }
        if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
            throw new KeyStoreException("cannot store keys of type " + key.getClass().getName());
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ((IPrivateKeyring)this.keyring).putCertPath(string, certificateArray);
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        ((IPrivateKeyring)this.keyring).putPrivateKey(string, key, cArray);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("method not supported");
    }

    public boolean engineIsCertificateEntry(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return false;
        }
        if (!(this.keyring instanceof IPublicKeyring)) {
            return false;
        }
        return ((IPublicKeyring)this.keyring).containsCertificate(string);
    }

    public boolean engineIsKeyEntry(String string) {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return false;
        }
        if (!(this.keyring instanceof IPrivateKeyring)) {
            return false;
        }
        boolean bl = false;
        if (((IPrivateKeyring)this.keyring).containsPublicKey(string) || ((IPrivateKeyring)this.keyring).containsPrivateKey(string)) {
            bl = true;
        }
        return bl;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(5);
            int n = 0;
            while (n < 4) {
                if (inputStream.read() != Registry.GKR_MAGIC[n]) {
                    throw new MalformedKeyringException("incorrect magic");
                }
                ++n;
            }
            n = inputStream.read();
            inputStream.reset();
            HashMap hashMap = new HashMap();
            hashMap.put("gnu.crypto.keyring.data.in", inputStream);
            hashMap.put("gnu.crypto.keyring.password", cArray);
            switch (n) {
                case 4: {
                    this.keyring = new GnuPublicKeyring();
                    break;
                }
                case 3: {
                    this.keyring = new GnuPrivateKeyring();
                    break;
                }
                default: {
                    throw new MalformedKeyringException("unsupported ring usage: " + Integer.toBinaryString(n));
                }
            }
            this.keyring.load(hashMap);
        }
        this.loaded = true;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        if (!this.loaded || this.keyring == null) {
            throw new IllegalStateException("not loaded");
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gun.crypto.keyring.data.out", outputStream);
        hashMap.put("gnu.crypto.keyring.password", cArray);
        this.keyring.store(hashMap);
    }

    public int engineSize() {
        if (!this.loaded) {
            throw new IllegalStateException("not loaded");
        }
        if (this.keyring == null) {
            return 0;
        }
        return this.keyring.size();
    }
}

