/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS = new Object[0];

    public static final Object getInstance(String string, String string2, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(string, string2, provider, NO_ARGS);
    }

    public static final Object getInstance(String string, String string2, Provider provider, Object[] objectArray) throws InvocationTargetException, NoSuchAlgorithmException {
        Object object;
        if (string != null) {
            string = string.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || provider == null || objectArray == null) {
            throw new IllegalArgumentException();
        }
        if (provider.getProperty(string + '.' + string2) == null) {
            object = null;
            int n = 0;
            while ((object = provider.getProperty(ALG_ALIAS + string + '.' + string2)) != null) {
                if (string2.equals(object)) break;
                string2 = object;
                if (n++ <= 5) continue;
                throw new NoSuchAlgorithmException("too many aliases");
            }
            if (provider.getProperty(string + '.' + string2) == null) {
                throw new NoSuchAlgorithmException(string2);
            }
        }
        object = null;
        ClassLoader classLoader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String string3 = string2;
        try {
            object = classLoader != null ? classLoader.loadClass(provider.getProperty(string + '.' + string2)) : Class.forName(provider.getProperty(string + '.' + string2));
            constructor = Engine.getCompatibleConstructor((Class)object, objectArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string3 = "class not found: " + string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            string3 = "illegal access: " + illegalAccessException.getMessage();
        }
        catch (InstantiationException instantiationException) {
            string3 = "instantiation exception: " + instantiationException.getMessage();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            string3 = "exception in initializer: " + exceptionInInitializerError.getMessage();
        }
        catch (SecurityException securityException) {
            string3 = "security exception: " + securityException.getMessage();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string3 = "no appropriate constructor found";
        }
        throw new NoSuchAlgorithmException(string3);
    }

    private static final Constructor getCompatibleConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException {
        Constructor[] constructorArray = clazz.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            block4: {
                Class[] classArray = constructorArray[n].getParameterTypes();
                if (classArray.length == objectArray.length) {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        if (objectArray[n2] == null || classArray[n2].isAssignableFrom(objectArray[n2].getClass())) {
                            ++n2;
                            continue;
                        }
                        break block4;
                    }
                    return constructorArray[n];
                }
            }
            ++n;
        }
        throw new NoSuchMethodException();
    }

    private Engine() {
    }
}

