/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolEntry;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpoolFloat
extends CpoolEntry {
    float value;

    public int getTag() {
        return 4;
    }

    static final int hashCode(float f) {
        return (int)f;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(4);
        dataOutputStream.writeFloat(this.value);
    }

    public void print(ClassTypeWriter classTypeWriter, int n) {
        if (n > 0) {
            classTypeWriter.print("Float ");
        }
        classTypeWriter.print(this.value);
        if (n > 1) {
            classTypeWriter.print("=0x");
            classTypeWriter.print(Integer.toHexString(Float.floatToIntBits(this.value)));
        }
    }

    CpoolFloat(ConstantPool constantPool, int n, float f) {
        super(constantPool, n);
        this.value = f;
        ++constantPool.count;
    }
}

