/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.sgf;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.igoweb.go.Goban;
import org.igoweb.go.Loc;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.GameUpdater;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.SgfException;
import org.igoweb.go.sgf.Tree;
import org.igoweb.util.Defs;
import org.igoweb.util.EventListener;

public class FileIo {
    protected static final int TOKEN_PROP = 0;
    protected static final int TOKEN_CONTINUED_PROP = 1;
    protected static final int TOKEN_NODE = 2;
    protected static final int TOKEN_NEW_BRANCH = 3;
    protected static final int TOKEN_END_BRANCH = 4;
    protected static final int TOKEN_EOF = 5;
    private static final int PROP_FILEFORMAT = -1;
    private static final int PROP_GAMETYPE = -2;
    private static final int PROP_APPLICATION = -3;
    private static final int PROP_STYLE = -4;
    private static final int PROP_CHARENCODING = -5;
    private static final int RULEPROP_SIZE = 0;
    private static final int RULEPROP_RULESET = 1;
    private static final int RULEPROP_TIME = 2;
    private static final int RULEPROP_HANDICAP = 3;
    private static final int RULEPROP_KOMI = 4;
    private static final int RULEPROP_OVERTIME = 5;
    private int fileStyle = 2;
    private static final String[] ruleTypeNames = new String[]{"Japanese", "Chinese", "AGA", "NZ"};
    private File defaultFile = null;
    private static final HashMap<String, PropInfo> paramCodeToInfo = new HashMap();
    private static final ArrayList<String> paramTypeToCode = new ArrayList();
    protected Rules rules;
    private boolean sizeForcedTo19 = false;
    private boolean ambiguousPasses = true;
    private final boolean[] rulePropsFound = new boolean[]{false, false, false, false, false, false};
    private final NumberFormat timeFormatter = FileIo.makeTimeFormatter();
    protected final NumberFormat scoreFormatter = FileIo.makeScoreFormatter();
    public final Tree tree;
    private boolean modified = true;
    private String prevCode = null;
    private StringBuilder warnBuf = new StringBuilder();
    private final EventListener treeListener = event -> {
        if (event.type != 3 && event.type != 7) {
            this.setModified(true);
        }
    };

    public FileIo(Tree newTree) {
        this.tree = newTree;
        Prop prop = newTree.root.findProp(0);
        this.rules = prop == null ? new Rules(19) : prop.getRules();
    }

    public FileIo(File fileName, InputStream in) throws IOException, SgfException {
        this.defaultFile = fileName;
        this.tree = new Tree();
        if (fileName == null && in == null) {
            this.defaultFile = new File(Defs.getString(720104014));
            this.tree.add(new Prop(0, new Rules()));
        } else {
            if (in == null) {
                in = new FileInputStream(fileName);
            }
            try (SgfReader reader = new SgfReader(in);){
                this.readNode(this.tree.root, reader);
                this.resetActiveNode(this.tree.root);
                if (this.tree.root.findProp(0) == null) {
                    this.tree.root.add(new Prop(0, new Rules()));
                }
            }
        }
        this.convertStyle(this.fileStyle);
        this.tree.setActiveNode(this.tree.root);
        this.setModified(false);
        this.rules = null;
    }

    protected void readNode(Node node, SgfReader in) throws IOException, SgfException {
        ArrayList<Prop> props = new ArrayList<Prop>();
        if (node == this.tree.root) {
            this.rules = new Rules(19);
            props.add(new Prop(0, this.rules));
        }
        while (true) {
            props.clear();
            int nextToken = this.readProps(in, props);
            for (Prop prop : props) {
                try {
                    if (node.add(prop, true, true)) continue;
                    this.warnBuf.append(Defs.getString(720104003, new Object[]{this.getPropCode(prop), in.lineNumber()})).append('\n');
                }
                catch (Node.IllegalNodeError excep) {
                    this.tree.root.add(prop);
                }
            }
            if (!this.rulePropsFound[0]) {
                this.forceSize19();
            }
            switch (nextToken) {
                case 2: {
                    node = this.tree.addNode(node);
                    break;
                }
                case 3: {
                    this.readNode(this.tree.addNode(node), in);
                    break;
                }
                case 4: {
                    return;
                }
                case 5: {
                    throw new SgfException(3, Defs.getString(720104021, in.lineNumber()));
                }
            }
        }
    }

    protected int readProps(SgfReader in, Collection<Prop> result) throws IOException, SgfException {
        int tokenType;
        PropInfo info = null;
        String code = null;
        int argNum = 0;
        boolean rulesAdded = false;
        block4: while (true) {
            tokenType = this.readTokenType(in);
            int lineNumber = in.lineNumber();
            switch (tokenType) {
                case 0: {
                    argNum = 0;
                    code = this.fetchCode(in);
                    info = paramCodeToInfo.get(code);
                    if (info == null) {
                        result.add(new Prop(29, code + ' ' + this.fetchArg(in)));
                    } else if (info.type != -5) {
                        this.parseProp(info.type, info.subtype, this.fetchArg(in), lineNumber, 0, result);
                    }
                    if (info == null || info.type != 0 || rulesAdded) continue block4;
                    result.add(new Prop(0, this.rules));
                    rulesAdded = true;
                    continue block4;
                }
                case 1: {
                    if (info == null) {
                        if (code == null) {
                            throw new SgfException(2, Defs.getString(720104017, in.lineNumber()));
                        }
                        result.add(new Prop(29, code + ' ' + this.fetchArg(in)));
                        continue block4;
                    }
                    this.parseProp(info.type, info.subtype, this.fetchArg(in), lineNumber, ++argNum, result);
                    continue block4;
                }
            }
            break;
        }
        return tokenType;
    }

    private void forceSize19() throws SgfException {
        this.rulePropsFound[0] = true;
        for (Prop p : this.tree.root) {
            if (!p.hasLoc()) continue;
            Loc loc = p.getLoc();
            if (loc.x < 19 && loc.y < 19) continue;
            throw new SgfException(10, Defs.getString(720104009, new Object[]{FileIo.formatLoc(loc), 1}));
        }
    }

    private int readTokenType(SgfReader in) throws IOException, SgfException {
        int c;
        int lineNum = in.lineNumber();
        do {
            if ((c = in.read()) == -1) {
                return 5;
            }
            if (c == 59) {
                return 2;
            }
            if (c == 41) {
                return 4;
            }
            if (c == 40) {
                lineNum = in.lineNumber();
                while ((c = in.read()) != 59) {
                    if (c != -1 && Character.isWhitespace((char)c)) continue;
                    throw new SgfException(4, Defs.getString(720104005, lineNum));
                }
                return 3;
            }
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                in.unread();
                return 0;
            }
            if (c != 91) continue;
            in.unread();
            return 1;
        } while (Character.isWhitespace((char)c));
        throw new SgfException(5, Defs.getString(720104002, lineNum));
    }

    private String fetchCode(SgfReader in) throws IOException, SgfException {
        int c;
        int lineNum = in.lineNumber();
        StringBuilder code = new StringBuilder(2);
        do {
            if ((c = in.read()) < 65 || c > 90) continue;
            code.append((char)c);
        } while (c >= 65 && c <= 90 || c >= 97 && c <= 122);
        if (c != -1) {
            in.unread();
        }
        if (code.length() == 0) {
            throw new SgfException(6, Defs.getString(720104000, lineNum));
        }
        return code.toString();
    }

    protected void parseProp(int type, int subtype, String arg, int lineNumber, int argNum, Collection<Prop> result) throws IOException, SgfException {
        block2 : switch (type) {
            case 19: {
                if (subtype == 0) {
                    if (argNum > 25) {
                        argNum = 25;
                    }
                    result.add(new Prop(19, this.parseLoc(arg, lineNumber), "" + (char)(65 + argNum)));
                    break;
                }
                result.add(this.parseLabel(arg, lineNumber));
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: {
                Iterator<Loc> locs = this.parseLocs(arg, lineNumber);
                while (locs.hasNext()) {
                    Loc loc = locs.next();
                    if (Prop.hasColor(type)) {
                        result.add(new Prop(type, subtype, loc));
                        continue;
                    }
                    result.add(new Prop(type, loc));
                }
                break;
            }
            case 14: {
                result.add(new Prop(14, subtype, this.parseLoc(arg, lineNumber)));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: 
            case 28: {
                if (Prop.hasColor(type)) {
                    result.add(new Prop(type, subtype, arg));
                    break;
                }
                result.add(new Prop(type, arg));
                break;
            }
            case 27: {
                result.add(new Prop(type, this.parseInt(arg, lineNumber)));
                break;
            }
            case 3: {
                try {
                    result.add(new Prop(3, subtype, this.parseRank(arg, lineNumber)));
                }
                catch (SgfException excep) {
                    this.warnBuf.append(excep.getMessage()).append('\n');
                }
                break;
            }
            case 25: {
                try {
                    result.add(FileIo.parseResult(arg, lineNumber));
                }
                catch (SgfException excep) {
                    this.warnBuf.append(excep.getMessage()).append('\n');
                }
                break;
            }
            case 0: {
                this.parseRules(subtype, arg, lineNumber);
                break;
            }
            case 18: {
                this.parseTimeProp(result, subtype & 1, (subtype & 2) == 0, arg, lineNumber);
                break;
            }
            case -1: {
                this.handleFileFormat(this.parseInt(arg, lineNumber));
                break;
            }
            case -2: {
                if (this.parseInt(arg, lineNumber) == 1) break;
                throw new SgfException(7, Defs.getString(720104007, FileIo.clipText(arg)));
            }
            case -5: {
                break;
            }
            case -3: {
                this.handleApplication(arg);
                break;
            }
            case -4: {
                this.fileStyle = this.parseInt(arg, lineNumber);
                break;
            }
            case 26: {
                switch (arg = arg.trim()) {
                    case "B": 
                    case "1": {
                        result.add(new Prop(26, 0));
                        break block2;
                    }
                    case "W": 
                    case "2": {
                        result.add(new Prop(26, 1));
                        break block2;
                    }
                }
                throw new SgfException(8, Defs.getString(720103996, new Object[]{FileIo.clipText(arg), lineNumber}));
            }
            default: {
                throw new IllegalArgumentException("Don't know how to read type " + type);
            }
        }
    }

    private String fetchArg(SgfReader in) throws IOException, SgfException {
        int c;
        int lineNum = in.lineNumber();
        while ((c = in.read()) != 91) {
            if (c != -1 || Character.isWhitespace((char)c)) continue;
            throw new SgfException(9, Defs.getString(720104016, lineNum));
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        lineNum = in.lineNumber();
        boolean argDone = false;
        do {
            c = in.read();
            if (escaped && c != -1) {
                result.append((char)c);
                escaped = false;
                continue;
            }
            switch (c) {
                case -1: {
                    throw new SgfException(3, Defs.getString(720104011, lineNum));
                }
                case 92: {
                    escaped = true;
                    break;
                }
                case 93: {
                    argDone = true;
                    break;
                }
                default: {
                    result.append((char)c);
                }
            }
        } while (!argDone);
        return result.toString();
    }

    public void setFile(File newDefaultFile) {
        this.defaultFile = newDefaultFile;
    }

    public final void save() throws IOException {
        this.save((File)null);
    }

    public void save(File saveFile) throws IOException {
        if (saveFile == null) {
            if (this.defaultFile == null) {
                throw new IllegalStateException("Saving with null file name!");
            }
            saveFile = this.defaultFile;
        } else {
            this.defaultFile = saveFile;
        }
        this.save(new FileOutputStream(saveFile));
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(saveFile), "UTF-8"));
            writer.write("(;");
            this.writeRootBoilerplate(writer);
            this.writeNode(writer, this.tree.root);
            writer.write("\n");
            ((Writer)writer).close();
        }
        catch (SecurityException excep) {
            throw new IOException(Defs.getString(720104019));
        }
        this.setModified(false);
    }

    public void save(OutputStream out) throws IOException {
        FileIo.stripRedundantAddStoneProps(this.tree);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        writer.write("(;");
        this.writeRootBoilerplate(writer);
        this.writeNode(writer, this.tree.root);
        writer.write("\n");
        ((Writer)writer).close();
    }

    protected void writeRootBoilerplate(Writer writer) throws IOException {
        writer.write("GM[1]FF[4]CA[UTF-8]AP[");
        writer.write(this.getApplication());
        writer.write("]ST[");
        writer.write(Integer.toString(this.getStyle()));
        writer.write("]");
    }

    private void writeNode(Writer writer, Node node) throws IOException {
        block4: while (true) {
            this.startPropSeries();
            for (Prop aNode : node) {
                this.writeProp(writer, aNode);
            }
            switch (node.countChildren()) {
                case 0: {
                    writer.write(")");
                    return;
                }
                case 1: {
                    writer.write("\n;");
                    node = node.getChild(0);
                    continue block4;
                }
            }
            break;
        }
        for (Node props : node.children()) {
            writer.write("\n(;");
            this.writeNode(writer, props);
        }
        writer.write(")");
    }

    protected void writeProp(Writer writer, Prop param) throws IOException {
        switch (param.type) {
            case 29: {
                int breakPoint = param.getText().indexOf(32);
                this.writeProp(writer, param.getText().substring(0, breakPoint), param.getText().substring(breakPoint + 1));
                break;
            }
            case 0: {
                Rules newRules = param.getRules();
                writer.write(10);
                this.writeProp(writer, "RU", ruleTypeNames[newRules.getType()]);
                this.writeProp(writer, "SZ", Integer.toString(newRules.getSize()));
                if (newRules.getHandicap() != 0) {
                    this.writeProp(writer, "HA", Integer.toString(newRules.getHandicap()));
                }
                this.writeProp(writer, "KM", this.scoreFormatter.format(newRules.getKomi()));
                if (newRules.getTimeSystem() != 0) {
                    this.writeProp(writer, "TM", Integer.toString(newRules.getMainTime()));
                }
                if (newRules.getTimeSystem() == 2) {
                    this.writeProp(writer, "OT", Integer.toString(newRules.getByoYomiPeriods()) + 'x' + newRules.getByoYomiTime() + " byo-yomi");
                } else if (newRules.getTimeSystem() == 3) {
                    this.writeProp(writer, "OT", Integer.toString(newRules.getByoYomiStones()) + '/' + newRules.getByoYomiTime() + " Canadian");
                }
                writer.write(10);
                break;
            }
            case 18: {
                char colorChar = "BW".charAt(param.getColor());
                this.writeProp(writer, colorChar + "L", this.timeFormatter.format(param.getFloat()));
                if (param.getInt() == 0) break;
                this.writeProp(writer, "O" + colorChar, Integer.toString(param.getInt()));
                break;
            }
            default: {
                String code = this.getPropCode(param);
                if (code == null) break;
                this.writeProp(writer, this.getPropCode(param), this.formatArg(param));
            }
        }
    }

    protected String formatArg(Prop param) {
        switch (param.type) {
            case 19: {
                return FileIo.formatLoc(param.getLoc()) + ':' + param.getText();
            }
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                return FileIo.formatLoc(param.getLoc());
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: 
            case 28: {
                return param.getText();
            }
            case 3: {
                return FileIo.formatRank(param.getInt());
            }
            case 27: {
                return Integer.toString(param.getInt());
            }
            case 25: {
                return FileIo.formatResult(this.scoreFormatter, param.getInt(), param.getFloat());
            }
            case 26: {
                if (param.getColor() == 0) {
                    return "B";
                }
                return "W";
            }
        }
        throw new IllegalArgumentException("Don't know how to format arg for param " + param);
    }

    public static String formatResult(NumberFormat formatter, int iVal, float fVal) {
        String prefix = fVal > 0.0f ? "W+" : "B+";
        switch (iVal) {
            case 0: {
                return fVal == 0.0f ? "0" : prefix + formatter.format(Math.abs(fVal));
            }
            case 1: {
                return prefix + "Resign";
            }
            case 2: {
                return prefix + "Time";
            }
            case 3: {
                return prefix + "Forfeit";
            }
            case 4: {
                return "Void";
            }
            case 5: {
                return "?";
            }
        }
        throw new IllegalArgumentException("Result int val " + iVal);
    }

    protected final void writeProp(Writer writer, String code, String arg) throws IOException {
        if (code.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!code.equals(this.prevCode)) {
            writer.write(code);
        }
        writer.write(FileIo.braceify(arg));
        this.prevCode = code;
    }

    private static String braceify(String arg) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == '\\' || c == ']') {
                buf.append('\\');
            }
            buf.append(c);
        }
        buf.append(']');
        return buf.toString();
    }

    protected static void installProp(int paramType, String codes) {
        int subtype = 0;
        String code = null;
        StringTokenizer codeTokens = new StringTokenizer(codes);
        while (codeTokens.hasMoreElements()) {
            code = codeTokens.nextToken();
            if (code.indexOf(63) != -1 || paramCodeToInfo.put(code, new PropInfo(paramType, subtype++)) == null) continue;
            throw new IllegalArgumentException("SGF code " + code + " maps to multiple parameters!");
        }
        if (paramType >= 0) {
            while (paramTypeToCode.size() < paramType + 1) {
                paramTypeToCode.add(null);
            }
            if (paramTypeToCode.get(paramType) != null) {
                throw new IllegalArgumentException("Prop type " + paramType + " has multiple codes.");
            }
            paramTypeToCode.set(paramType, code);
        }
    }

    protected Loc parseLoc(String arg, int lineNum) throws SgfException {
        if ((arg = arg.trim()).isEmpty()) {
            return Loc.PASS;
        }
        if (arg.length() == 2) {
            Loc result = Loc.get(this.charToCoordinate(arg.charAt(0)), this.charToCoordinate(arg.charAt(1)));
            this.sizeForcedTo19 |= this.ambiguousPasses;
            if (this.ambiguousPasses && result.x == this.rules.getSize() && result.y == this.rules.getSize() || result.x == 19 && result.y == 19 && this.rules.getSize() <= 19) {
                return Loc.PASS;
            }
            if (result.x >= 0 && result.y >= 0 && (!this.ambiguousPasses && !this.rulePropsFound[0] || result.x < this.rules.getSize() && result.y < this.rules.getSize())) {
                return result;
            }
        }
        throw new SgfException(10, Defs.getString(720104009, new Object[]{FileIo.clipText(arg), lineNum}));
    }

    protected Iterator<Loc> parseLocs(String arg, int lineNum) throws SgfException {
        Loc corner1;
        Loc corner2;
        int colonIndex = arg.indexOf(58);
        if (colonIndex == -1) {
            corner1 = corner2 = this.parseLoc(arg, lineNum);
        } else {
            corner1 = this.parseLoc(arg.substring(0, colonIndex), lineNum);
            corner2 = this.parseLoc(arg.substring(colonIndex + 1), lineNum);
        }
        if (corner1 == Loc.PASS || corner2 == Loc.PASS) {
            throw new SgfException(10, Defs.getString(720104009, new Object[]{FileIo.clipText(arg), lineNum}));
        }
        final int x1 = corner1.x < corner2.x ? corner1.x : corner2.x;
        final int x2 = corner1.x < corner2.x ? corner2.x : corner1.x;
        final int y1 = corner1.y < corner2.y ? corner1.y : corner2.y;
        final int y2 = corner1.y < corner2.y ? corner2.y : corner1.y;
        return new Iterator<Loc>(){
            private int x;
            private int y;
            {
                this.x = x1 - 1;
                this.y = y1;
            }

            @Override
            public boolean hasNext() {
                return this.x < x2 || this.y < y2;
            }

            @Override
            public Loc next() {
                if (++this.x > x2) {
                    this.x = x1;
                    ++this.y;
                }
                return Loc.get(this.x, this.y);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int charToCoordinate(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 26;
        }
        return -1;
    }

    private int parseRank(String arg, int lineNumber) throws SgfException {
        if ((arg = arg.trim()).length() >= 2) {
            int rankTypeIndex;
            int digitsLen;
            for (digitsLen = 0; digitsLen < arg.length() && arg.charAt(digitsLen) >= '0' && arg.charAt(digitsLen) <= '9'; ++digitsLen) {
            }
            for (rankTypeIndex = digitsLen; rankTypeIndex < arg.length() && arg.charAt(rankTypeIndex) == ' '; ++rankTypeIndex) {
            }
            if (digitsLen > 0 && rankTypeIndex < arg.length()) {
                char rankType = Character.toLowerCase(arg.charAt(rankTypeIndex));
                try {
                    int val = Integer.parseInt(arg.substring(0, digitsLen));
                    if (rankType == 'k' && val <= 30 && val > 0) {
                        return 30 - val + 1;
                    }
                    if (rankType == 'd' && val <= 9 && val > 0) {
                        return 30 + val;
                    }
                    if ((rankType == 'p' || rankType == 'd') && val > 0) {
                        return 39 + val;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (arg.length() == 1 && arg.equals("?")) {
            return 0;
        }
        throw new SgfException(11, Defs.getString(720104023, new Object[]{FileIo.clipText(arg), lineNumber}));
    }

    private static String formatRank(int rank) {
        if (rank == 0) {
            return "?";
        }
        if (rank <= 30) {
            return Integer.toString(30 - rank + 1) + "k";
        }
        if (rank <= 39) {
            return Integer.toString(rank - 30) + "d";
        }
        return Integer.toString(rank - 39) + "p";
    }

    public static Prop parseResult(String arg, int lineNumber) throws SgfException {
        arg = arg.trim().toUpperCase();
        float resultSign = -1.0f;
        if (!arg.isEmpty()) {
            switch (arg.charAt(0)) {
                case '0': 
                case 'D': 
                case 'J': {
                    return new Prop(25, 0, 0.0f);
                }
                case 'N': 
                case 'V': {
                    return new Prop(25, 4, 0.0f);
                }
                case '?': {
                    return new Prop(25, 5, 0.0f);
                }
                case 'W': {
                    resultSign = 1.0f;
                }
                case 'B': {
                    if (arg.length() < 3 || arg.charAt(1) != '+') break;
                    switch (arg.charAt(2)) {
                        case 'R': {
                            return new Prop(25, 1, resultSign);
                        }
                        case 'T': {
                            return new Prop(25, 2, resultSign);
                        }
                        case 'F': {
                            return new Prop(25, 3, resultSign);
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            return new Prop(25, 0, resultSign * FileIo.parseFloat(arg.substring(2), lineNumber));
                        }
                    }
                    break;
                }
            }
        }
        throw new SgfException(11, Defs.getString(720104024, new Object[]{FileIo.clipText(arg), lineNumber}));
    }

    protected static String clipText(String arg) {
        if (arg.length() > 20) {
            return Defs.getString(720103995, arg.substring(0, 20));
        }
        return arg;
    }

    private void parseTimeProp(Collection<Prop> props, int color, boolean isTimeLeft, String arg, int lineNumber) throws SgfException {
        try {
            float timeLeft = 0.0f;
            int stonesLeft = 0;
            Prop oldProp = null;
            Iterator<Prop> iter = props.iterator();
            while (iter.hasNext()) {
                Prop prop = iter.next();
                if (prop.type != 18 || prop.getColor() != color) continue;
                iter.remove();
                oldProp = prop;
                break;
            }
            if (oldProp != null) {
                timeLeft = oldProp.getFloat();
                stonesLeft = oldProp.getInt();
            }
            if (isTimeLeft) {
                timeLeft = this.timeFormatter.parse(arg.trim()).floatValue();
            } else {
                stonesLeft = Integer.parseInt(arg);
            }
            props.add(new Prop(18, color, stonesLeft, timeLeft));
        }
        catch (Exception e) {
            throw new SgfException(11, Defs.getString(720104013, new Object[]{FileIo.clipText(arg), lineNumber}));
        }
    }

    protected int parseInt(String arg, int lineNum) throws SgfException {
        try {
            return Integer.parseInt(arg.trim());
        }
        catch (NumberFormatException e) {
            throw new SgfException(12, Defs.getString(720103997, new Object[]{FileIo.clipText(arg), lineNum}));
        }
    }

    protected static float parseFloat(String arg, int lineNum) throws SgfException {
        try {
            return Float.parseFloat(arg.trim());
        }
        catch (NumberFormatException e) {
            throw new SgfException(13, Defs.getString(720103998, new Object[]{FileIo.clipText(arg), lineNum}));
        }
    }

    private Prop parseLabel(String arg, int lineNum) throws SgfException {
        int wsLen;
        int argLen = arg.length();
        for (wsLen = 0; wsLen < argLen && Character.isWhitespace(arg.charAt(wsLen)); ++wsLen) {
        }
        if (wsLen > 0) {
            arg = arg.substring(wsLen);
            argLen = arg.length();
        }
        if (argLen >= 4 && arg.charAt(2) == ':') {
            return new Prop(19, this.parseLoc(arg.substring(0, 2), lineNum), arg.substring(3, argLen > 6 ? 6 : argLen));
        }
        throw new SgfException(14, Defs.getString(720104015, new Object[]{FileIo.clipText(arg), lineNum}));
    }

    private void resetActiveNode(Node current) {
        int numChildren;
        while ((numChildren = current.countChildren()) == 1) {
            current = current.getActiveChild();
        }
        if (numChildren == 0) {
            this.tree.setActiveNode(current);
        } else {
            while (--numChildren >= 0) {
                this.resetActiveNode(current.getChild(numChildren));
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public final File getFile() {
        return this.defaultFile;
    }

    protected void convertStyle(int fileStyleIn) {
        if (fileStyleIn == 0 || fileStyleIn == 1) {
            Node.NodeIterator nodes = this.tree.nodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (node.countChildren() <= 1) continue;
                for (int i = 0; i < node.countChildren() && i < 26; ++i) {
                    Prop move = node.getChild(i).findProp(14);
                    if (move == null || move.getLoc() == Loc.PASS) continue;
                    Prop label = new Prop(19, move.getLoc(), "" + (char)(65 + i));
                    if (fileStyleIn == 0) {
                        if (node.hasConflicts(label)) continue;
                        node.add(label);
                        continue;
                    }
                    for (int j = 0; j < node.countChildren(); ++j) {
                        if (node.getChild(j).hasConflicts(label)) continue;
                        node.getChild(j).add(label);
                    }
                }
            }
        }
    }

    public String getLoadWarnings() {
        return this.warnBuf.length() == 0 ? null : this.warnBuf.toString();
    }

    protected void startPropSeries() {
        this.prevCode = null;
    }

    private static NumberFormat makeTimeFormatter() {
        NumberFormat result = NumberFormat.getInstance(Locale.US);
        result.setMaximumFractionDigits(3);
        result.setGroupingUsed(false);
        return result;
    }

    public static NumberFormat makeScoreFormatter() {
        NumberFormat result = NumberFormat.getInstance(Locale.US);
        result.setMinimumFractionDigits(2);
        result.setMaximumFractionDigits(2);
        result.setGroupingUsed(false);
        return result;
    }

    public void setModified(boolean newVal) {
        if (newVal != this.modified) {
            this.modified = newVal;
            if (this.modified) {
                this.tree.removeListener(this.treeListener);
            } else {
                this.tree.addListener(this.treeListener);
            }
        }
    }

    protected final String getPropCode(Prop param) {
        String baseName;
        try {
            baseName = paramTypeToCode.get(param.type);
        }
        catch (IndexOutOfBoundsException excep) {
            return null;
        }
        if (param.hasColor() && baseName != null) {
            baseName = baseName.replace('?', "BWE".charAt(param.getColor()));
        }
        return baseName;
    }

    private static void stripRedundantAddStoneProps(Tree peer) {
        Node oldActiveNode = peer.getActiveNode();
        Node.NodeIterator nodes = peer.nodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            if (node.findProp(17) == null) continue;
            FileIo.stripRedundantAddStoneProps(peer, node);
        }
        peer.setActiveNode(oldActiveNode);
    }

    private static void stripRedundantAddStoneProps(Tree peer, Node node) {
        if (node.parent != null) {
            Goban goban = GameUpdater.buildBoard(peer, node.parent);
            Iterator<Prop> params = node.iterator();
            while (params.hasNext()) {
                Prop param = params.next();
                if (param.type != 17 || param.getColor() != goban.getColor(param.getLoc())) continue;
                params.remove();
            }
        } else {
            Iterator<Prop> params = node.iterator();
            while (params.hasNext()) {
                Prop param = params.next();
                if (param.type != 17 || param.getColor() != 2) continue;
                params.remove();
            }
        }
    }

    protected String getApplication() {
        return "CGoban:3";
    }

    protected int getStyle() {
        return 2;
    }

    protected void handleApplication(String app) {
    }

    protected void handleFileFormat(int format) throws SgfException {
        if (format < 1 || format > 4) {
            throw new SgfException(16, Defs.getString(720104006, format));
        }
        this.ambiguousPasses = format != 4;
    }

    private int argToRuleSet(String arg) {
        for (int i = 0; i < ruleTypeNames.length; ++i) {
            if (!arg.equals(ruleTypeNames[i])) continue;
            return i;
        }
        return -1;
    }

    protected static String formatLoc(Loc loc) {
        if (loc.equals(Loc.PASS)) {
            return "";
        }
        StringBuilder result = new StringBuilder(2);
        return result.append((char)(loc.x < 26 ? 97 + loc.x : 65 + (loc.x - 26))).append((char)(loc.y < 26 ? 97 + loc.y : 65 + (loc.y - 26))).toString();
    }

    private void parseRules(int subtype, String arg, int lineNumber) throws SgfException {
        arg = arg.trim();
        if (this.rulePropsFound[subtype]) {
            throw new SgfException(17, Defs.getString(720104018, lineNumber));
        }
        this.rulePropsFound[subtype] = true;
        switch (subtype) {
            case 0: {
                int newSize = this.parseInt(arg, lineNumber);
                if (newSize > 38 || newSize < 2) {
                    throw new SgfException(18, Defs.getString(720104001, new Object[]{FileIo.clipText(arg), lineNumber}));
                }
                if (newSize != 19 && this.sizeForcedTo19) {
                    throw new IllegalStateException(Defs.getString(720104020));
                }
                this.rules.setSize(newSize);
                break;
            }
            case 1: {
                int ruleSet = this.argToRuleSet(arg.trim());
                if (ruleSet == -1) break;
                this.rules.setType(ruleSet);
                break;
            }
            case 2: {
                if (arg.isEmpty()) {
                    this.rules.setTimeSystem(0);
                    break;
                }
                try {
                    int mainTime = Integer.parseInt(arg);
                    if (this.rules.getTimeSystem() == 0) {
                        this.rules.setTimeSystem(1);
                    }
                    if (mainTime == 0) {
                        this.rules.setTimeSystem(3);
                    }
                    this.rules.setMainTime(mainTime);
                }
                catch (NumberFormatException mainTime) {}
                break;
            }
            case 5: {
                int timeType = 0;
                String parser = null;
                if (arg.indexOf(120) != -1) {
                    parser = "x ";
                    timeType = 2;
                } else if (arg.indexOf(47) != -1) {
                    parser = "/ ";
                    timeType = 3;
                }
                if (timeType == 0) break;
                try {
                    StringTokenizer tokens = new StringTokenizer(arg, parser);
                    int byPeriods = Integer.parseInt(tokens.nextToken());
                    int byTime = Integer.parseInt(tokens.nextToken());
                    this.rules.setTimeSystem(timeType);
                    this.rules.setByoYomiTime(byTime);
                    if (timeType == 3) {
                        this.rules.setByoYomiStones(byPeriods);
                        break;
                    }
                    this.rules.setByoYomiPeriods(byPeriods);
                }
                catch (IllegalArgumentException tokens) {}
                break;
            }
            case 3: {
                int newHandicap = this.parseInt(arg, lineNumber);
                if (this.rules.getHandicap() < 0) {
                    throw new SgfException(19, Defs.getString(720104010, new Object[]{FileIo.clipText(arg), lineNumber}));
                }
                if (newHandicap == 1) break;
                this.rules.setHandicap(newHandicap);
                break;
            }
            case 4: {
                this.rulePropsFound[4] = true;
                this.rules.setKomi(FileIo.parseFloat(arg, lineNumber));
            }
        }
    }

    static {
        int paramType = -5;
        StringTokenizer stdProps = new StringTokenizer("CA|ST|AP|GM|FF|SZ RU TM HA KM OT|GN|PB PW P?|BR WR ?R|DT|CP|GC|EV|RO|PC|BT WT ?T|SO|AN|US|B W ?|CR|-|AB AW AE A?|BL WL OB OW|L LB|M TR|SQ|TB TW T?|-|C|RE|PL|MN|N|x|MA|", "|");
        while (stdProps.hasMoreElements()) {
            String names = stdProps.nextToken();
            if (!names.equals("-")) {
                FileIo.installProp(paramType, names);
            }
            ++paramType;
        }
    }

    protected static class SgfReader {
        private Reader reader;
        private int lineNumber = 1;
        private boolean pushed = false;
        private int prevChar;
        private String encoding;

        public SgfReader(File fileIn) throws IOException, SgfException {
            this.reader = this.buildReader(new FileInputStream(fileIn));
        }

        public SgfReader(InputStream in) throws IOException, SgfException {
            this.reader = this.buildReader(in);
        }

        public SgfReader(Reader newReader) throws IOException, SgfException {
            this.reader = newReader;
        }

        private Reader buildReader(InputStream in) throws IOException, SgfException {
            in = new BufferedInputStream(in);
            StringBuilder encodingBuf = new StringBuilder("ISO-8859-1");
            int mode = 0;
            int lineNum = 1;
            block13: do {
                int c;
                if ((c = in.read()) == 10) {
                    ++lineNum;
                } else if (c == -1) {
                    throw new SgfException(mode == 0 || mode == 40 ? 0 : 3, Defs.getString(mode == 0 || mode == 40 ? 720104012 : 720104021, lineNum));
                }
                switch (mode) {
                    case 0: {
                        if (c != 40) break;
                        mode = 40;
                        break;
                    }
                    case 40: {
                        if (c == 59) {
                            mode = 59;
                            in.mark(Integer.MAX_VALUE);
                            break;
                        }
                        if (c == 40 || Character.isWhitespace((char)c)) continue block13;
                        mode = 0;
                        break;
                    }
                    case 91: {
                        if (c == 92) {
                            mode = 92;
                            break;
                        }
                        if (c != 93) break;
                        mode = 59;
                        break;
                    }
                    case 92: {
                        mode = 91;
                        break;
                    }
                    case 59: {
                        if (c == 67) {
                            mode = 67;
                            break;
                        }
                        if (c == 91) {
                            mode = 91;
                            break;
                        }
                        if (c == 41 || c == 59 || c == 40) {
                            mode = 41;
                            break;
                        }
                        if (c >= 97 && c <= 122 || Character.isWhitespace((char)c)) continue block13;
                        mode = 88;
                        break;
                    }
                    case 88: {
                        if (c == 91) {
                            mode = 91;
                            break;
                        }
                        if (c != 41 && c != 59 && c != 40) continue block13;
                        mode = 41;
                        break;
                    }
                    case 67: {
                        if (c == 65) {
                            mode = 65;
                            break;
                        }
                        if (c == 91) {
                            mode = 91;
                            break;
                        }
                        if (c >= 97 && c <= 122) continue block13;
                        mode = 88;
                        break;
                    }
                    case 65: {
                        if (c == 91) {
                            mode = 33;
                            encodingBuf.setLength(0);
                            break;
                        }
                        if (Character.isWhitespace((char)c) || c >= 97 && c <= 122) continue block13;
                        mode = 88;
                        break;
                    }
                    case 33: {
                        if (c == 93) {
                            mode = 41;
                            break;
                        }
                        if (c == 92) break;
                        encodingBuf.append((char)c);
                    }
                }
            } while (mode != 41);
            in.reset();
            in.mark(0);
            this.encoding = encodingBuf.toString().trim();
            try {
                return new InputStreamReader(in, this.encoding);
            }
            catch (UnsupportedEncodingException excep) {
                throw new SgfException(15, Defs.getString(720103999, new Object[]{this.encoding, lineNum}));
            }
        }

        public String getEncoding() {
            return this.encoding;
        }

        public int read() throws IOException {
            if (this.pushed) {
                this.pushed = false;
                return this.prevChar;
            }
            int result = this.reader.read();
            if (result == 13 || result == 10 && this.prevChar != 13) {
                ++this.lineNumber;
            }
            this.prevChar = (char)result;
            return result;
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public void unread() {
            if (this.pushed) {
                throw new IllegalStateException("Attempt to push back more than one character.");
            }
            this.pushed = true;
        }
    }

    private static class PropInfo {
        public final int type;
        public final int subtype;

        public PropInfo(int paramType, int paramSubtype) {
            this.type = paramType;
            this.subtype = paramSubtype;
        }

        public String toString() {
            return "PropInfo[type=" + this.type + ", subtype=" + this.subtype + "]";
        }
    }
}

