require 'test/unit'
require 'blowfish_ecb'
require 'pp'

# Test cases taken from OpenSSL's Blowfish implementation
# https://github.com/openssl/openssl/blob/master/test/bftest.c
class KeyTest < Test::Unit::TestCase
  def test_initialize
    key = Blowfish::ECB::Key.new("foobar")
    assert_not_nil(key)
  end

  def test_set_key
    key = [0xf0, 0xe1, 0xd2, 0xc3, 0xb4, 0xa5, 0x96, 0x87,
        0x78, 0x69, 0x5a, 0x4b, 0x3c, 0x2d, 0x1e, 0x0f,
        0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
        0x88
    ]
    data = [0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10].pack("C*")
    expected = [
      [0xF9, 0xAD, 0x59, 0x7C, 0x49, 0xDB, 0x00, 0x5E],
      [0xE9, 0x1D, 0x21, 0xC1, 0xD9, 0x61, 0xA6, 0xD6],
      [0xE9, 0xC2, 0xB7, 0x0A, 0x1B, 0xC6, 0x5C, 0xF3],
      [0xBE, 0x1E, 0x63, 0x94, 0x08, 0x64, 0x0F, 0x05],
      [0xB3, 0x9E, 0x44, 0x48, 0x1B, 0xDB, 0x1E, 0x6E],
      [0x94, 0x57, 0xAA, 0x83, 0xB1, 0x92, 0x8C, 0x0D],
      [0x8B, 0xB7, 0x70, 0x32, 0xF9, 0x60, 0x62, 0x9D],
      [0xE8, 0x7A, 0x24, 0x4E, 0x2C, 0xC8, 0x5E, 0x82],
      [0x15, 0x75, 0x0E, 0x7A, 0x4F, 0x4E, 0xC5, 0x77],
      [0x12, 0x2B, 0xA7, 0x0B, 0x3A, 0xB6, 0x4A, 0xE0],
      [0x3A, 0x83, 0x3C, 0x9A, 0xFF, 0xC5, 0x37, 0xF6],
      [0x94, 0x09, 0xDA, 0x87, 0xA9, 0x0F, 0x6B, 0xF2],
      [0x88, 0x4F, 0x80, 0x62, 0x50, 0x60, 0xB8, 0xB4],
      [0x1F, 0x85, 0x03, 0x1C, 0x19, 0xE1, 0x19, 0x68],
      [0x79, 0xD9, 0x37, 0x3A, 0x71, 0x4C, 0xA3, 0x4F],
      [0x93, 0x14, 0x28, 0x87, 0xEE, 0x3B, 0xE1, 0x5C],
      [0x03, 0x42, 0x9E, 0x83, 0x8C, 0xE2, 0xD1, 0x4B],
      [0xA4, 0x29, 0x9E, 0x27, 0x46, 0x9F, 0xF6, 0x7B],
      [0xAF, 0xD5, 0xAE, 0xD1, 0xC1, 0xBC, 0x96, 0xA8],
      [0x10, 0x85, 0x1C, 0x0E, 0x38, 0x58, 0xDA, 0x9F],
      [0xE6, 0xF5, 0x1E, 0xD7, 0x9B, 0x9D, 0xB2, 0x1F],
      [0x64, 0xA6, 0xE1, 0x4A, 0xFD, 0x36, 0xB4, 0x6F],
      [0x80, 0xC7, 0xD7, 0xD4, 0x5A, 0x54, 0x79, 0xAD],
      [0x05, 0x04, 0x4B, 0x62, 0xFA, 0x52, 0xD0, 0x80],
    ]

    (0...24).each do |i|
      bf_key = Blowfish::ECB::Key.new(key[0,i+1].pack("C*"))
      enc = Blowfish::ECB.encrypt(data, bf_key)
      assert_equal(expected[i].pack("C*"), enc, "Failed at case #{i}")
      dec = Blowfish::ECB.decrypt(enc, bf_key)
      assert_equal(data, dec, "Failed at case #{i}")
    end
  end

  def test_raw
    cases = [
        {key: "abcdefghijklmnopqrstuvwxyz", data: [0x424c4f57, 0x46495348], expected: [0x324ed0fe, 0xf413a203]},
        {key: "Who is John Galt?", data: [0xfedcba98, 0x76543210], expected: [0xcc91732b, 0x8022f684]}
    ]

    cases.each do |c|
      bf_key = Blowfish::ECB::Key.new(c[:key])
      l, r = Blowfish::ECB::Common.encrypt(c[:data][0], c[:data][1], bf_key)
      assert_equal(c[:expected], [l, r])
    end
  end
end