require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SI2VMX_H_)) {
    eval 'sub _SI2VMX_H_ () {1;}' unless defined(&_SI2VMX_H_);
    unless(defined(&__SPU__)) {
	require 'stdlib.ph';
	require 'vec_types.ph';
	unless(defined(&SPU_HALT_ACTION)) {
	    eval 'sub SPU_HALT_ACTION () { &abort();}' unless defined(&SPU_HALT_ACTION);
	}
	unless(defined(&SPU_STOP_ACTION)) {
	    eval 'sub SPU_STOP_ACTION () { &abort();}' unless defined(&SPU_STOP_ACTION);
	}
	unless(defined(&SPU_UNSUPPORTED_ACTION)) {
	    eval 'sub SPU_UNSUPPORTED_ACTION () { &abort();}' unless defined(&SPU_UNSUPPORTED_ACTION);
	}
	eval 'sub si_from_char {
	    my($c) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $c[16]; }  &x;  ($x->{c[3]}) = $c; ( ($x->{q})); });
	}' unless defined(&si_from_char);
	eval 'sub si_from_ushort {
	    my($s) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $s[8]; }  &x;  ($x->{s[1]}) = $s; ( ($x->{q})); });
	}' unless defined(&si_from_ushort);
	eval 'sub si_from_short {
	    my($s) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $s[8]; }  &x;  ($x->{s[1]}) = $s; ( ($x->{q})); });
	}' unless defined(&si_from_short);
	eval 'sub si_from_uint {
	    my($i) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $i[4]; }  &x;  ($x->{i[0]}) = $i; ( ($x->{q})); });
	}' unless defined(&si_from_uint);
	eval 'sub si_from_int {
	    my($i) = @_;
    	    eval q({ \'union union\' {  &qword  &q; \'int\' $i->[4]; }  &x;  ($x->{i[0]}) = $i; ( ($x->{q})); });
	}' unless defined(&si_from_int);
	eval 'sub si_from_ullong {
	    my($l) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $l[2]; }  &x;  ($x->{l[0]}) = $l; ( ($x->{q})); });
	}' unless defined(&si_from_ullong);
	eval 'sub si_from_llong {
	    my($l) = @_;
    	    eval q({ \'union union\' {  &qword  &q; my $l[2]; }  &x;  ($x->{l[0]}) = $l; ( ($x->{q})); });
	}' unless defined(&si_from_llong);
	eval 'sub si_from_float {
	    my($f) = @_;
    	    eval q({ \'union union\' {  &qword  &q; \'float\' $f->[4]; }  &x;  ($x->{f[0]}) = $f; ( ($x->{q})); });
	}' unless defined(&si_from_float);
	eval 'sub si_from_double {
	    my($d) = @_;
    	    eval q({ \'union union\' {  &qword  &q; \'double\' $d->[2]; }  &x;  ($x->{d[0]}) = $d; ( ($x->{q})); });
	}' unless defined(&si_from_double);
	eval 'sub si_from_ptr {
	    my($ptr) = @_;
    	    eval q({ \'union union\' {  &qword  &q;  &void * &p; }  &x;  ($x->{p}) = $ptr; ( ($x->{q})); });
	}' unless defined(&si_from_ptr);
	eval 'sub si_to_char {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $c[16]; }  &x;  ($x->{q}) = $q; ( ($x->{c[3]})); });
	}' unless defined(&si_to_char);
	eval 'sub si_to_ushort {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $s[8]; }  &x;  ($x->{q}) = $q; ( ($x->{s[1]})); });
	}' unless defined(&si_to_ushort);
	eval 'sub si_to_short {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $s[8]; }  &x;  ($x->{q}) = $q; ( ($x->{s[1]})); });
	}' unless defined(&si_to_short);
	eval 'sub si_to_uint {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $i[4]; }  &x;  ($x->{q}) = $q; ( ($x->{i[0]})); });
	}' unless defined(&si_to_uint);
	eval 'sub si_to_int {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; \'int\'  $i[4]; }  &x;  ($x->{q}) = $q; ( ($x->{i[0]})); });
	}' unless defined(&si_to_int);
	eval 'sub si_to_ullong {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $l[2]; }  &x;  ($x->{q}) = $q; ( ($x->{l[0]})); });
	}' unless defined(&si_to_ullong);
	eval 'sub si_to_llong {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; my $l[2]; }  &x;  ($x->{q}) = $q; ( ($x->{l[0]})); });
	}' unless defined(&si_to_llong);
	eval 'sub si_to_float {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; \'float\'  $f[4]; }  &x;  ($x->{q}) = $q; ( ($x->{f[0]})); });
	}' unless defined(&si_to_float);
	eval 'sub si_to_double {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q; \'double\'  $d[2]; }  &x;  ($x->{q}) = $q; ( ($x->{d[0]})); });
	}' unless defined(&si_to_double);
	eval 'sub si_to_ptr {
	    my($q) = @_;
    	    eval q({ \'union union\' {  &qword $q;  &void * &p; }  &x;  ($x->{q}) = $q; ( ($x->{p})); });
	}' unless defined(&si_to_ptr);
	eval 'sub si_a {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_add(( &vec_uint4)($_a), ( &vec_uint4)($_b)))));
	}' unless defined(&si_a);
	eval 'sub si_ah {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_add(( &vec_ushort8)($_a), ( &vec_ushort8)($_b)))));
	}' unless defined(&si_ah);
	eval 'sub si_ai {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_add(( &vec_int4)($a),  &vec_splat(( &vec_int4)( &si_from_int($b)), 0)))); });
	}' unless defined(&si_ai);
	eval 'sub si_ahi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_add(( &vec_short8)($a),  &vec_splat(( &vec_short8)( &si_from_short($b)), 1)))); });
	}' unless defined(&si_ahi);
	eval 'sub si_fa {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_add(( &vec_float4)($_a), ( &vec_float4)($_b)))));
	}' unless defined(&si_fa);
	eval 'sub si_dfa {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &ad,  &bd,  &dd;  ($ad->{v}) = ( &vec_double2)($a);  ($bd->{v}) = ( &vec_double2)($b);  ($dd->{d[0]}) =  ($ad->{d[0]}) +  ($bd->{d[0]});  ($dd->{d[1]}) =  ($ad->{d[1]}) +  ($bd->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfa);
	eval 'sub si_addx {
	    my($_a, $_b, $_c) = @_;
    	    eval q((( &qword)( &vec_add( &vec_add(( &vec_uint4)($_a), ( &vec_uint4)($_b)),  &vec_and(( &vec_uint4)($_c),  &vec_splat_u32(1))))));
	}' unless defined(&si_addx);
	eval 'sub si_and {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_and(( &vec_uint4)($_a), ( &vec_uint4)($_b)))));
	}' unless defined(&si_and);
	eval 'sub si_andbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_and(( &vec_char16)($a),  &vec_splat(( &vec_char16)( &si_from_char($b)), 3)))); });
	}' unless defined(&si_andbi);
	eval 'sub si_andhi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_and(( &vec_short8)($a),  &vec_splat(( &vec_short8)( &si_from_short($b)), 1)))); });
	}' unless defined(&si_andhi);
	eval 'sub si_andi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_and(( &vec_int4)($a),  &vec_splat(( &vec_int4)( &si_from_int($b)), 0)))); });
	}' unless defined(&si_andi);
	eval 'sub si_andc {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_andc(( &vec_uchar16)($_a), ( &vec_uchar16)($_b)))));
	}' unless defined(&si_andc);
	eval 'sub si_avgb {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_avg(( &vec_uchar16)($_a), ( &vec_uchar16)($_b)))));
	}' unless defined(&si_avgb);
	eval 'sub si_bisled {
	    my($_func) = @_;
    	    eval q();
	}' unless defined(&si_bisled);
	eval 'sub si_bisledd {
	    my($_func) = @_;
    	    eval q();
	}' unless defined(&si_bisledd);
	eval 'sub si_bislede {
	    my($_func) = @_;
    	    eval q();
	}' unless defined(&si_bislede);
	eval 'sub si_bg {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_subc(( &vec_uint4)($_b), ( &vec_uint4)($_a)))));
	}' unless defined(&si_bg);
	eval 'sub si_bgx {
	    my($_a, $_b, $_c) = @_;
    	    eval q((( &qword)( &vec_and( &vec_or( &vec_cmpgt(( &vec_uint4)($_b), ( &vec_uint4)($_a)),  &vec_and( &vec_cmpeq(( &vec_uint4)($_b), ( &vec_uint4)($_a)), ( &vec_uint4)($_c))),  &vec_splat_u32(1)))));
	}' unless defined(&si_bgx);
	eval 'sub si_dfcmeq {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &sign_mask= ( &vec_uint4) { 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff };  &vec_uint4  &nan_mask = ( &vec_uint4) { 0x7ff00000, 0x, 0x7ff00000, 0x };  &vec_uchar16  &hihi_promote = ( &vec_uchar16) { 0,1,2,3, 16,17,18,19, 8,9,10,11, 24,25,26,27};  &vec_uint4  &biteq;  &vec_uint4  &aabs;  &vec_uint4  &babs;  &vec_uint4  &a_gt;  &vec_uint4  &ahi_inf;  &vec_uint4  &anan;  &vec_uint4  &result; \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x;  ($x->{i[3]}) = 4<< 3;  &aabs =  &vec_and(( &vec_uint4)$a, &sign_mask);  &babs =  &vec_and(( &vec_uint4)$b, &sign_mask);  &biteq = ( &vec_uint4)  &vec_cmpeq(( &vec_uint4) &aabs,( &vec_uint4) &babs);  &biteq =  &vec_and( &biteq,( &vec_uint4) &vec_slo(( &vec_uchar16) &biteq, ($x->{v})));  &a_gt = ( &vec_uint4) &vec_cmpgt( &aabs, &nan_mask);  &ahi_inf = ( &vec_uint4) &vec_cmpeq( &aabs, &nan_mask);  &anan = ( &vec_uint4) &vec_or( &a_gt, &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_gt, ($x->{v})), &ahi_inf));  &result =  &vec_andc( &biteq,  &anan); (( &qword)( &vec_perm(( &vec_uchar16) &result, ( &vec_uchar16) &result,  &hihi_promote))); });
	}' unless defined(&si_dfcmeq);
	eval 'sub si_dfcmgt {
	    my($a,$b) = @_;
    	    eval q({  &vec_uchar16  &splat_hi = ( &vec_uchar16) { 0,1,2,3, 0,1,2,3, 8,9,10,11, 8,9,10,11};  &vec_uint4  &nan_mask = ( &vec_uint4) { 0x7ff00000, 0x, 0x7ff00000, 0x };  &vec_uint4  &sign_mask = ( &vec_uint4) { 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff }; \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x;  ($x->{i[3]}) = 4<< 3;  &vec_uint4  &aabs =  &vec_and(( &vec_uint4)$a,  &sign_mask);  &vec_uint4  &babs =  &vec_and(( &vec_uint4)$b,  &sign_mask);  &vec_uint4  &a_inf = ( &vec_uint4) &vec_cmpeq( &aabs,  &nan_mask);  &vec_uint4  &a_nan = ( &vec_uint4) &vec_cmpgt( &aabs,  &nan_mask);  &a_nan =  &vec_or( &a_nan,  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_nan, ($x->{v})), &a_inf));  &a_nan = ( &vec_uint4) &vec_perm(( &vec_uchar16) &a_nan, ( &vec_uchar16) &a_nan,  &splat_hi);  &vec_uint4  &b_inf = ( &vec_uint4) &vec_cmpeq( &babs,  &nan_mask);  &vec_uint4  &b_nan = ( &vec_uint4) &vec_cmpgt( &babs,  &nan_mask);  &b_nan =  &vec_or( &b_nan,  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &b_nan, ($x->{v})), &b_inf));  &b_nan = ( &vec_uint4) &vec_perm(( &vec_uchar16) &b_nan, ( &vec_uchar16) &b_nan,  &splat_hi);  &vec_uint4  &gt_hi = ( &vec_uint4) &vec_cmpgt( &aabs, &babs);  &vec_uint4  &gt_lo = ( &vec_uint4) &vec_cmpgt(( &vec_uint4) &aabs, ( &vec_uint4) &babs);  &vec_uint4  &eq = ( &vec_uint4) &vec_cmpeq( &aabs,  &babs);  &vec_uint4  &eqgt =  &vec_and( &eq, &vec_slo( &gt_lo, ($x->{v})));  &vec_uint4  &r =  &vec_or( &gt_hi,  &eqgt);  &r = ( &vec_uint4) &vec_perm(( &vec_uchar16) &r,( &vec_uchar16) &r, &splat_hi); (( &qword) &vec_andc( &r, &vec_or( &a_nan, &b_nan))); });
	}' unless defined(&si_dfcmgt);
	eval 'sub si_ceqh {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_ushort8)($a), ( &vec_ushort8)($b)))); });
	}' unless defined(&si_ceqh);
	eval 'sub si_ceq {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_uint4)($a), ( &vec_uint4)($b)))); });
	}' unless defined(&si_ceq);
	eval 'sub si_fceq {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_float4)($a), ( &vec_float4)($b)))); });
	}' unless defined(&si_fceq);
	eval 'sub si_ceqbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_char16)($a),  &vec_splat(( &vec_char16)( &si_from_char($b)), 3)))); });
	}' unless defined(&si_ceqbi);
	eval 'sub si_ceqhi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_short8)($a),  &vec_splat(( &vec_short8)( &si_from_short($b)), 1)))); });
	}' unless defined(&si_ceqhi);
	eval 'sub si_ceqi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpeq(( &vec_int4)($a),  &vec_splat(( &vec_int4)( &si_from_int($b)), 0)))); });
	}' unless defined(&si_ceqi);
	eval 'sub si_dfceq {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &sign_mask= ( &vec_uint4) { 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff };  &vec_uint4  &nan_mask = ( &vec_uint4) { 0x7ff00000, 0x, 0x7ff00000, 0x };  &vec_uchar16  &hihi_promote = ( &vec_uchar16) { 0,1,2,3, 16,17,18,19, 8,9,10,11, 24,25,26,27};  &vec_uint4  &biteq;  &vec_uint4  &aabs;  &vec_uint4  &babs;  &vec_uint4  &a_gt;  &vec_uint4  &ahi_inf;  &vec_uint4  &anan;  &vec_uint4  &iszero;  &vec_uint4  &result; \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x;  ($x->{i[3]}) = 4<< 3;  &biteq = ( &vec_uint4)  &vec_cmpeq(( &vec_uint4)$a,( &vec_uint4)$b);  &biteq =  &vec_and( &biteq,( &vec_uint4) &vec_slo(( &vec_uchar16) &biteq, ($x->{v})));  &aabs =  &vec_and(( &vec_uint4)$a, &sign_mask);  &babs =  &vec_and(( &vec_uint4)$b, &sign_mask);  &a_gt = ( &vec_uint4) &vec_cmpgt( &aabs, &nan_mask);  &ahi_inf = ( &vec_uint4) &vec_cmpeq( &aabs, &nan_mask);  &anan = ( &vec_uint4) &vec_or( &a_gt, &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_gt, ($x->{v})), &ahi_inf));  &iszero =( &vec_uint4) &vec_cmpeq(( &vec_uint4) &vec_or( &aabs, &babs),( &vec_uint4) &vec_splat_u32(0));  &iszero =  &vec_and( &iszero,( &vec_uint4) &vec_slo(( &vec_uchar16) &iszero, ($x->{v})));  &result =  &vec_or( &biteq, &iszero);  &result =  &vec_andc( &result,  &anan); (( &qword)( &vec_perm(( &vec_uchar16) &result, ( &vec_uchar16) &result,  &hihi_promote))); });
	}' unless defined(&si_dfceq);
	eval 'sub si_cgth {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_short8)($a), ( &vec_short8)($b)))); });
	}' unless defined(&si_cgth);
	eval 'sub si_cgt {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_int4)($a), ( &vec_int4)($b)))); });
	}' unless defined(&si_cgt);
	eval 'sub si_clgtb {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_uchar16)($a), ( &vec_uchar16)($b)))); });
	}' unless defined(&si_clgtb);
	eval 'sub si_clgth {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_ushort8)($a), ( &vec_ushort8)($b)))); });
	}' unless defined(&si_clgth);
	eval 'sub si_clgt {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_uint4)($a), ( &vec_uint4)($b)))); });
	}' unless defined(&si_clgt);
	eval 'sub si_fcgt {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_float4)($a), ( &vec_float4)($b)))); });
	}' unless defined(&si_fcgt);
	eval 'sub si_dfcgt {
	    my($a,$b) = @_;
    	    eval q({  &vec_uchar16  &splat_hi = ( &vec_uchar16) { 0,1,2,3, 0,1,2,3, 8,9,10,11, 8,9,10,11};  &vec_uchar16  &borrow_shuffle = ( &vec_uchar16) { 4,5,6,7, 192,192,192,192, 12,13,14,15, 192,192,192,192};  &vec_uint4  &nan_mask = ( &vec_uint4) { 0x7ff00000, 0x, 0x7ff00000, 0x };  &vec_uint4  &sign_mask = ( &vec_uint4) { 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff }; \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x;  ($x->{i[3]}) = 4<< 3;  &vec_uint4  &aabs =  &vec_and(( &vec_uint4)$a,  &sign_mask);  &vec_uint4  &babs =  &vec_and(( &vec_uint4)$b,  &sign_mask);  &vec_uint4  &a_inf = ( &vec_uint4) &vec_cmpeq( &aabs,  &nan_mask);  &vec_uint4  &a_nan = ( &vec_uint4) &vec_cmpgt( &aabs,  &nan_mask);  &a_nan =  &vec_or( &a_nan,  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_nan, ($x->{v})), &a_inf));  &a_nan = ( &vec_uint4) &vec_perm(( &vec_uchar16) &a_nan, ( &vec_uchar16) &a_nan,  &splat_hi);  &vec_uint4  &b_inf = ( &vec_uint4) &vec_cmpeq( &babs,  &nan_mask);  &vec_uint4  &b_nan = ( &vec_uint4) &vec_cmpgt( &babs,  &nan_mask);  &b_nan =  &vec_or( &b_nan,  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &b_nan, ($x->{v})), &b_inf));  &b_nan = ( &vec_uint4) &vec_perm(( &vec_uchar16) &b_nan, ( &vec_uchar16) &b_nan,  &splat_hi);  &vec_uint4  &asel = ( &vec_uint4) &vec_sra(( &vec_int4)($a), ( &vec_uint4) &vec_splat((( &vec_uint4) &si_from_int(31)), 0));  &asel = ( &vec_uint4) &vec_perm(( &vec_uchar16) &asel,( &vec_uchar16) &asel, &splat_hi);  &vec_uint4  &bsel = ( &vec_uint4) &vec_sra(( &vec_int4)($b), ( &vec_uint4) &vec_splat((( &vec_uint4) &si_from_int(31)), 0));  &bsel = ( &vec_uint4) &vec_perm(( &vec_uchar16) &bsel,( &vec_uchar16) &bsel, &splat_hi);  &vec_uint4  &abor =  &vec_subc(( &vec_uint4) &vec_splat_u32(0),  &aabs);  &vec_uchar16  &pat =  &vec_sel((( &vec_uchar16){0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15}),  &vec_sr( &borrow_shuffle,  &vec_splat_u8(3)),  &vec_sra( &borrow_shuffle,  &vec_splat_u8(7)));  &abor = ( &vec_uint4)( &vec_perm( &vec_perm(( &vec_uchar16) &abor, ( &vec_uchar16) &abor,  &borrow_shuffle),(( &vec_uchar16){0, 0, 0, 0, 0, 0, 0, 0, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80}), &pat));  &vec_uint4  &aneg =  &vec_add( &vec_add( &vec_splat_u32(0),  &vec_nor( &aabs,  &aabs)),  &vec_and( &abor,  &vec_splat_u32(1)));  &vec_int4  &aval = ( &vec_int4) &vec_sel(( &vec_uchar16) &aabs, ( &vec_uchar16) &aneg, ( &vec_uchar16) &asel);  &vec_uint4  &bbor =  &vec_subc(( &vec_uint4) &vec_splat_u32(0),  &babs);  &bbor = ( &vec_uint4)( &vec_perm( &vec_perm(( &vec_uchar16) &bbor, ( &vec_uchar16) &bbor,  &borrow_shuffle),(( &vec_uchar16){0, 0, 0, 0, 0, 0, 0, 0, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80}), &pat));  &vec_uint4  &bneg =  &vec_add( &vec_nor( &babs,  &babs),  &vec_and( &bbor,  &vec_splat_u32(1)));  &vec_int4  &bval=( &vec_int4) &vec_sel(( &vec_uchar16) &babs, ( &vec_uchar16) &bneg, ( &vec_uchar16) &bsel);  &vec_uint4  &gt_hi = ( &vec_uint4) &vec_cmpgt( &aval, &bval);  &vec_uint4  &gt_lo = ( &vec_uint4) &vec_cmpgt(( &vec_uint4) &aval, ( &vec_uint4) &bval);  &vec_uint4  &eq = ( &vec_uint4) &vec_cmpeq( &aval,  &bval);  &vec_uint4  &eqgt =  &vec_and( &eq, &vec_slo( &gt_lo, ($x->{v})));  &vec_uint4  &r =  &vec_or( &gt_hi,  &eqgt);  &r = ( &vec_uint4) &vec_perm(( &vec_uchar16) &r,( &vec_uchar16) &r, &splat_hi); (( &qword) &vec_andc( &r, &vec_or( &a_nan, &b_nan))); });
	}' unless defined(&si_dfcgt);
	eval 'sub si_cgtbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_char16)($a),  &vec_splat(( &vec_char16)( &si_from_char($b)), 3)))); });
	}' unless defined(&si_cgtbi);
	eval 'sub si_cgthi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_short8)($a),  &vec_splat(( &vec_short8)( &si_from_short($b)), 1)))); });
	}' unless defined(&si_cgthi);
	eval 'sub si_cgti {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_int4)($a),  &vec_splat(( &vec_int4)( &si_from_int($b)), 0)))); });
	}' unless defined(&si_cgti);
	eval 'sub si_clgtbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_uchar16)($a),  &vec_splat(( &vec_uchar16)( &si_from_uchar($b)), 3)))); });
	}' unless defined(&si_clgtbi);
	eval 'sub si_clgthi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_ushort8)($a),  &vec_splat(( &vec_ushort8)( &si_from_ushort($b)), 1)))); });
	}' unless defined(&si_clgthi);
	eval 'sub si_clgti {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_cmpgt(( &vec_uint4)($a),  &vec_splat(( &vec_uint4)( &si_from_uint($b)), 0)))); });
	}' unless defined(&si_clgti);
	eval 'sub si_dftsv {
	    my($a,$b) = @_;
    	    eval q({  &vec_uchar16  &splat_hi = ( &vec_uchar16) { 0,1,2,3, 0,1,2,3, 8,9,10,11, 8,9,10,11};  &vec_uint4  &sign_mask = ( &vec_uint4) { 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff };  &vec_uint4  &result = ( &vec_uint4){0};  &vec_uint4  &sign = ( &vec_uint4) &vec_sra(( &vec_int4)($a), ( &vec_uint4) &vec_splat((( &vec_uint4) &si_from_int(31)), 0));  &sign = ( &vec_uint4) &vec_perm(( &vec_uchar16) &sign,( &vec_uchar16) &sign, &splat_hi);  &vec_uint4  &aabs =  &vec_and(( &vec_uint4)$a, &sign_mask); \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x;  ($x->{i[3]}) = 4<< 3;  &if ($b & 0x70) {  &vec_uint4  &nan_mask = ( &vec_uint4) { 0x7ff00000, 0x, 0x7ff00000, 0x };  &vec_uint4  &a_inf = ( &vec_uint4) &vec_cmpeq( &aabs,  &nan_mask);  &if ($b & 0x40) {  &vec_uint4  &a_nan = ( &vec_uint4) &vec_cmpgt( &aabs,  &nan_mask);  &a_nan =  &vec_or( &a_nan,  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_nan, ($x->{v})), &a_inf));  &a_nan = ( &vec_uint4) &vec_perm(( &vec_uchar16) &a_nan, ( &vec_uchar16) &a_nan,  &splat_hi);  &result =  &vec_or( &result,  &a_nan); }  &if ($b & 0x30) {  &a_inf =  &vec_and(( &vec_uint4) &vec_slo(( &vec_uchar16) &a_inf, ($x->{v})),  &a_inf);  &a_inf = ( &vec_uint4) &vec_perm(( &vec_uchar16) &a_inf, ( &vec_uchar16) &a_inf,  &splat_hi);  &if ($b & 0x20)  &result =  &vec_or( &vec_andc( &a_inf,  &sign),  &result);  &if ($b & 0x10)  &result =  &vec_or( &vec_and( &a_inf,  &sign),  &result); } }  &if ($b & 0xf) {  &vec_uint4  &iszero =( &vec_uint4) &vec_cmpeq( &aabs,( &vec_uint4) &vec_splat_u32(0));  &iszero =  &vec_and( &iszero,( &vec_uint4) &vec_slo(( &vec_uchar16) &iszero, ($x->{v})));  &if ($b & 0x3) {  &vec_uint4  &denorm_mask = ( &vec_uint4){0xfffff, 0xfffff, 0xfffff, 0xfffff};  &vec_uint4  &isdenorm =  &vec_nor(( &vec_uint4) &vec_cmpgt( &aabs,  &denorm_mask),  &iszero);  &isdenorm = ( &vec_uint4) &vec_perm(( &vec_uchar16) &isdenorm, ( &vec_uchar16) &isdenorm,  &splat_hi);  &if ($b & 0x2)  &result =  &vec_or( &vec_andc( &isdenorm,  &sign),  &result);  &if ($b & 0x1)  &result =  &vec_or( &vec_and( &isdenorm,  &sign),  &result); }  &if ($b & 0xc) {  &iszero = ( &vec_uint4) &vec_perm(( &vec_uchar16) &iszero, ( &vec_uchar16) &iszero,  &splat_hi);  &if ($b & 0x8)  &result =  &vec_or( &vec_andc( &iszero,  &sign),  &result);  &if ($b & 0x4)  &result =  &vec_or( &vec_and( &iszero,  &sign),  &result); } } (( &qword) &result); });
	}' unless defined(&si_dftsv);
	eval 'sub si_cg {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_addc(( &vec_uint4)($_a), ( &vec_uint4)($_b)))));
	}' unless defined(&si_cg);
	eval 'sub si_cgx {
	    my($_a, $_b, $_c) = @_;
    	    eval q((( &qword)( &vec_or( &vec_addc(( &vec_uint4)($_a), ( &vec_uint4)($_b)),  &vec_addc( &vec_add(( &vec_uint4)($_a), ( &vec_uint4)($_b)),  &vec_and(( &vec_uint4)($_c),  &vec_splat_u32(1)))))));
	}' unless defined(&si_cgx);
	eval 'sub si_cuflt {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_ctf(( &vec_uint4)($_a), $_b))));
	}' unless defined(&si_cuflt);
	eval 'sub si_csflt {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_ctf(( &vec_int4)($_a), $_b))));
	}' unless defined(&si_csflt);
	eval 'sub si_cflts {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_cts(( &vec_float4)($_a), $_b))));
	}' unless defined(&si_cflts);
	eval 'sub si_cfltu {
	    my($_a, $_b) = @_;
    	    eval q((( &qword)( &vec_ctu(( &vec_float4)($_a), $_b))));
	}' unless defined(&si_cfltu);
	eval 'sub si_dsync () {
	    eval q();
	}' unless defined(&si_dsync);
	eval 'sub si_sync () {
	    eval q();
	}' unless defined(&si_sync);
	eval 'sub si_syncc () {
	    eval q();
	}' unless defined(&si_syncc);
	eval 'sub si_xshw {
	    my($a) = @_;
    	    eval q({  &vec_short8  &av;  &av = ( &vec_short8)($a); (( &qword)( &vec_unpackh( &vec_perm( &av,  &av, (( &vec_uchar16){2, 3, 6, 7, 10,11,14,15, 0, 0, 0, 0, 0, 0, 0, 0}))))); });
	}' unless defined(&si_xshw);
	eval 'sub si_xswd {
	    my($a) = @_;
    	    eval q({  &vec_int4  &av;  &av = ( &vec_int4)($a); (( &qword)( &vec_perm( &av,  &vec_sra( &av, (( &vec_uint4){31,31,31,31})), (( &vec_uchar16){20, 21, 22, 23, 4, 5, 6, 7, 28, 29, 30, 31, 12, 13, 14, 15})))); });
	}' unless defined(&si_xswd);
	eval 'sub si_fesd {
	    my($a) = @_;
    	    eval q({ \'union union\' { \'double\'  $d[2];  &vec_double2  &vd; }  &out; \'union union\' { \'float\'  $f[4];  &vec_float4  &vf; }  &in;  ($in->{vf}) = ( &vec_float4);  ($out->{d[0]}) = ( ($in->{f[0]}));  ($out->{d[1]}) = ( ($in->{f[2]})); (( &qword)( ($out->{vd}))); });
	}' unless defined(&si_fesd);
	eval 'sub si_gbh {
	    my($a) = @_;
    	    eval q({  &vec_ushort8  &bits;  &vec_uint4  &bytes;  &bits =  &vec_sl( &vec_and(( &vec_ushort8)($a),  &vec_splat_u16(1)), (( &vec_ushort8){7, 6, 5, 4, 3, 2, 1, 0}));  &bytes = ( &vec_uint4) &vec_sums(( &vec_int4)( &vec_sum4s(( &vec_short8)( &bits), ( &vec_int4){0})), ( &vec_int4){0}); (( &qword)( &vec_sld( &bytes,  &bytes, 12))); });
	}' unless defined(&si_gbh);
	eval 'sub si_gb {
	    my($a) = @_;
    	    eval q({  &vec_uint4  &bits;  &vec_uint4  &bytes;  &bits =  &vec_sl( &vec_and(( &vec_uint4)($a),  &vec_splat_u32(1)), (( &vec_uint4){3, 2, 1, 0}));  &bytes = ( &vec_uint4) &vec_sums(( &vec_int4)( &bits), (( &vec_int4){0})); (( &qword)( &vec_sld( &bytes,  &bytes, 12))); });
	}' unless defined(&si_gb);
	eval 'sub si_heqi {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vector my $v; my $i[4]; }  &aa;  ($a$a->{v}) = ( &vector my $int)($a);  &if ( ($a$a->{i[0]}) == $b) {  &SPU_HALT_ACTION; }; });
	}' unless defined(&si_heqi);
	eval 'sub si_hgt {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vector my $v; my $i[4]; }  &aa,  &bb;  ($a$a->{v}) = ( &vector my $int)($a);  ($b$b->{v}) = ( &vector my $int)($b);  &if ( ($a$a->{i[0]}) >  ($b$b->{i[0]})) {  &SPU_HALT_ACTION; }; });
	}' unless defined(&si_hgt);
	eval 'sub si_hgti {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vector my $v; my $i[4]; }  &aa;  ($a$a->{v}) = ( &vector my $int)($a);  &if ( ($a$a->{i[0]}) > $b) {  &SPU_HALT_ACTION; }; });
	}' unless defined(&si_hgti);
	eval 'sub si_hlgt {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vector my $v; my $i[4]; }  &aa,  &bb;  ($a$a->{v}) = ( &vector my $int)($a);  ($b$b->{v}) = ( &vector my $int)($b);  &if ( ($a$a->{i[0]}) >  ($b$b->{i[0]})) {  &SPU_HALT_ACTION; }; });
	}' unless defined(&si_hlgt);
	eval 'sub si_hlgti {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vector my $v; my $i[4]; }  &aa;  ($a$a->{v}) = ( &vector my $int)($a);  &if ( ($a$a->{i[0]}) > $b) {  &SPU_HALT_ACTION; }; });
	}' unless defined(&si_hlgti);
	eval 'sub si_fma {
	    my($a,$b,$c) = @_;
    	    eval q({ (( &qword)( &vec_madd(( &vec_float4)($a), ( &vec_float4)($b), ( &vec_float4)($c)))); });
	}' unless defined(&si_fma);
	eval 'sub si_dfma {
	    my($a,$b,$c) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &aa,  &bb,  &cc,  &dd;  ($a$a->{v}) = ( &vec_double2)($a);  ($b$b->{v}) = ( &vec_double2)($b);  ($c$c->{v}) = ( &vec_double2)($c);  ($dd->{d[0]}) =  ($a$a->{d[0]}) *  ($b$b->{d[0]}) +  ($c$c->{d[0]});  ($dd->{d[1]}) =  ($a$a->{d[1]}) *  ($b$b->{d[1]}) +  ($c$c->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfma);
	eval 'sub si_fsmbi {
	    my($_a) = @_;
    	    eval q( &si_fsmb( &si_from_int($_a)));
	}' unless defined(&si_fsmbi);
	eval 'sub si_fsmb {
	    my($a) = @_;
    	    eval q({  &vec_char16  &mask;  &vec_ushort8  &in;  &in = ( &vec_ushort8)($a);  &mask = ( &vec_char16)( &vec_perm( &in,  &in, (( &vec_uchar16){2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3}))); (( &qword)( &vec_sra( &vec_sl( &mask, (( &vec_uchar16){0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7})),  &vec_splat_u8(7)))); });
	}' unless defined(&si_fsmb);
	eval 'sub si_fsmh {
	    my($a) = @_;
    	    eval q({  &vec_uchar16  &in;  &vec_short8  &mask;  &in = ( &vec_uchar16)($a);  &mask = ( &vec_short8)( &vec_splat( &in, 3)); (( &qword)( &vec_sra( &vec_sl( &mask, (( &vec_ushort8){0, 1, 2, 3, 4, 5, 6, 7})),  &vec_splat_u16(15)))); });
	}' unless defined(&si_fsmh);
	eval 'sub si_fsm {
	    my($a) = @_;
    	    eval q({  &vec_uchar16  &in;  &vec_int4  &mask;  &in = ( &vec_uchar16)($a);  &mask = ( &vec_int4)( &vec_splat( &in, 3)); (( &qword)( &vec_sra( &vec_sl( &mask, (( &vec_uint4){28, 29, 30, 31})), (( &vec_uint4){31,31,31,31})))); });
	}' unless defined(&si_fsm);
	eval 'sub si_fscrrd () {
	    eval q((( &qword)(( &vec_uint4){0})));
	}' unless defined(&si_fscrrd);
	eval 'sub si_fscrwr {
	    my($_a) = @_;
    	    eval q();
	}' unless defined(&si_fscrwr);
	eval 'sub si_mfspr {
	    my($_reg) = @_;
    	    eval q((( &qword)(( &vec_uint4){0})));
	}' unless defined(&si_mfspr);
	eval 'sub si_mtspr {
	    my($_reg, $_a) = @_;
    	    eval q();
	}' unless defined(&si_mtspr);
	eval 'sub si_mpyhhau {
	    my($a,$b,$c) = @_;
    	    eval q({ (( &qword)( &vec_add( &vec_mule(( &vec_ushort8)($a), ( &vec_ushort8)($b)), ( &vec_uint4)($c)))); });
	}' unless defined(&si_mpyhhau);
	eval 'sub si_dfms {
	    my($a,$b,$c) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &aa,  &bb,  &cc,  &dd;  ($a$a->{v}) = ( &vec_double2)($a);  ($b$b->{v}) = ( &vec_double2)($b);  ($c$c->{v}) = ( &vec_double2)($c);  ($dd->{d[0]}) =  ($a$a->{d[0]}) *  ($b$b->{d[0]}) -  ($c$c->{d[0]});  ($dd->{d[1]}) =  ($a$a->{d[1]}) *  ($b$b->{d[1]}) -  ($c$c->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfms);
	eval 'sub si_dfm {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &aa,  &bb,  &dd;  ($a$a->{v}) = ( &vec_double2)($a);  ($b$b->{v}) = ( &vec_double2)($b);  ($dd->{d[0]}) =  ($a$a->{d[0]}) *  ($b$b->{d[0]});  ($dd->{d[1]}) =  ($a$a->{d[1]}) *  ($b$b->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfm);
	eval 'sub si_mpyhhu {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_mule(( &vec_ushort8)($a), ( &vec_ushort8)($b)))); });
	}' unless defined(&si_mpyhhu);
	eval 'sub si_mpyu {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_mulo(( &vec_ushort8)($a), ( &vec_ushort8)($b)))); });
	}' unless defined(&si_mpyu);
	eval 'sub si_mpyi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_mulo(( &vec_short8)($a),  &vec_splat(( &vec_short8)( &si_from_short($b)), 1)))); });
	}' unless defined(&si_mpyi);
	eval 'sub si_mpyui {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_mulo(( &vec_ushort8)($a),  &vec_splat(( &vec_ushort8)( &si_from_ushort($b)), 1)))); });
	}' unless defined(&si_mpyui);
	eval 'sub si_dfnms {
	    my($a,$b,$c) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &aa,  &bb,  &cc,  &dd;  ($a$a->{v}) = ( &vec_double2)($a);  ($b$b->{v}) = ( &vec_double2)($b);  ($c$c->{v}) = ( &vec_double2)($c);  ($dd->{d[0]}) =  ($c$c->{d[0]}) -  ($a$a->{d[0]}) *  ($b$b->{d[0]});  ($dd->{d[1]}) =  ($c$c->{d[1]}) -  ($a$a->{d[1]}) *  ($b$b->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfnms);
	eval 'sub si_orbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_or(( &vec_uchar16)($a),  &vec_splat(( &vec_uchar16)( &si_from_uchar($b)), 3)))); });
	}' unless defined(&si_orbi);
	eval 'sub si_orhi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_or(( &vec_ushort8)($a),  &vec_splat(( &vec_ushort8)( &si_from_ushort($b)), 1)))); });
	}' unless defined(&si_orhi);
	eval 'sub si_ori {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_or(( &vec_uint4)($a),  &vec_splat(( &vec_uint4)( &si_from_uint($b)), 0)))); });
	}' unless defined(&si_ori);
	eval 'sub si_frsqest {
	    my($a) = @_;
    	    eval q({ (( &qword)( &vec_rsqrte(( &vec_float4)($a)))); });
	}' unless defined(&si_frsqest);
	eval 'sub si_fi {
	    my($_a, $_d) = @_;
    	    eval q(($_d));
	}' unless defined(&si_fi);
	eval 'sub si_rdch {
	    my($_channel) = @_;
    	    eval q((( &qword)( &vec_splat_u8(0))));
	}' unless defined(&si_rdch);
	eval 'sub si_rchcnt {
	    my($_channel) = @_;
    	    eval q((( &qword)( &vec_splat_u8(0))));
	}' unless defined(&si_rchcnt);
	eval 'sub si_wrch {
	    my($_channel, $_a) = @_;
    	    eval q();
	}' unless defined(&si_wrch);
	eval 'sub si_rot {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_rl(( &vec_uint4)($a), ( &vec_uint4)($b)))); });
	}' unless defined(&si_rot);
	eval 'sub si_rothi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_rl(( &vec_ushort8)($a),  &vec_splat(( &vec_ushort8)( &si_from_int($b)), 1)))); });
	}' unless defined(&si_rothi);
	eval 'sub si_roti {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_rl(( &vec_uint4)($a),  &vec_splat(( &vec_uint4)( &si_from_int($b)), 0)))); });
	}' unless defined(&si_roti);
	eval 'sub si_rotm {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &neg_b;  &vec_uint4  &mask;  &neg_b = ( &vec_uint4) &vec_sub( &vec_splat_s32(0), ( &vec_int4)($b));  &mask =  &vec_sra( &vec_sl( &neg_b, (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_andc( &vec_sr(( &vec_uint4)($a),  &neg_b),  &mask))); });
	}' unless defined(&si_rotm);
	eval 'sub si_rothmi {
	    my($a,$b) = @_;
    	    eval q({  &vec_ushort8  &neg_b;  &vec_ushort8  &mask;  &neg_b =  &vec_splat(( &vec_ushort8)( &si_from_int(-$b)), 1);  &mask =  &vec_sra( &vec_sl( &neg_b,  &vec_splat_u16(11)),  &vec_splat_u16(15)); (( &qword)( &vec_andc( &vec_sr(( &vec_ushort8)($a),  &neg_b),  &mask))); });
	}' unless defined(&si_rothmi);
	eval 'sub si_rotmi {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &neg_b;  &vec_uint4  &mask;  &neg_b =  &vec_splat(( &vec_uint4)( &si_from_int(-$b)), 0);  &mask =  &vec_sra( &vec_sl( &neg_b, (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_andc( &vec_sr(( &vec_uint4)($a),  &neg_b),  &mask))); });
	}' unless defined(&si_rotmi);
	eval 'sub si_rotma {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &neg_b;  &vec_uint4  &mask;  &neg_b = ( &vec_uint4) &vec_sub( &vec_splat_s32(0), ( &vec_int4)($b));  &mask =  &vec_sra( &vec_sl( &neg_b, (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_sra(( &vec_int4)($a), ( &vec_uint4) &vec_or( &neg_b,  &mask)))); });
	}' unless defined(&si_rotma);
	eval 'sub si_rotmahi {
	    my($a,$b) = @_;
    	    eval q({  &vec_ushort8  &neg_b;  &vec_ushort8  &mask;  &neg_b =  &vec_splat(( &vec_ushort8)( &si_from_int(-$b)), 1);  &mask =  &vec_sra( &vec_sl( &neg_b,  &vec_splat_u16(11)),  &vec_splat_u16(15)); (( &qword)( &vec_sra(( &vec_short8)($a), ( &vec_ushort8) &vec_or( &neg_b,  &mask)))); });
	}' unless defined(&si_rotmahi);
	eval 'sub si_rotmai {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &neg_b;  &vec_uint4  &mask;  &neg_b =  &vec_splat(( &vec_uint4)( &si_from_int(-$b)), 0);  &mask =  &vec_sra( &vec_sl( &neg_b, (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_sra(( &vec_int4)($a), ( &vec_uint4) &vec_or( &neg_b,  &mask)))); });
	}' unless defined(&si_rotmai);
	eval 'sub si_rotqmby {
	    my($a,$count) = @_;
    	    eval q({ \'union union\' {  &vec_uchar16  &v; \'int\'  $i[4]; }  &x; \'int\'  &cnt;  &vec_uchar16  &mask;  ($x->{v}) = ( &vec_uchar16)($count);  ($x->{i[0]}) =  &cnt = (0-  ($x->{i[0]})) << 3;  ($x->{v}) =  &vec_splat( ($x->{v}), 3);  &mask = ( &cnt & 0x80) ?  &vec_splat_u8(0) :  &vec_splat_u8(-1); (( &qword)( &vec_and( &vec_sro(( &vec_uchar16)($a),  ($x->{v})),  &mask))); });
	}' unless defined(&si_rotqmby);
	eval 'sub si_rotqby {
	    my($a,$count) = @_;
    	    eval q({  &vec_uchar16  &left,  &right;  &left =  &vec_sl( &vec_splat(( &vec_uchar16)($count), 3),  &vec_splat_u8(3));  &right =  &vec_sub( &vec_splat_u8(0),  &left); (( &qword)( &vec_or( &vec_slo(( &vec_uchar16)($a),  &left),  &vec_sro(( &vec_uchar16)($a),  &right)))); });
	}' unless defined(&si_rotqby);
	eval 'sub si_rotqbi {
	    my($a,$count) = @_;
    	    eval q({  &vec_uchar16  &x,  &y;  &vec_uchar16  &result;  &x =  &vec_and( &vec_splat(( &vec_uchar16)($count), 3),  &vec_splat_u8(7));  &y = ( &vec_uchar16)( &vec_sr(( &vec_uint4) &vec_sro(( &vec_uchar16)($a), (( &vec_uchar16)(( &vec_uint4){0,0,0,120}))), ( &vec_uint4) &vec_sub( &vec_splat_u8(8),  &x)));  &result =  &vec_or( &vec_sll(( &qword)($a),  &x),  &y); (( &qword)( &result)); });
	}' unless defined(&si_rotqbi);
	eval 'sub si_rotqmbi {
	    my($a,$count) = @_;
    	    eval q({ (( &qword)( &vec_srl(( &vec_uchar16)($a),  &vec_sub( &vec_splat_u8(0),  &vec_splat(( &vec_uchar16)($count), 3))))); });
	}' unless defined(&si_rotqmbi);
	eval 'sub si_shl {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &mask;  &mask = ( &vec_uint4) &vec_sra( &vec_sl(( &vec_uint4)($b), (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_andc( &vec_sl(( &vec_uint4)($a), ( &vec_uint4)($b)),  &mask))); });
	}' unless defined(&si_shl);
	eval 'sub si_shlhi {
	    my($a,$b) = @_;
    	    eval q({  &vec_ushort8  &mask;  &vec_ushort8  &bv;  &bv =  &vec_splat(( &vec_ushort8)( &si_from_int($b)), 1);  &mask = ( &vec_ushort8) &vec_sra( &vec_sl( &bv,  &vec_splat_u16(11)),  &vec_splat_u16(15)); (( &qword)( &vec_andc( &vec_sl(( &vec_ushort8)($a),  &bv),  &mask))); });
	}' unless defined(&si_shlhi);
	eval 'sub si_shli {
	    my($a,$b) = @_;
    	    eval q({  &vec_uint4  &bv;  &vec_uint4  &mask;  &bv =  &vec_splat(( &vec_uint4)( &si_from_uint($b)), 0);  &mask = ( &vec_uint4) &vec_sra( &vec_sl( &bv, (( &vec_uint4){26,26,26,26})), (( &vec_uint4){31,31,31,31})); (( &qword)( &vec_andc( &vec_sl(( &vec_uint4)($a),  &bv),  &mask))); });
	}' unless defined(&si_shli);
	eval 'sub si_shlqbi {
	    my($a,$count) = @_;
    	    eval q({  &vec_uchar16  &x;  &x =  &vec_splat(( &vec_uchar16)($count), 3); (( &qword)( &vec_sll(( &vec_uchar16)($a),  &x))); });
	}' unless defined(&si_shlqbi);
	eval 'sub si_shlqby {
	    my($a,$count) = @_;
    	    eval q({ \'union union\' {  &vec_uchar16  &v; my $i[4]; }  &x; my $cnt;  &vec_uchar16  &mask;  ($x->{v}) =  &vec_sl( &vec_splat(( &vec_uchar16)($count), 3),  &vec_splat_u8(3));  $cnt =  ($x->{i[0]});  &mask = ( $cnt & 0x80) ?  &vec_splat_u8(0) :  &vec_splat_u8(-1); (( &qword)( &vec_and( &vec_slo(( &vec_uchar16)($a),  ($x->{v})),  &mask))); });
	}' unless defined(&si_shlqby);
	eval 'sub si_stop {
	    my($_type) = @_;
    	    eval q( &SPU_STOP_ACTION);
	}' unless defined(&si_stop);
	eval 'sub si_stopd {
	    my($a, $b, $c) = @_;
    	    eval q( &SPU_STOP_ACTION);
	}' unless defined(&si_stopd);
	eval 'sub si_sf {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_sub(( &vec_uint4)($b), ( &vec_uint4)($a)))); });
	}' unless defined(&si_sf);
	eval 'sub si_fs {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_sub(( &vec_float4)($a), ( &vec_float4)($b)))); });
	}' unless defined(&si_fs);
	eval 'sub si_dfs {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &aa,  &bb,  &dd;  ($a$a->{v}) = ( &vec_double2)($a);  ($b$b->{v}) = ( &vec_double2)($b);  ($dd->{d[0]}) =  ($a$a->{d[0]}) -  ($b$b->{d[0]});  ($dd->{d[1]}) =  ($a$a->{d[1]}) -  ($b$b->{d[1]}); (( &qword)( ($dd->{v}))); });
	}' unless defined(&si_dfs);
	eval 'sub si_sfhi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_sub( &vec_splat(( &vec_short8)( &si_from_short($b)), 1), ( &vec_short8)($a)))); });
	}' unless defined(&si_sfhi);
	eval 'sub si_sfi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_sub( &vec_splat(( &vec_int4)( &si_from_int($b)), 0), ( &vec_int4)($a)))); });
	}' unless defined(&si_sfi);
	eval 'sub si_sfx {
	    my($_a, $_b, $_c) = @_;
    	    eval q((( &qword)( &vec_add( &vec_add(( &vec_uint4)($_b),  &vec_nor(( &vec_uint4)($_a), ( &vec_uint4)($_a))),  &vec_and(( &vec_uint4)($_c),  &vec_splat_u32(1))))));
	}' unless defined(&si_sfx);
	eval 'sub si_xorbi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_xor(( &vec_uchar16)($a),  &vec_splat(( &vec_uchar16)( &si_from_uchar($b)), 3)))); });
	}' unless defined(&si_xorbi);
	eval 'sub si_xorhi {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_xor(( &vec_ushort8)($a),  &vec_splat(( &vec_ushort8)( &si_from_ushort($b)), 1)))); });
	}' unless defined(&si_xorhi);
	eval 'sub si_xori {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_xor(( &vec_uint4)($a),  &vec_splat(( &vec_uint4)( &si_from_uint($b)), 0)))); });
	}' unless defined(&si_xori);
	eval 'sub si_cdd {
	    my($a,$imm) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $ll[2]; }  &shmask;  ($shmask->{v}) = ({0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{ll[((si_to_uint + (imm)) >> 3) & 0x1]}) = 283686952306183; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_cdd);
	eval 'sub si_chd {
	    my($a,$imm) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $s[8]; }  &shmask;  ($shmask->{v}) = ({0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{s[((si_to_uint + (imm)) >> 1) & 0x7]}) = 0x203; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_chd);
	eval 'sub si_cwd {
	    my($a,$imm) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &shmask;  ($shmask->{v}) = ({0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{i[((si_to_uint + (imm)) >> 2) & 0x3]}) = 0x10203; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_cwd);
	eval 'sub si_cbx {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $c[16]; }  &shmask;  ($shmask->{v}) = (( &vec_uint4){0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{c[si_to_uint((qword)(vec_add((vec_uint4)(a), (vec_uint4)(b)))) & 0xF]}) = 0x3; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_cbx);
	eval 'sub si_cdx {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $ll[2]; }  &shmask;  ($shmask->{v}) = (( &vec_uint4){0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{ll[(si_to_uint((qword)(vec_add((vec_uint4)(a), (vec_uint4)(b)))) >> 3) & 0x1]}) = 283686952306183; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_cdx);
	eval 'sub si_chx {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $s[8]; }  &shmask;  ($shmask->{v}) = (( &vec_uint4){0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{s[(si_to_uint((qword)(vec_add((vec_uint4)(a), (vec_uint4)(b)))) >> 1) & 0x7]}) = 0x203; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_chx);
	eval 'sub si_cwx {
	    my($a,$b) = @_;
    	    eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &shmask;  ($shmask->{v}) = (( &vec_uint4){0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f});  ($shmask->{i[(si_to_uint((qword)(vec_add((vec_uint4)(a), (vec_uint4)(b)))) >> 2) & 0x3]}) = 0x10203; (( &qword)( ($shmask->{v}))); });
	}' unless defined(&si_cwx);
	eval 'sub si_ila {
	    my($imm) = @_;
    	    eval q({ (( &qword)( &vec_splat(( &vec_uint4)( &si_from_uint($imm)), 0))); });
	}' unless defined(&si_ila);
	eval 'sub si_ilh {
	    my($imm) = @_;
    	    eval q({ (( &qword)( &vec_splat(( &vec_short8)( &si_from_short($imm)), 1))); });
	}' unless defined(&si_ilh);
	eval 'sub si_ilhu {
	    my($imm) = @_;
    	    eval q({ (( &qword)( &vec_splat(( &vec_uint4)( &si_from_uint(($imm) << 16)), 0))); });
	}' unless defined(&si_ilhu);
	eval 'sub si_iohl {
	    my($a,$imm) = @_;
    	    eval q({ (( &qword)( &vec_or(( &vec_uint4)($a),  &vec_splat(( &vec_uint4)( &si_from_uint(($imm))), 0)))); });
	}' unless defined(&si_iohl);
	eval 'sub si_lnop () {
	    eval q();
	}' unless defined(&si_lnop);
	eval 'sub si_nop () {
	    eval q();
	}' unless defined(&si_nop);
	eval 'sub si_lqd {
	    my($a,$imm) = @_;
    	    eval q({ (( &qword)( &vec_ld( &si_to_uint($a) & ~0xf, ( &vector my $char *)($imm)))); });
	}' unless defined(&si_lqd);
	eval 'sub si_lqr {
	    my($imm) = @_;
    	    eval q({ (( &qword)( &vec_ld(0, ( &vector my $char *)($imm)))); });
	}' unless defined(&si_lqr);
	eval 'sub si_lqx {
	    my($a,$b) = @_;
    	    eval q({ (( &qword)( &vec_ld( &si_to_uint(( &qword)( &vec_add(( &vec_uint4)($a), ( &vec_uint4)($b)))), ( &vector my $char *)(0)))); });
	}' unless defined(&si_lqx);
	eval 'sub si_stqa {
	    my($a,$imm) = @_;
    	    eval q({  &vec_st(( &vec_uchar16)($a), 0, ( &vector my $char *)($imm)); });
	}' unless defined(&si_stqa);
	eval 'sub si_stqd {
	    my($a,$b,$imm) = @_;
    	    eval q({  &vec_st(( &vec_uchar16)($a),  &si_to_uint($b) & ~0xf, ( &vector my $char *)($imm)); });
	}' unless defined(&si_stqd);
	eval 'sub si_stqr {
	    my($a,$imm) = @_;
    	    eval q({  &vec_st(( &vec_uchar16)($a), 0, ( &vector my $char *)($imm)); });
	}' unless defined(&si_stqr);
	eval 'sub si_stqx {
	    my($a,$b,$c) = @_;
    	    eval q({  &vec_st(( &vec_uchar16)($a),  &si_to_uint(( &qword)( &vec_add(( &vec_uint4)($b), ( &vec_uint4)($c)))), ( &vector my $char *)(0)); });
	}' unless defined(&si_stqx);
    }
}
1;
