//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef GARMINGPS_H
#define GARMINGPS_H

#include <iostream>
#include "protocol.h"
#include "waypointlist.h"
#include "routelist.h"
#include "tracklist.h"
#include "date_time_type.h"


/// all classes, global data etc are located in the namespace gpspoint2
namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// This Class down or uploads whole Datasets, like a Route, Track or Waypoint list.
class GarminGPS : Protocol, Constants
{
   public:

   protected:
        /// set device e.g. /dev/ttyS1
        void setDevice(string s){Protocol::setDevice(s);}
           
        /// open the device 
        int openPort(void){return Protocol::openPort();}

        /// close the device
        void closePort(void){Protocol::closePort();}

        /// set Bauds for device
        void setSpeed(string s) { Protocol::setSpeed(s); }

        void printTest(void){ Protocol::printTest();}

        void downloadDateTime(Date_Time_Type &dt);

        void downloadWaypoints(Waypointlist &wpl);
        void uploadWaypoints(Waypointlist &wpl);

        void downloadRoutes(Routelist &rtl);
        void uploadRoutes(Routelist &rtl);


        void downloadTracks(Tracklist &tkl);
        void uploadTracks(Tracklist &tkl);

        /// tun off the gps device 
        void turnOff(void);

        void abortTransfer(void);

   /// return information about connected device or 0 if connection to
   /// device failed
        const DeviceInfo *getInfo() { return Protocol::getInfo(); }

   private:
        void printFortschritt(int i, int n);

};

}
#endif 

