/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        int count = this.read(buf, 0, 1);
        return count > 0 ? buf[0] : -1;
    }

    public abstract void close() throws IOException;

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException("mark not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public boolean ready() throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long count) throws IOException {
        if (count <= 0L) {
            return 0L;
        }
        int bsize = count > 1024L ? 1024 : (int)count;
        char[] buffer = new char[bsize];
        long todo = count;
        Object object = this.lock;
        synchronized (object) {
            int skipped;
            while (todo > 0L && (skipped = this.read(buffer, 0, (long)bsize > todo ? (int)todo : bsize)) > 0) {
                todo -= (long)skipped;
            }
            return count - todo;
        }
    }

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        this.lock = lock;
    }
}

