module Colors
  module ColorData
    # The default value of matplotlib's rcParams['axes.prop_cycle'].by_key().get('color')
    DEFAULT_COLOR_CYCLE = [ -'#1f77b4', -'#ff7f0e', -'#2ca02c', -'#d62728', -'#9467bd',
                            -'#8c564b', -'#e377c2', -'#7f7f7f', -'#bcbd22', -'#17becf' ].freeze

    # Matplotlib's base colors
    BASE_COLORS = {
      "b" => [0r,    0r,    1r].freeze,
      "g" => [0r,    0.5r,  0r].freeze,
      "r" => [1r,    0r,    0r].freeze,
      "c" => [0r,    0.75r, 0.75r].freeze,
      "m" => [0.75r, 0,     0.75r].freeze,
      "y" => [0.75r, 0.75r, 0r].freeze,
      "k" => [0r,    0r,    0r].freeze,
      "w" => [1r,    1r,    1r].freeze
    }.freeze

    # Colors from Tableau
    TABLEAU_COLORS = {
      "tab:blue"   => -"#1f77b4",
      "tab:orange" => -"#ff7f0e",
      "tab:green"  => -"#2ca02c",
      "tab:red"    => -"#d62728",
      "tab:purple" => -"#9467bd",
      "tab:brown"  => -"#8c564b",
      "tab:pink"   => -"#e377c2",
      "tab:gray"   => -"#7f7f7f",
      "tab:olive"  => -"#bcbd22",
      "tab:cyan"   => -"#17becf"
    }.freeze

    # This mapping of color names -> hex values is taken from
    # a survey run by Randall Munroe see:
    # https://blog.xkcd.com/2010/05/03/color-survey-results/
    # for more details.  The results are hosted at
    # https://xkcd.com/color/rgb
    # and also available as a text file at
    # https://xkcd.com/color/rgb.txt
    #
    # License: http://creativecommons.org/publicdomain/zero/1.0/
    XKCD_COLORS = {
      "xkcd:cloudy blue" => -"#acc2d9",
      "xkcd:dark pastel green" => -"#56ae57",
      "xkcd:dust" => -"#b2996e",
      "xkcd:electric lime" => -"#a8ff04",
      "xkcd:fresh green" => -"#69d84f",
      "xkcd:light eggplant" => -"#894585",
      "xkcd:nasty green" => -"#70b23f",
      "xkcd:really light blue" => -"#d4ffff",
      "xkcd:tea" => -"#65ab7c",
      "xkcd:warm purple" => -"#952e8f",
      "xkcd:yellowish tan" => -"#fcfc81",
      "xkcd:cement" => -"#a5a391",
      "xkcd:dark grass green" => -"#388004",
      "xkcd:dusty teal" => -"#4c9085",
      "xkcd:grey teal" => -"#5e9b8a",
      "xkcd:macaroni and cheese" => -"#efb435",
      "xkcd:pinkish tan" => -"#d99b82",
      "xkcd:spruce" => -"#0a5f38",
      "xkcd:strong blue" => -"#0c06f7",
      "xkcd:toxic green" => -"#61de2a",
      "xkcd:windows blue" => -"#3778bf",
      "xkcd:blue blue" => -"#2242c7",
      "xkcd:blue with a hint of purple" => -"#533cc6",
      "xkcd:booger" => -"#9bb53c",
      "xkcd:bright sea green" => -"#05ffa6",
      "xkcd:dark green blue" => -"#1f6357",
      "xkcd:deep turquoise" => -"#017374",
      "xkcd:green teal" => -"#0cb577",
      "xkcd:strong pink" => -"#ff0789",
      "xkcd:bland" => -"#afa88b",
      "xkcd:deep aqua" => -"#08787f",
      "xkcd:lavender pink" => -"#dd85d7",
      "xkcd:light moss green" => -"#a6c875",
      "xkcd:light seafoam green" => -"#a7ffb5",
      "xkcd:olive yellow" => -"#c2b709",
      "xkcd:pig pink" => -"#e78ea5",
      "xkcd:deep lilac" => -"#966ebd",
      "xkcd:desert" => -"#ccad60",
      "xkcd:dusty lavender" => -"#ac86a8",
      "xkcd:purpley grey" => -"#947e94",
      "xkcd:purply" => -"#983fb2",
      "xkcd:candy pink" => -"#ff63e9",
      "xkcd:light pastel green" => -"#b2fba5",
      "xkcd:boring green" => -"#63b365",
      "xkcd:kiwi green" => -"#8ee53f",
      "xkcd:light grey green" => -"#b7e1a1",
      "xkcd:orange pink" => -"#ff6f52",
      "xkcd:tea green" => -"#bdf8a3",
      "xkcd:very light brown" => -"#d3b683",
      "xkcd:egg shell" => -"#fffcc4",
      "xkcd:eggplant purple" => -"#430541",
      "xkcd:powder pink" => -"#ffb2d0",
      "xkcd:reddish grey" => -"#997570",
      "xkcd:baby shit brown" => -"#ad900d",
      "xkcd:liliac" => -"#c48efd",
      "xkcd:stormy blue" => -"#507b9c",
      "xkcd:ugly brown" => -"#7d7103",
      "xkcd:custard" => -"#fffd78",
      "xkcd:darkish pink" => -"#da467d",
      "xkcd:deep brown" => -"#410200",
      "xkcd:greenish beige" => -"#c9d179",
      "xkcd:manilla" => -"#fffa86",
      "xkcd:off blue" => -"#5684ae",
      "xkcd:battleship grey" => -"#6b7c85",
      "xkcd:browny green" => -"#6f6c0a",
      "xkcd:bruise" => -"#7e4071",
      "xkcd:kelley green" => -"#009337",
      "xkcd:sickly yellow" => -"#d0e429",
      "xkcd:sunny yellow" => -"#fff917",
      "xkcd:azul" => -"#1d5dec",
      "xkcd:darkgreen" => -"#054907",
      "xkcd:green/yellow" => -"#b5ce08",
      "xkcd:lichen" => -"#8fb67b",
      "xkcd:light light green" => -"#c8ffb0",
      "xkcd:pale gold" => -"#fdde6c",
      "xkcd:sun yellow" => -"#ffdf22",
      "xkcd:tan green" => -"#a9be70",
      "xkcd:burple" => -"#6832e3",
      "xkcd:butterscotch" => -"#fdb147",
      "xkcd:toupe" => -"#c7ac7d",
      "xkcd:dark cream" => -"#fff39a",
      "xkcd:indian red" => -"#850e04",
      "xkcd:light lavendar" => -"#efc0fe",
      "xkcd:poison green" => -"#40fd14",
      "xkcd:baby puke green" => -"#b6c406",
      "xkcd:bright yellow green" => -"#9dff00",
      "xkcd:charcoal grey" => -"#3c4142",
      "xkcd:squash" => -"#f2ab15",
      "xkcd:cinnamon" => -"#ac4f06",
      "xkcd:light pea green" => -"#c4fe82",
      "xkcd:radioactive green" => -"#2cfa1f",
      "xkcd:raw sienna" => -"#9a6200",
      "xkcd:baby purple" => -"#ca9bf7",
      "xkcd:cocoa" => -"#875f42",
      "xkcd:light royal blue" => -"#3a2efe",
      "xkcd:orangeish" => -"#fd8d49",
      "xkcd:rust brown" => -"#8b3103",
      "xkcd:sand brown" => -"#cba560",
      "xkcd:swamp" => -"#698339",
      "xkcd:tealish green" => -"#0cdc73",
      "xkcd:burnt siena" => -"#b75203",
      "xkcd:camo" => -"#7f8f4e",
      "xkcd:dusk blue" => -"#26538d",
      "xkcd:fern" => -"#63a950",
      "xkcd:old rose" => -"#c87f89",
      "xkcd:pale light green" => -"#b1fc99",
      "xkcd:peachy pink" => -"#ff9a8a",
      "xkcd:rosy pink" => -"#f6688e",
      "xkcd:light bluish green" => -"#76fda8",
      "xkcd:light bright green" => -"#53fe5c",
      "xkcd:light neon green" => -"#4efd54",
      "xkcd:light seafoam" => -"#a0febf",
      "xkcd:tiffany blue" => -"#7bf2da",
      "xkcd:washed out green" => -"#bcf5a6",
      "xkcd:browny orange" => -"#ca6b02",
      "xkcd:nice blue" => -"#107ab0",
      "xkcd:sapphire" => -"#2138ab",
      "xkcd:greyish teal" => -"#719f91",
      "xkcd:orangey yellow" => -"#fdb915",
      "xkcd:parchment" => -"#fefcaf",
      "xkcd:straw" => -"#fcf679",
      "xkcd:very dark brown" => -"#1d0200",
      "xkcd:terracota" => -"#cb6843",
      "xkcd:ugly blue" => -"#31668a",
      "xkcd:clear blue" => -"#247afd",
      "xkcd:creme" => -"#ffffb6",
      "xkcd:foam green" => -"#90fda9",
      "xkcd:grey/green" => -"#86a17d",
      "xkcd:light gold" => -"#fddc5c",
      "xkcd:seafoam blue" => -"#78d1b6",
      "xkcd:topaz" => -"#13bbaf",
      "xkcd:violet pink" => -"#fb5ffc",
      "xkcd:wintergreen" => -"#20f986",
      "xkcd:yellow tan" => -"#ffe36e",
      "xkcd:dark fuchsia" => -"#9d0759",
      "xkcd:indigo blue" => -"#3a18b1",
      "xkcd:light yellowish green" => -"#c2ff89",
      "xkcd:pale magenta" => -"#d767ad",
      "xkcd:rich purple" => -"#720058",
      "xkcd:sunflower yellow" => -"#ffda03",
      "xkcd:green/blue" => -"#01c08d",
      "xkcd:leather" => -"#ac7434",
      "xkcd:racing green" => -"#014600",
      "xkcd:vivid purple" => -"#9900fa",
      "xkcd:dark royal blue" => -"#02066f",
      "xkcd:hazel" => -"#8e7618",
      "xkcd:muted pink" => -"#d1768f",
      "xkcd:booger green" => -"#96b403",
      "xkcd:canary" => -"#fdff63",
      "xkcd:cool grey" => -"#95a3a6",
      "xkcd:dark taupe" => -"#7f684e",
      "xkcd:darkish purple" => -"#751973",
      "xkcd:true green" => -"#089404",
      "xkcd:coral pink" => -"#ff6163",
      "xkcd:dark sage" => -"#598556",
      "xkcd:dark slate blue" => -"#214761",
      "xkcd:flat blue" => -"#3c73a8",
      "xkcd:mushroom" => -"#ba9e88",
      "xkcd:rich blue" => -"#021bf9",
      "xkcd:dirty purple" => -"#734a65",
      "xkcd:greenblue" => -"#23c48b",
      "xkcd:icky green" => -"#8fae22",
      "xkcd:light khaki" => -"#e6f2a2",
      "xkcd:warm blue" => -"#4b57db",
      "xkcd:dark hot pink" => -"#d90166",
      "xkcd:deep sea blue" => -"#015482",
      "xkcd:carmine" => -"#9d0216",
      "xkcd:dark yellow green" => -"#728f02",
      "xkcd:pale peach" => -"#ffe5ad",
      "xkcd:plum purple" => -"#4e0550",
      "xkcd:golden rod" => -"#f9bc08",
      "xkcd:neon red" => -"#ff073a",
      "xkcd:old pink" => -"#c77986",
      "xkcd:very pale blue" => -"#d6fffe",
      "xkcd:blood orange" => -"#fe4b03",
      "xkcd:grapefruit" => -"#fd5956",
      "xkcd:sand yellow" => -"#fce166",
      "xkcd:clay brown" => -"#b2713d",
      "xkcd:dark blue grey" => -"#1f3b4d",
      "xkcd:flat green" => -"#699d4c",
      "xkcd:light green blue" => -"#56fca2",
      "xkcd:warm pink" => -"#fb5581",
      "xkcd:dodger blue" => -"#3e82fc",
      "xkcd:gross green" => -"#a0bf16",
      "xkcd:ice" => -"#d6fffa",
      "xkcd:metallic blue" => -"#4f738e",
      "xkcd:pale salmon" => -"#ffb19a",
      "xkcd:sap green" => -"#5c8b15",
      "xkcd:algae" => -"#54ac68",
      "xkcd:bluey grey" => -"#89a0b0",
      "xkcd:greeny grey" => -"#7ea07a",
      "xkcd:highlighter green" => -"#1bfc06",
      "xkcd:light light blue" => -"#cafffb",
      "xkcd:light mint" => -"#b6ffbb",
      "xkcd:raw umber" => -"#a75e09",
      "xkcd:vivid blue" => -"#152eff",
      "xkcd:deep lavender" => -"#8d5eb7",
      "xkcd:dull teal" => -"#5f9e8f",
      "xkcd:light greenish blue" => -"#63f7b4",
      "xkcd:mud green" => -"#606602",
      "xkcd:pinky" => -"#fc86aa",
      "xkcd:red wine" => -"#8c0034",
      "xkcd:shit green" => -"#758000",
      "xkcd:tan brown" => -"#ab7e4c",
      "xkcd:darkblue" => -"#030764",
      "xkcd:rosa" => -"#fe86a4",
      "xkcd:lipstick" => -"#d5174e",
      "xkcd:pale mauve" => -"#fed0fc",
      "xkcd:claret" => -"#680018",
      "xkcd:dandelion" => -"#fedf08",
      "xkcd:orangered" => -"#fe420f",
      "xkcd:poop green" => -"#6f7c00",
      "xkcd:ruby" => -"#ca0147",
      "xkcd:dark" => -"#1b2431",
      "xkcd:greenish turquoise" => -"#00fbb0",
      "xkcd:pastel red" => -"#db5856",
      "xkcd:piss yellow" => -"#ddd618",
      "xkcd:bright cyan" => -"#41fdfe",
      "xkcd:dark coral" => -"#cf524e",
      "xkcd:algae green" => -"#21c36f",
      "xkcd:darkish red" => -"#a90308",
      "xkcd:reddy brown" => -"#6e1005",
      "xkcd:blush pink" => -"#fe828c",
      "xkcd:camouflage green" => -"#4b6113",
      "xkcd:lawn green" => -"#4da409",
      "xkcd:putty" => -"#beae8a",
      "xkcd:vibrant blue" => -"#0339f8",
      "xkcd:dark sand" => -"#a88f59",
      "xkcd:purple/blue" => -"#5d21d0",
      "xkcd:saffron" => -"#feb209",
      "xkcd:twilight" => -"#4e518b",
      "xkcd:warm brown" => -"#964e02",
      "xkcd:bluegrey" => -"#85a3b2",
      "xkcd:bubble gum pink" => -"#ff69af",
      "xkcd:duck egg blue" => -"#c3fbf4",
      "xkcd:greenish cyan" => -"#2afeb7",
      "xkcd:petrol" => -"#005f6a",
      "xkcd:royal" => -"#0c1793",
      "xkcd:butter" => -"#ffff81",
      "xkcd:dusty orange" => -"#f0833a",
      "xkcd:off yellow" => -"#f1f33f",
      "xkcd:pale olive green" => -"#b1d27b",
      "xkcd:orangish" => -"#fc824a",
      "xkcd:leaf" => -"#71aa34",
      "xkcd:light blue grey" => -"#b7c9e2",
      "xkcd:dried blood" => -"#4b0101",
      "xkcd:lightish purple" => -"#a552e6",
      "xkcd:rusty red" => -"#af2f0d",
      "xkcd:lavender blue" => -"#8b88f8",
      "xkcd:light grass green" => -"#9af764",
      "xkcd:light mint green" => -"#a6fbb2",
      "xkcd:sunflower" => -"#ffc512",
      "xkcd:velvet" => -"#750851",
      "xkcd:brick orange" => -"#c14a09",
      "xkcd:lightish red" => -"#fe2f4a",
      "xkcd:pure blue" => -"#0203e2",
      "xkcd:twilight blue" => -"#0a437a",
      "xkcd:violet red" => -"#a50055",
      "xkcd:yellowy brown" => -"#ae8b0c",
      "xkcd:carnation" => -"#fd798f",
      "xkcd:muddy yellow" => -"#bfac05",
      "xkcd:dark seafoam green" => -"#3eaf76",
      "xkcd:deep rose" => -"#c74767",
      "xkcd:dusty red" => -"#b9484e",
      "xkcd:grey/blue" => -"#647d8e",
      "xkcd:lemon lime" => -"#bffe28",
      "xkcd:purple/pink" => -"#d725de",
      "xkcd:brown yellow" => -"#b29705",
      "xkcd:purple brown" => -"#673a3f",
      "xkcd:wisteria" => -"#a87dc2",
      "xkcd:banana yellow" => -"#fafe4b",
      "xkcd:lipstick red" => -"#c0022f",
      "xkcd:water blue" => -"#0e87cc",
      "xkcd:brown grey" => -"#8d8468",
      "xkcd:vibrant purple" => -"#ad03de",
      "xkcd:baby green" => -"#8cff9e",
      "xkcd:barf green" => -"#94ac02",
      "xkcd:eggshell blue" => -"#c4fff7",
      "xkcd:sandy yellow" => -"#fdee73",
      "xkcd:cool green" => -"#33b864",
      "xkcd:pale" => -"#fff9d0",
      "xkcd:blue/grey" => -"#758da3",
      "xkcd:hot magenta" => -"#f504c9",
      "xkcd:greyblue" => -"#77a1b5",
      "xkcd:purpley" => -"#8756e4",
      "xkcd:baby shit green" => -"#889717",
      "xkcd:brownish pink" => -"#c27e79",
      "xkcd:dark aquamarine" => -"#017371",
      "xkcd:diarrhea" => -"#9f8303",
      "xkcd:light mustard" => -"#f7d560",
      "xkcd:pale sky blue" => -"#bdf6fe",
      "xkcd:turtle green" => -"#75b84f",
      "xkcd:bright olive" => -"#9cbb04",
      "xkcd:dark grey blue" => -"#29465b",
      "xkcd:greeny brown" => -"#696006",
      "xkcd:lemon green" => -"#adf802",
      "xkcd:light periwinkle" => -"#c1c6fc",
      "xkcd:seaweed green" => -"#35ad6b",
      "xkcd:sunshine yellow" => -"#fffd37",
      "xkcd:ugly purple" => -"#a442a0",
      "xkcd:medium pink" => -"#f36196",
      "xkcd:puke brown" => -"#947706",
      "xkcd:very light pink" => -"#fff4f2",
      "xkcd:viridian" => -"#1e9167",
      "xkcd:bile" => -"#b5c306",
      "xkcd:faded yellow" => -"#feff7f",
      "xkcd:very pale green" => -"#cffdbc",
      "xkcd:vibrant green" => -"#0add08",
      "xkcd:bright lime" => -"#87fd05",
      "xkcd:spearmint" => -"#1ef876",
      "xkcd:light aquamarine" => -"#7bfdc7",
      "xkcd:light sage" => -"#bcecac",
      "xkcd:yellowgreen" => -"#bbf90f",
      "xkcd:baby poo" => -"#ab9004",
      "xkcd:dark seafoam" => -"#1fb57a",
      "xkcd:deep teal" => -"#00555a",
      "xkcd:heather" => -"#a484ac",
      "xkcd:rust orange" => -"#c45508",
      "xkcd:dirty blue" => -"#3f829d",
      "xkcd:fern green" => -"#548d44",
      "xkcd:bright lilac" => -"#c95efb",
      "xkcd:weird green" => -"#3ae57f",
      "xkcd:peacock blue" => -"#016795",
      "xkcd:avocado green" => -"#87a922",
      "xkcd:faded orange" => -"#f0944d",
      "xkcd:grape purple" => -"#5d1451",
      "xkcd:hot green" => -"#25ff29",
      "xkcd:lime yellow" => -"#d0fe1d",
      "xkcd:mango" => -"#ffa62b",
      "xkcd:shamrock" => -"#01b44c",
      "xkcd:bubblegum" => -"#ff6cb5",
      "xkcd:purplish brown" => -"#6b4247",
      "xkcd:vomit yellow" => -"#c7c10c",
      "xkcd:pale cyan" => -"#b7fffa",
      "xkcd:key lime" => -"#aeff6e",
      "xkcd:tomato red" => -"#ec2d01",
      "xkcd:lightgreen" => -"#76ff7b",
      "xkcd:merlot" => -"#730039",
      "xkcd:night blue" => -"#040348",
      "xkcd:purpleish pink" => -"#df4ec8",
      "xkcd:apple" => -"#6ecb3c",
      "xkcd:baby poop green" => -"#8f9805",
      "xkcd:green apple" => -"#5edc1f",
      "xkcd:heliotrope" => -"#d94ff5",
      "xkcd:yellow/green" => -"#c8fd3d",
      "xkcd:almost black" => -"#070d0d",
      "xkcd:cool blue" => -"#4984b8",
      "xkcd:leafy green" => -"#51b73b",
      "xkcd:mustard brown" => -"#ac7e04",
      "xkcd:dusk" => -"#4e5481",
      "xkcd:dull brown" => -"#876e4b",
      "xkcd:frog green" => -"#58bc08",
      "xkcd:vivid green" => -"#2fef10",
      "xkcd:bright light green" => -"#2dfe54",
      "xkcd:fluro green" => -"#0aff02",
      "xkcd:kiwi" => -"#9cef43",
      "xkcd:seaweed" => -"#18d17b",
      "xkcd:navy green" => -"#35530a",
      "xkcd:ultramarine blue" => -"#1805db",
      "xkcd:iris" => -"#6258c4",
      "xkcd:pastel orange" => -"#ff964f",
      "xkcd:yellowish orange" => -"#ffab0f",
      "xkcd:perrywinkle" => -"#8f8ce7",
      "xkcd:tealish" => -"#24bca8",
      "xkcd:dark plum" => -"#3f012c",
      "xkcd:pear" => -"#cbf85f",
      "xkcd:pinkish orange" => -"#ff724c",
      "xkcd:midnight purple" => -"#280137",
      "xkcd:light urple" => -"#b36ff6",
      "xkcd:dark mint" => -"#48c072",
      "xkcd:greenish tan" => -"#bccb7a",
      "xkcd:light burgundy" => -"#a8415b",
      "xkcd:turquoise blue" => -"#06b1c4",
      "xkcd:ugly pink" => -"#cd7584",
      "xkcd:sandy" => -"#f1da7a",
      "xkcd:electric pink" => -"#ff0490",
      "xkcd:muted purple" => -"#805b87",
      "xkcd:mid green" => -"#50a747",
      "xkcd:greyish" => -"#a8a495",
      "xkcd:neon yellow" => -"#cfff04",
      "xkcd:banana" => -"#ffff7e",
      "xkcd:carnation pink" => -"#ff7fa7",
      "xkcd:tomato" => -"#ef4026",
      "xkcd:sea" => -"#3c9992",
      "xkcd:muddy brown" => -"#886806",
      "xkcd:turquoise green" => -"#04f489",
      "xkcd:buff" => -"#fef69e",
      "xkcd:fawn" => -"#cfaf7b",
      "xkcd:muted blue" => -"#3b719f",
      "xkcd:pale rose" => -"#fdc1c5",
      "xkcd:dark mint green" => -"#20c073",
      "xkcd:amethyst" => -"#9b5fc0",
      "xkcd:blue/green" => -"#0f9b8e",
      "xkcd:chestnut" => -"#742802",
      "xkcd:sick green" => -"#9db92c",
      "xkcd:pea" => -"#a4bf20",
      "xkcd:rusty orange" => -"#cd5909",
      "xkcd:stone" => -"#ada587",
      "xkcd:rose red" => -"#be013c",
      "xkcd:pale aqua" => -"#b8ffeb",
      "xkcd:deep orange" => -"#dc4d01",
      "xkcd:earth" => -"#a2653e",
      "xkcd:mossy green" => -"#638b27",
      "xkcd:grassy green" => -"#419c03",
      "xkcd:pale lime green" => -"#b1ff65",
      "xkcd:light grey blue" => -"#9dbcd4",
      "xkcd:pale grey" => -"#fdfdfe",
      "xkcd:asparagus" => -"#77ab56",
      "xkcd:blueberry" => -"#464196",
      "xkcd:purple red" => -"#990147",
      "xkcd:pale lime" => -"#befd73",
      "xkcd:greenish teal" => -"#32bf84",
      "xkcd:caramel" => -"#af6f09",
      "xkcd:deep magenta" => -"#a0025c",
      "xkcd:light peach" => -"#ffd8b1",
      "xkcd:milk chocolate" => -"#7f4e1e",
      "xkcd:ocher" => -"#bf9b0c",
      "xkcd:off green" => -"#6ba353",
      "xkcd:purply pink" => -"#f075e6",
      "xkcd:lightblue" => -"#7bc8f6",
      "xkcd:dusky blue" => -"#475f94",
      "xkcd:golden" => -"#f5bf03",
      "xkcd:light beige" => -"#fffeb6",
      "xkcd:butter yellow" => -"#fffd74",
      "xkcd:dusky purple" => -"#895b7b",
      "xkcd:french blue" => -"#436bad",
      "xkcd:ugly yellow" => -"#d0c101",
      "xkcd:greeny yellow" => -"#c6f808",
      "xkcd:orangish red" => -"#f43605",
      "xkcd:shamrock green" => -"#02c14d",
      "xkcd:orangish brown" => -"#b25f03",
      "xkcd:tree green" => -"#2a7e19",
      "xkcd:deep violet" => -"#490648",
      "xkcd:gunmetal" => -"#536267",
      "xkcd:blue/purple" => -"#5a06ef",
      "xkcd:cherry" => -"#cf0234",
      "xkcd:sandy brown" => -"#c4a661",
      "xkcd:warm grey" => -"#978a84",
      "xkcd:dark indigo" => -"#1f0954",
      "xkcd:midnight" => -"#03012d",
      "xkcd:bluey green" => -"#2bb179",
      "xkcd:grey pink" => -"#c3909b",
      "xkcd:soft purple" => -"#a66fb5",
      "xkcd:blood" => -"#770001",
      "xkcd:brown red" => -"#922b05",
      "xkcd:medium grey" => -"#7d7f7c",
      "xkcd:berry" => -"#990f4b",
      "xkcd:poo" => -"#8f7303",
      "xkcd:purpley pink" => -"#c83cb9",
      "xkcd:light salmon" => -"#fea993",
      "xkcd:snot" => -"#acbb0d",
      "xkcd:easter purple" => -"#c071fe",
      "xkcd:light yellow green" => -"#ccfd7f",
      "xkcd:dark navy blue" => -"#00022e",
      "xkcd:drab" => -"#828344",
      "xkcd:light rose" => -"#ffc5cb",
      "xkcd:rouge" => -"#ab1239",
      "xkcd:purplish red" => -"#b0054b",
      "xkcd:slime green" => -"#99cc04",
      "xkcd:baby poop" => -"#937c00",
      "xkcd:irish green" => -"#019529",
      "xkcd:pink/purple" => -"#ef1de7",
      "xkcd:dark navy" => -"#000435",
      "xkcd:greeny blue" => -"#42b395",
      "xkcd:light plum" => -"#9d5783",
      "xkcd:pinkish grey" => -"#c8aca9",
      "xkcd:dirty orange" => -"#c87606",
      "xkcd:rust red" => -"#aa2704",
      "xkcd:pale lilac" => -"#e4cbff",
      "xkcd:orangey red" => -"#fa4224",
      "xkcd:primary blue" => -"#0804f9",
      "xkcd:kermit green" => -"#5cb200",
      "xkcd:brownish purple" => -"#76424e",
      "xkcd:murky green" => -"#6c7a0e",
      "xkcd:wheat" => -"#fbdd7e",
      "xkcd:very dark purple" => -"#2a0134",
      "xkcd:bottle green" => -"#044a05",
      "xkcd:watermelon" => -"#fd4659",
      "xkcd:deep sky blue" => -"#0d75f8",
      "xkcd:fire engine red" => -"#fe0002",
      "xkcd:yellow ochre" => -"#cb9d06",
      "xkcd:pumpkin orange" => -"#fb7d07",
      "xkcd:pale olive" => -"#b9cc81",
      "xkcd:light lilac" => -"#edc8ff",
      "xkcd:lightish green" => -"#61e160",
      "xkcd:carolina blue" => -"#8ab8fe",
      "xkcd:mulberry" => -"#920a4e",
      "xkcd:shocking pink" => -"#fe02a2",
      "xkcd:auburn" => -"#9a3001",
      "xkcd:bright lime green" => -"#65fe08",
      "xkcd:celadon" => -"#befdb7",
      "xkcd:pinkish brown" => -"#b17261",
      "xkcd:poo brown" => -"#885f01",
      "xkcd:bright sky blue" => -"#02ccfe",
      "xkcd:celery" => -"#c1fd95",
      "xkcd:dirt brown" => -"#836539",
      "xkcd:strawberry" => -"#fb2943",
      "xkcd:dark lime" => -"#84b701",
      "xkcd:copper" => -"#b66325",
      "xkcd:medium brown" => -"#7f5112",
      "xkcd:muted green" => -"#5fa052",
      "xkcd:robin's egg" => -"#6dedfd",
      "xkcd:bright aqua" => -"#0bf9ea",
      "xkcd:bright lavender" => -"#c760ff",
      "xkcd:ivory" => -"#ffffcb",
      "xkcd:very light purple" => -"#f6cefc",
      "xkcd:light navy" => -"#155084",
      "xkcd:pink red" => -"#f5054f",
      "xkcd:olive brown" => -"#645403",
      "xkcd:poop brown" => -"#7a5901",
      "xkcd:mustard green" => -"#a8b504",
      "xkcd:ocean green" => -"#3d9973",
      "xkcd:very dark blue" => -"#000133",
      "xkcd:dusty green" => -"#76a973",
      "xkcd:light navy blue" => -"#2e5a88",
      "xkcd:minty green" => -"#0bf77d",
      "xkcd:adobe" => -"#bd6c48",
      "xkcd:barney" => -"#ac1db8",
      "xkcd:jade green" => -"#2baf6a",
      "xkcd:bright light blue" => -"#26f7fd",
      "xkcd:light lime" => -"#aefd6c",
      "xkcd:dark khaki" => -"#9b8f55",
      "xkcd:orange yellow" => -"#ffad01",
      "xkcd:ocre" => -"#c69c04",
      "xkcd:maize" => -"#f4d054",
      "xkcd:faded pink" => -"#de9dac",
      "xkcd:british racing green" => -"#05480d",
      "xkcd:sandstone" => -"#c9ae74",
      "xkcd:mud brown" => -"#60460f",
      "xkcd:light sea green" => -"#98f6b0",
      "xkcd:robin egg blue" => -"#8af1fe",
      "xkcd:aqua marine" => -"#2ee8bb",
      "xkcd:dark sea green" => -"#11875d",
      "xkcd:soft pink" => -"#fdb0c0",
      "xkcd:orangey brown" => -"#b16002",
      "xkcd:cherry red" => -"#f7022a",
      "xkcd:burnt yellow" => -"#d5ab09",
      "xkcd:brownish grey" => -"#86775f",
      "xkcd:camel" => -"#c69f59",
      "xkcd:purplish grey" => -"#7a687f",
      "xkcd:marine" => -"#042e60",
      "xkcd:greyish pink" => -"#c88d94",
      "xkcd:pale turquoise" => -"#a5fbd5",
      "xkcd:pastel yellow" => -"#fffe71",
      "xkcd:bluey purple" => -"#6241c7",
      "xkcd:canary yellow" => -"#fffe40",
      "xkcd:faded red" => -"#d3494e",
      "xkcd:sepia" => -"#985e2b",
      "xkcd:coffee" => -"#a6814c",
      "xkcd:bright magenta" => -"#ff08e8",
      "xkcd:mocha" => -"#9d7651",
      "xkcd:ecru" => -"#feffca",
      "xkcd:purpleish" => -"#98568d",
      "xkcd:cranberry" => -"#9e003a",
      "xkcd:darkish green" => -"#287c37",
      "xkcd:brown orange" => -"#b96902",
      "xkcd:dusky rose" => -"#ba6873",
      "xkcd:melon" => -"#ff7855",
      "xkcd:sickly green" => -"#94b21c",
      "xkcd:silver" => -"#c5c9c7",
      "xkcd:purply blue" => -"#661aee",
      "xkcd:purpleish blue" => -"#6140ef",
      "xkcd:hospital green" => -"#9be5aa",
      "xkcd:shit brown" => -"#7b5804",
      "xkcd:mid blue" => -"#276ab3",
      "xkcd:amber" => -"#feb308",
      "xkcd:easter green" => -"#8cfd7e",
      "xkcd:soft blue" => -"#6488ea",
      "xkcd:cerulean blue" => -"#056eee",
      "xkcd:golden brown" => -"#b27a01",
      "xkcd:bright turquoise" => -"#0ffef9",
      "xkcd:red pink" => -"#fa2a55",
      "xkcd:red purple" => -"#820747",
      "xkcd:greyish brown" => -"#7a6a4f",
      "xkcd:vermillion" => -"#f4320c",
      "xkcd:russet" => -"#a13905",
      "xkcd:steel grey" => -"#6f828a",
      "xkcd:lighter purple" => -"#a55af4",
      "xkcd:bright violet" => -"#ad0afd",
      "xkcd:prussian blue" => -"#004577",
      "xkcd:slate green" => -"#658d6d",
      "xkcd:dirty pink" => -"#ca7b80",
      "xkcd:dark blue green" => -"#005249",
      "xkcd:pine" => -"#2b5d34",
      "xkcd:yellowy green" => -"#bff128",
      "xkcd:dark gold" => -"#b59410",
      "xkcd:bluish" => -"#2976bb",
      "xkcd:darkish blue" => -"#014182",
      "xkcd:dull red" => -"#bb3f3f",
      "xkcd:pinky red" => -"#fc2647",
      "xkcd:bronze" => -"#a87900",
      "xkcd:pale teal" => -"#82cbb2",
      "xkcd:military green" => -"#667c3e",
      "xkcd:barbie pink" => -"#fe46a5",
      "xkcd:bubblegum pink" => -"#fe83cc",
      "xkcd:pea soup green" => -"#94a617",
      "xkcd:dark mustard" => -"#a88905",
      "xkcd:shit" => -"#7f5f00",
      "xkcd:medium purple" => -"#9e43a2",
      "xkcd:very dark green" => -"#062e03",
      "xkcd:dirt" => -"#8a6e45",
      "xkcd:dusky pink" => -"#cc7a8b",
      "xkcd:red violet" => -"#9e0168",
      "xkcd:lemon yellow" => -"#fdff38",
      "xkcd:pistachio" => -"#c0fa8b",
      "xkcd:dull yellow" => -"#eedc5b",
      "xkcd:dark lime green" => -"#7ebd01",
      "xkcd:denim blue" => -"#3b5b92",
      "xkcd:teal blue" => -"#01889f",
      "xkcd:lightish blue" => -"#3d7afd",
      "xkcd:purpley blue" => -"#5f34e7",
      "xkcd:light indigo" => -"#6d5acf",
      "xkcd:swamp green" => -"#748500",
      "xkcd:brown green" => -"#706c11",
      "xkcd:dark maroon" => -"#3c0008",
      "xkcd:hot purple" => -"#cb00f5",
      "xkcd:dark forest green" => -"#002d04",
      "xkcd:faded blue" => -"#658cbb",
      "xkcd:drab green" => -"#749551",
      "xkcd:light lime green" => -"#b9ff66",
      "xkcd:snot green" => -"#9dc100",
      "xkcd:yellowish" => -"#faee66",
      "xkcd:light blue green" => -"#7efbb3",
      "xkcd:bordeaux" => -"#7b002c",
      "xkcd:light mauve" => -"#c292a1",
      "xkcd:ocean" => -"#017b92",
      "xkcd:marigold" => -"#fcc006",
      "xkcd:muddy green" => -"#657432",
      "xkcd:dull orange" => -"#d8863b",
      "xkcd:steel" => -"#738595",
      "xkcd:electric purple" => -"#aa23ff",
      "xkcd:fluorescent green" => -"#08ff08",
      "xkcd:yellowish brown" => -"#9b7a01",
      "xkcd:blush" => -"#f29e8e",
      "xkcd:soft green" => -"#6fc276",
      "xkcd:bright orange" => -"#ff5b00",
      "xkcd:lemon" => -"#fdff52",
      "xkcd:purple grey" => -"#866f85",
      "xkcd:acid green" => -"#8ffe09",
      "xkcd:pale lavender" => -"#eecffe",
      "xkcd:violet blue" => -"#510ac9",
      "xkcd:light forest green" => -"#4f9153",
      "xkcd:burnt red" => -"#9f2305",
      "xkcd:khaki green" => -"#728639",
      "xkcd:cerise" => -"#de0c62",
      "xkcd:faded purple" => -"#916e99",
      "xkcd:apricot" => -"#ffb16d",
      "xkcd:dark olive green" => -"#3c4d03",
      "xkcd:grey brown" => -"#7f7053",
      "xkcd:green grey" => -"#77926f",
      "xkcd:true blue" => -"#010fcc",
      "xkcd:pale violet" => -"#ceaefa",
      "xkcd:periwinkle blue" => -"#8f99fb",
      "xkcd:light sky blue" => -"#c6fcff",
      "xkcd:blurple" => -"#5539cc",
      "xkcd:green brown" => -"#544e03",
      "xkcd:bluegreen" => -"#017a79",
      "xkcd:bright teal" => -"#01f9c6",
      "xkcd:brownish yellow" => -"#c9b003",
      "xkcd:pea soup" => -"#929901",
      "xkcd:forest" => -"#0b5509",
      "xkcd:barney purple" => -"#a00498",
      "xkcd:ultramarine" => -"#2000b1",
      "xkcd:purplish" => -"#94568c",
      "xkcd:puke yellow" => -"#c2be0e",
      "xkcd:bluish grey" => -"#748b97",
      "xkcd:dark periwinkle" => -"#665fd1",
      "xkcd:dark lilac" => -"#9c6da5",
      "xkcd:reddish" => -"#c44240",
      "xkcd:light maroon" => -"#a24857",
      "xkcd:dusty purple" => -"#825f87",
      "xkcd:terra cotta" => -"#c9643b",
      "xkcd:avocado" => -"#90b134",
      "xkcd:marine blue" => -"#01386a",
      "xkcd:teal green" => -"#25a36f",
      "xkcd:slate grey" => -"#59656d",
      "xkcd:lighter green" => -"#75fd63",
      "xkcd:electric green" => -"#21fc0d",
      "xkcd:dusty blue" => -"#5a86ad",
      "xkcd:golden yellow" => -"#fec615",
      "xkcd:bright yellow" => -"#fffd01",
      "xkcd:light lavender" => -"#dfc5fe",
      "xkcd:umber" => -"#b26400",
      "xkcd:poop" => -"#7f5e00",
      "xkcd:dark peach" => -"#de7e5d",
      "xkcd:jungle green" => -"#048243",
      "xkcd:eggshell" => -"#ffffd4",
      "xkcd:denim" => -"#3b638c",
      "xkcd:yellow brown" => -"#b79400",
      "xkcd:dull purple" => -"#84597e",
      "xkcd:chocolate brown" => -"#411900",
      "xkcd:wine red" => -"#7b0323",
      "xkcd:neon blue" => -"#04d9ff",
      "xkcd:dirty green" => -"#667e2c",
      "xkcd:light tan" => -"#fbeeac",
      "xkcd:ice blue" => -"#d7fffe",
      "xkcd:cadet blue" => -"#4e7496",
      "xkcd:dark mauve" => -"#874c62",
      "xkcd:very light blue" => -"#d5ffff",
      "xkcd:grey purple" => -"#826d8c",
      "xkcd:pastel pink" => -"#ffbacd",
      "xkcd:very light green" => -"#d1ffbd",
      "xkcd:dark sky blue" => -"#448ee4",
      "xkcd:evergreen" => -"#05472a",
      "xkcd:dull pink" => -"#d5869d",
      "xkcd:aubergine" => -"#3d0734",
      "xkcd:mahogany" => -"#4a0100",
      "xkcd:reddish orange" => -"#f8481c",
      "xkcd:deep green" => -"#02590f",
      "xkcd:vomit green" => -"#89a203",
      "xkcd:purple pink" => -"#e03fd8",
      "xkcd:dusty pink" => -"#d58a94",
      "xkcd:faded green" => -"#7bb274",
      "xkcd:camo green" => -"#526525",
      "xkcd:pinky purple" => -"#c94cbe",
      "xkcd:pink purple" => -"#db4bda",
      "xkcd:brownish red" => -"#9e3623",
      "xkcd:dark rose" => -"#b5485d",
      "xkcd:mud" => -"#735c12",
      "xkcd:brownish" => -"#9c6d57",
      "xkcd:emerald green" => -"#028f1e",
      "xkcd:pale brown" => -"#b1916e",
      "xkcd:dull blue" => -"#49759c",
      "xkcd:burnt umber" => -"#a0450e",
      "xkcd:medium green" => -"#39ad48",
      "xkcd:clay" => -"#b66a50",
      "xkcd:light aqua" => -"#8cffdb",
      "xkcd:light olive green" => -"#a4be5c",
      "xkcd:brownish orange" => -"#cb7723",
      "xkcd:dark aqua" => -"#05696b",
      "xkcd:purplish pink" => -"#ce5dae",
      "xkcd:dark salmon" => -"#c85a53",
      "xkcd:greenish grey" => -"#96ae8d",
      "xkcd:jade" => -"#1fa774",
      "xkcd:ugly green" => -"#7a9703",
      "xkcd:dark beige" => -"#ac9362",
      "xkcd:emerald" => -"#01a049",
      "xkcd:pale red" => -"#d9544d",
      "xkcd:light magenta" => -"#fa5ff7",
      "xkcd:sky" => -"#82cafc",
      "xkcd:light cyan" => -"#acfffc",
      "xkcd:yellow orange" => -"#fcb001",
      "xkcd:reddish purple" => -"#910951",
      "xkcd:reddish pink" => -"#fe2c54",
      "xkcd:orchid" => -"#c875c4",
      "xkcd:dirty yellow" => -"#cdc50a",
      "xkcd:orange red" => -"#fd411e",
      "xkcd:deep red" => -"#9a0200",
      "xkcd:orange brown" => -"#be6400",
      "xkcd:cobalt blue" => -"#030aa7",
      "xkcd:neon pink" => -"#fe019a",
      "xkcd:rose pink" => -"#f7879a",
      "xkcd:greyish purple" => -"#887191",
      "xkcd:raspberry" => -"#b00149",
      "xkcd:aqua green" => -"#12e193",
      "xkcd:salmon pink" => -"#fe7b7c",
      "xkcd:tangerine" => -"#ff9408",
      "xkcd:brownish green" => -"#6a6e09",
      "xkcd:red brown" => -"#8b2e16",
      "xkcd:greenish brown" => -"#696112",
      "xkcd:pumpkin" => -"#e17701",
      "xkcd:pine green" => -"#0a481e",
      "xkcd:charcoal" => -"#343837",
      "xkcd:baby pink" => -"#ffb7ce",
      "xkcd:cornflower" => -"#6a79f7",
      "xkcd:blue violet" => -"#5d06e9",
      "xkcd:chocolate" => -"#3d1c02",
      "xkcd:greyish green" => -"#82a67d",
      "xkcd:scarlet" => -"#be0119",
      "xkcd:green yellow" => -"#c9ff27",
      "xkcd:dark olive" => -"#373e02",
      "xkcd:sienna" => -"#a9561e",
      "xkcd:pastel purple" => -"#caa0ff",
      "xkcd:terracotta" => -"#ca6641",
      "xkcd:aqua blue" => -"#02d8e9",
      "xkcd:sage green" => -"#88b378",
      "xkcd:blood red" => -"#980002",
      "xkcd:deep pink" => -"#cb0162",
      "xkcd:grass" => -"#5cac2d",
      "xkcd:moss" => -"#769958",
      "xkcd:pastel blue" => -"#a2bffe",
      "xkcd:bluish green" => -"#10a674",
      "xkcd:green blue" => -"#06b48b",
      "xkcd:dark tan" => -"#af884a",
      "xkcd:greenish blue" => -"#0b8b87",
      "xkcd:pale orange" => -"#ffa756",
      "xkcd:vomit" => -"#a2a415",
      "xkcd:forrest green" => -"#154406",
      "xkcd:dark lavender" => -"#856798",
      "xkcd:dark violet" => -"#34013f",
      "xkcd:purple blue" => -"#632de9",
      "xkcd:dark cyan" => -"#0a888a",
      "xkcd:olive drab" => -"#6f7632",
      "xkcd:pinkish" => -"#d46a7e",
      "xkcd:cobalt" => -"#1e488f",
      "xkcd:neon purple" => -"#bc13fe",
      "xkcd:light turquoise" => -"#7ef4cc",
      "xkcd:apple green" => -"#76cd26",
      "xkcd:dull green" => -"#74a662",
      "xkcd:wine" => -"#80013f",
      "xkcd:powder blue" => -"#b1d1fc",
      "xkcd:off white" => -"#ffffe4",
      "xkcd:electric blue" => -"#0652ff",
      "xkcd:dark turquoise" => -"#045c5a",
      "xkcd:blue purple" => -"#5729ce",
      "xkcd:azure" => -"#069af3",
      "xkcd:bright red" => -"#ff000d",
      "xkcd:pinkish red" => -"#f10c45",
      "xkcd:cornflower blue" => -"#5170d7",
      "xkcd:light olive" => -"#acbf69",
      "xkcd:grape" => -"#6c3461",
      "xkcd:greyish blue" => -"#5e819d",
      "xkcd:purplish blue" => -"#601ef9",
      "xkcd:yellowish green" => -"#b0dd16",
      "xkcd:greenish yellow" => -"#cdfd02",
      "xkcd:medium blue" => -"#2c6fbb",
      "xkcd:dusty rose" => -"#c0737a",
      "xkcd:light violet" => -"#d6b4fc",
      "xkcd:midnight blue" => -"#020035",
      "xkcd:bluish purple" => -"#703be7",
      "xkcd:red orange" => -"#fd3c06",
      "xkcd:dark magenta" => -"#960056",
      "xkcd:greenish" => -"#40a368",
      "xkcd:ocean blue" => -"#03719c",
      "xkcd:coral" => -"#fc5a50",
      "xkcd:cream" => -"#ffffc2",
      "xkcd:reddish brown" => -"#7f2b0a",
      "xkcd:burnt sienna" => -"#b04e0f",
      "xkcd:brick" => -"#a03623",
      "xkcd:sage" => -"#87ae73",
      "xkcd:grey green" => -"#789b73",
      "xkcd:white" => -"#ffffff",
      "xkcd:robin's egg blue" => -"#98eff9",
      "xkcd:moss green" => -"#658b38",
      "xkcd:steel blue" => -"#5a7d9a",
      "xkcd:eggplant" => -"#380835",
      "xkcd:light yellow" => -"#fffe7a",
      "xkcd:leaf green" => -"#5ca904",
      "xkcd:light grey" => -"#d8dcd6",
      "xkcd:puke" => -"#a5a502",
      "xkcd:pinkish purple" => -"#d648d7",
      "xkcd:sea blue" => -"#047495",
      "xkcd:pale purple" => -"#b790d4",
      "xkcd:slate blue" => -"#5b7c99",
      "xkcd:blue grey" => -"#607c8e",
      "xkcd:hunter green" => -"#0b4008",
      "xkcd:fuchsia" => -"#ed0dd9",
      "xkcd:crimson" => -"#8c000f",
      "xkcd:pale yellow" => -"#ffff84",
      "xkcd:ochre" => -"#bf9005",
      "xkcd:mustard yellow" => -"#d2bd0a",
      "xkcd:light red" => -"#ff474c",
      "xkcd:cerulean" => -"#0485d1",
      "xkcd:pale pink" => -"#ffcfdc",
      "xkcd:deep blue" => -"#040273",
      "xkcd:rust" => -"#a83c09",
      "xkcd:light teal" => -"#90e4c1",
      "xkcd:slate" => -"#516572",
      "xkcd:goldenrod" => -"#fac205",
      "xkcd:dark yellow" => -"#d5b60a",
      "xkcd:dark grey" => -"#363737",
      "xkcd:army green" => -"#4b5d16",
      "xkcd:grey blue" => -"#6b8ba4",
      "xkcd:seafoam" => -"#80f9ad",
      "xkcd:puce" => -"#a57e52",
      "xkcd:spring green" => -"#a9f971",
      "xkcd:dark orange" => -"#c65102",
      "xkcd:sand" => -"#e2ca76",
      "xkcd:pastel green" => -"#b0ff9d",
      "xkcd:mint" => -"#9ffeb0",
      "xkcd:light orange" => -"#fdaa48",
      "xkcd:bright pink" => -"#fe01b1",
      "xkcd:chartreuse" => -"#c1f80a",
      "xkcd:deep purple" => -"#36013f",
      "xkcd:dark brown" => -"#341c02",
      "xkcd:taupe" => -"#b9a281",
      "xkcd:pea green" => -"#8eab12",
      "xkcd:puke green" => -"#9aae07",
      "xkcd:kelly green" => -"#02ab2e",
      "xkcd:seafoam green" => -"#7af9ab",
      "xkcd:blue green" => -"#137e6d",
      "xkcd:khaki" => -"#aaa662",
      "xkcd:burgundy" => -"#610023",
      "xkcd:dark teal" => -"#014d4e",
      "xkcd:brick red" => -"#8f1402",
      "xkcd:royal purple" => -"#4b006e",
      "xkcd:plum" => -"#580f41",
      "xkcd:mint green" => -"#8fff9f",
      "xkcd:gold" => -"#dbb40c",
      "xkcd:baby blue" => -"#a2cffe",
      "xkcd:yellow green" => -"#c0fb2d",
      "xkcd:bright purple" => -"#be03fd",
      "xkcd:dark red" => -"#840000",
      "xkcd:pale blue" => -"#d0fefe",
      "xkcd:grass green" => -"#3f9b0b",
      "xkcd:navy" => -"#01153e",
      "xkcd:aquamarine" => -"#04d8b2",
      "xkcd:burnt orange" => -"#c04e01",
      "xkcd:neon green" => -"#0cff0c",
      "xkcd:bright blue" => -"#0165fc",
      "xkcd:rose" => -"#cf6275",
      "xkcd:light pink" => -"#ffd1df",
      "xkcd:mustard" => -"#ceb301",
      "xkcd:indigo" => -"#380282",
      "xkcd:lime" => -"#aaff32",
      "xkcd:sea green" => -"#53fca1",
      "xkcd:periwinkle" => -"#8e82fe",
      "xkcd:dark pink" => -"#cb416b",
      "xkcd:olive green" => -"#677a04",
      "xkcd:peach" => -"#ffb07c",
      "xkcd:pale green" => -"#c7fdb5",
      "xkcd:light brown" => -"#ad8150",
      "xkcd:hot pink" => -"#ff028d",
      "xkcd:black" => -"#000000",
      "xkcd:lilac" => -"#cea2fd",
      "xkcd:navy blue" => -"#001146",
      "xkcd:royal blue" => -"#0504aa",
      "xkcd:beige" => -"#e6daa6",
      "xkcd:salmon" => -"#ff796c",
      "xkcd:olive" => -"#6e750e",
      "xkcd:maroon" => -"#650021",
      "xkcd:bright green" => -"#01ff07",
      "xkcd:dark purple" => -"#35063e",
      "xkcd:mauve" => -"#ae7181",
      "xkcd:forest green" => -"#06470c",
      "xkcd:aqua" => -"#13eac9",
      "xkcd:cyan" => -"#00ffff",
      "xkcd:tan" => -"#d1b26f",
      "xkcd:dark blue" => -"#00035b",
      "xkcd:lavender" => -"#c79fef",
      "xkcd:turquoise" => -"#06c2ac",
      "xkcd:dark green" => -"#033500",
      "xkcd:violet" => -"#9a0eea",
      "xkcd:light purple" => -"#bf77f6",
      "xkcd:lime green" => -"#89fe05",
      "xkcd:grey" => -"#929591",
      "xkcd:sky blue" => -"#75bbfd",
      "xkcd:yellow" => -"#ffff14",
      "xkcd:magenta" => -"#c20078",
      "xkcd:light green" => -"#96f97b",
      "xkcd:orange" => -"#f97306",
      "xkcd:teal" => -"#029386",
      "xkcd:light blue" => -"#95d0fc",
      "xkcd:red" => -"#e50000",
      "xkcd:brown" => -"#653700",
      "xkcd:pink" => -"#ff81c0",
      "xkcd:blue" => -"#0343df",
      "xkcd:green" => -"#15b01a",
      "xkcd:purple" => -"#7e1e9c"
    }.freeze

    # https://drafts.csswg.org/css-color-4/#named-colors
    CSS4_COLORS = {
      "aliceblue" =>            -"#F0F8FF",
      "antiquewhite" =>         -"#FAEBD7",
      "aqua" =>                 -"#00FFFF",
      "aquamarine" =>           -"#7FFFD4",
      "azure" =>                -"#F0FFFF",
      "beige" =>                -"#F5F5DC",
      "bisque" =>               -"#FFE4C4",
      "black" =>                -"#000000",
      "blanchedalmond" =>       -"#FFEBCD",
      "blue" =>                 -"#0000FF",
      "blueviolet" =>           -"#8A2BE2",
      "brown" =>                -"#A52A2A",
      "burlywood" =>            -"#DEB887",
      "cadetblue" =>            -"#5F9EA0",
      "chartreuse" =>           -"#7FFF00",
      "chocolate" =>            -"#D2691E",
      "coral" =>                -"#FF7F50",
      "cornflowerblue" =>       -"#6495ED",
      "cornsilk" =>             -"#FFF8DC",
      "crimson" =>              -"#DC143C",
      "cyan" =>                 -"#00FFFF",
      "darkblue" =>             -"#00008B",
      "darkcyan" =>             -"#008B8B",
      "darkgoldenrod" =>        -"#B8860B",
      "darkgray" =>             -"#A9A9A9",
      "darkgreen" =>            -"#006400",
      "darkgrey" =>             -"#A9A9A9",
      "darkkhaki" =>            -"#BDB76B",
      "darkmagenta" =>          -"#8B008B",
      "darkolivegreen" =>       -"#556B2F",
      "darkorange" =>           -"#FF8C00",
      "darkorchid" =>           -"#9932CC",
      "darkred" =>              -"#8B0000",
      "darksalmon" =>           -"#E9967A",
      "darkseagreen" =>         -"#8FBC8F",
      "darkslateblue" =>        -"#483D8B",
      "darkslategray" =>        -"#2F4F4F",
      "darkslategrey" =>        -"#2F4F4F",
      "darkturquoise" =>        -"#00CED1",
      "darkviolet" =>           -"#9400D3",
      "deeppink" =>             -"#FF1493",
      "deepskyblue" =>          -"#00BFFF",
      "dimgray" =>              -"#696969",
      "dimgrey" =>              -"#696969",
      "dodgerblue" =>           -"#1E90FF",
      "firebrick" =>            -"#B22222",
      "floralwhite" =>          -"#FFFAF0",
      "forestgreen" =>          -"#228B22",
      "fuchsia" =>              -"#FF00FF",
      "gainsboro" =>            -"#DCDCDC",
      "ghostwhite" =>           -"#F8F8FF",
      "gold" =>                 -"#FFD700",
      "goldenrod" =>            -"#DAA520",
      "gray" =>                 -"#808080",
      "green" =>                -"#008000",
      "greenyellow" =>          -"#ADFF2F",
      "grey" =>                 -"#808080",
      "honeydew" =>             -"#F0FFF0",
      "hotpink" =>              -"#FF69B4",
      "indianred" =>            -"#CD5C5C",
      "indigo" =>               -"#4B0082",
      "ivory" =>                -"#FFFFF0",
      "khaki" =>                -"#F0E68C",
      "lavender" =>             -"#E6E6FA",
      "lavenderblush" =>        -"#FFF0F5",
      "lawngreen" =>            -"#7CFC00",
      "lemonchiffon" =>         -"#FFFACD",
      "lightblue" =>            -"#ADD8E6",
      "lightcoral" =>           -"#F08080",
      "lightcyan" =>            -"#E0FFFF",
      "lightgoldenrodyellow" => -"#FAFAD2",
      "lightgray" =>            -"#D3D3D3",
      "lightgreen" =>           -"#90EE90",
      "lightgrey" =>            -"#D3D3D3",
      "lightpink" =>            -"#FFB6C1",
      "lightsalmon" =>          -"#FFA07A",
      "lightseagreen" =>        -"#20B2AA",
      "lightskyblue" =>         -"#87CEFA",
      "lightslategray" =>       -"#778899",
      "lightslategrey" =>       -"#778899",
      "lightsteelblue" =>       -"#B0C4DE",
      "lightyellow" =>          -"#FFFFE0",
      "lime" =>                 -"#00FF00",
      "limegreen" =>            -"#32CD32",
      "linen" =>                -"#FAF0E6",
      "magenta" =>              -"#FF00FF",
      "maroon" =>               -"#800000",
      "mediumaquamarine" =>     -"#66CDAA",
      "mediumblue" =>           -"#0000CD",
      "mediumorchid" =>         -"#BA55D3",
      "mediumpurple" =>         -"#9370DB",
      "mediumseagreen" =>       -"#3CB371",
      "mediumslateblue" =>      -"#7B68EE",
      "mediumspringgreen" =>    -"#00FA9A",
      "mediumturquoise" =>      -"#48D1CC",
      "mediumvioletred" =>      -"#C71585",
      "midnightblue" =>         -"#191970",
      "mintcream" =>            -"#F5FFFA",
      "mistyrose" =>            -"#FFE4E1",
      "moccasin" =>             -"#FFE4B5",
      "navajowhite" =>          -"#FFDEAD",
      "navy" =>                 -"#000080",
      "oldlace" =>              -"#FDF5E6",
      "olive" =>                -"#808000",
      "olivedrab" =>            -"#6B8E23",
      "orange" =>               -"#FFA500",
      "orangered" =>            -"#FF4500",
      "orchid" =>               -"#DA70D6",
      "palegoldenrod" =>        -"#EEE8AA",
      "palegreen" =>            -"#98FB98",
      "paleturquoise" =>        -"#AFEEEE",
      "palevioletred" =>        -"#DB7093",
      "papayawhip" =>           -"#FFEFD5",
      "peachpuff" =>            -"#FFDAB9",
      "peru" =>                 -"#CD853F",
      "pink" =>                 -"#FFC0CB",
      "plum" =>                 -"#DDA0DD",
      "powderblue" =>           -"#B0E0E6",
      "purple" =>               -"#800080",
      "rebeccapurple" =>        -"#663399",
      "red" =>                  -"#FF0000",
      "rosybrown" =>            -"#BC8F8F",
      "royalblue" =>            -"#4169E1",
      "saddlebrown" =>          -"#8B4513",
      "salmon" =>               -"#FA8072",
      "sandybrown" =>           -"#F4A460",
      "seagreen" =>             -"#2E8B57",
      "seashell" =>             -"#FFF5EE",
      "sienna" =>               -"#A0522D",
      "silver" =>               -"#C0C0C0",
      "skyblue" =>              -"#87CEEB",
      "slateblue" =>            -"#6A5ACD",
      "slategray" =>            -"#708090",
      "slategrey" =>            -"#708090",
      "snow" =>                 -"#FFFAFA",
      "springgreen" =>          -"#00FF7F",
      "steelblue" =>            -"#4682B4",
      "tan" =>                  -"#D2B48C",
      "teal" =>                 -"#008080",
      "thistle" =>              -"#D8BFD8",
      "tomato" =>               -"#FF6347",
      "turquoise" =>            -"#40E0D0",
      "violet" =>               -"#EE82EE",
      "wheat" =>                -"#F5DEB3",
      "white" =>                -"#FFFFFF",
      "whitesmoke" =>           -"#F5F5F5",
      "yellow" =>               -"#FFFF00",
      "yellowgreen" =>          -"#9ACD32"
    }.freeze
  end
end
