/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PipedReader
extends Reader {
    static final int PIPE_SIZE = 2048;
    PipedWriter source;
    boolean closed;
    char[] buffer;
    int in;
    int out;
    char[] read_buf;

    public void connect(PipedWriter source) throws IOException {
        if (this.source != null || source.sink != null) {
            throw new IOException("Already connected");
        }
        source.sink = this;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receive(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            int bufpos = offset;
            while (len > 0) {
                try {
                    while (this.in == this.out) {
                        this.lock.notifyAll();
                        this.lock.wait();
                        if (!this.closed) continue;
                        throw new IOException("Pipe closed");
                    }
                }
                catch (InterruptedException ix) {
                    throw new InterruptedIOException();
                }
                if (this.in < 0) {
                    this.in = 0;
                }
                int copylen = this.in < this.out ? Math.min(len, this.out - this.in) : Math.min(len, this.buffer.length - this.in);
                System.arraycopy(buf, bufpos, this.buffer, this.in, copylen);
                len -= copylen;
                bufpos += copylen;
                this.in += copylen;
                if (this.in != this.buffer.length) continue;
                this.in = 0;
            }
            this.lock.notifyAll();
            return;
        }
    }

    public int read() throws IOException {
        int r = this.read(this.read_buf, 0, 1);
        return r != -1 ? this.read_buf[0] : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.source == null) {
                throw new IOException("Not connected");
            }
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            try {
                while (this.in < 0) {
                    if (this.source.closed) {
                        return -1;
                    }
                    this.lock.wait();
                }
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException();
            }
            int total = 0;
            do {
                int copylen = this.out < this.in ? Math.min(len, this.in - this.out) : Math.min(len, this.buffer.length - this.out);
                System.arraycopy(this.buffer, this.out, buf, offset, copylen);
                offset += copylen;
                len -= copylen;
                this.out += copylen;
                total += copylen;
                if (this.out == this.buffer.length) {
                    this.out = 0;
                }
                if (this.out != this.in) continue;
                this.in = -1;
                this.out = 0;
            } while (len != 0 && this.in != -1);
            this.lock.notifyAll();
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            if (this.in < 0) {
                return false;
            }
            int count = this.out < this.in ? this.in - this.out : this.buffer.length - this.out - this.in;
            boolean bl = false;
            if (count <= 0) return bl;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.buffer = new char[2048];
        this.in = -1;
        this.out = 0;
        this.read_buf = new char[1];
    }

    public PipedReader() {
        this.this();
    }

    public PipedReader(PipedWriter source) throws IOException {
        this.this();
        this.connect(source);
    }
}

