/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import java.util.HashMap;

class GenotypeNumLikelihoodsCache {
    private static final int DEFAULT_N_ALLELES = 5;
    private static final int DEFAULT_PLOIDY = 10;
    private final int[][] staticCache;
    private final HashMap<CacheKey, Integer> dynamicCache = new HashMap();

    GenotypeNumLikelihoodsCache() {
        this(5, 10);
    }

    GenotypeNumLikelihoodsCache(int numAlleles, int ploidy) {
        this.staticCache = new int[numAlleles][ploidy];
        this.fillCache();
    }

    private void fillCache() {
        for (int numAlleles = 0; numAlleles < this.staticCache.length; ++numAlleles) {
            for (int ploidy = 0; ploidy < this.staticCache[numAlleles].length; ++ploidy) {
                this.staticCache[numAlleles][ploidy] = GenotypeLikelihoods.calcNumLikelihoods(numAlleles + 1, ploidy + 1);
            }
        }
    }

    private synchronized void put(int numAlleles, int ploidy, int numLikelihoods) {
        this.dynamicCache.put(new CacheKey(numAlleles, ploidy), numLikelihoods);
    }

    synchronized int get(int numAlleles, int ploidy) {
        if (numAlleles <= 0 || ploidy <= 0) {
            throw new IllegalArgumentException("numAlleles and ploidy must both exceed 0, but they are numAlleles: " + numAlleles + ", ploidy: " + ploidy);
        }
        if (numAlleles < this.staticCache.length && ploidy < this.staticCache[numAlleles].length) {
            return this.staticCache[numAlleles - 1][ploidy - 1];
        }
        Integer cachedValue = this.dynamicCache.get(new CacheKey(numAlleles, ploidy));
        if (cachedValue == null) {
            int newValue = GenotypeLikelihoods.calcNumLikelihoods(numAlleles, ploidy);
            this.put(numAlleles, ploidy, newValue);
            return newValue;
        }
        return cachedValue;
    }

    private class CacheKey {
        private final int numAlleles;
        private final int ploidy;

        CacheKey(int numAlleles, int ploidy) {
            this.numAlleles = numAlleles;
            this.ploidy = ploidy;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof CacheKey) {
                CacheKey c = (CacheKey)object;
                return this.numAlleles == c.numAlleles && this.ploidy == c.ploidy;
            }
            return false;
        }

        public int hashCode() {
            return this.numAlleles * 31 + this.ploidy;
        }
    }
}

