require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_OCSP_H)) {
    eval 'sub HEADER_OCSP_H () {1;}' unless defined(&HEADER_OCSP_H);
    require 'openssl/opensslconf.ph';
    eval 'sub OCSP_REVOKED_STATUS_NOSTATUS () {-1;}' unless defined(&OCSP_REVOKED_STATUS_NOSTATUS);
    eval 'sub OCSP_REVOKED_STATUS_UNSPECIFIED () {0;}' unless defined(&OCSP_REVOKED_STATUS_UNSPECIFIED);
    eval 'sub OCSP_REVOKED_STATUS_KEYCOMPROMISE () {1;}' unless defined(&OCSP_REVOKED_STATUS_KEYCOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_CACOMPROMISE () {2;}' unless defined(&OCSP_REVOKED_STATUS_CACOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_AFFILIATIONCHANGED () {3;}' unless defined(&OCSP_REVOKED_STATUS_AFFILIATIONCHANGED);
    eval 'sub OCSP_REVOKED_STATUS_SUPERSEDED () {4;}' unless defined(&OCSP_REVOKED_STATUS_SUPERSEDED);
    eval 'sub OCSP_REVOKED_STATUS_CESSATIONOFOPERATION () {5;}' unless defined(&OCSP_REVOKED_STATUS_CESSATIONOFOPERATION);
    eval 'sub OCSP_REVOKED_STATUS_CERTIFICATEHOLD () {6;}' unless defined(&OCSP_REVOKED_STATUS_CERTIFICATEHOLD);
    eval 'sub OCSP_REVOKED_STATUS_REMOVEFROMCRL () {8;}' unless defined(&OCSP_REVOKED_STATUS_REMOVEFROMCRL);
    unless(defined(&OPENSSL_NO_OCSP)) {
	require 'openssl/ossl_typ.ph';
	require 'openssl/x509.ph';
	require 'openssl/x509v3.ph';
	require 'openssl/safestack.ph';
	require 'openssl/ocsperr.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub OCSP_DEFAULT_NONCE_LENGTH () {16;}' unless defined(&OCSP_DEFAULT_NONCE_LENGTH);
	eval 'sub OCSP_NOCERTS () {0x1;}' unless defined(&OCSP_NOCERTS);
	eval 'sub OCSP_NOINTERN () {0x2;}' unless defined(&OCSP_NOINTERN);
	eval 'sub OCSP_NOSIGS () {0x4;}' unless defined(&OCSP_NOSIGS);
	eval 'sub OCSP_NOCHAIN () {0x8;}' unless defined(&OCSP_NOCHAIN);
	eval 'sub OCSP_NOVERIFY () {0x10;}' unless defined(&OCSP_NOVERIFY);
	eval 'sub OCSP_NOEXPLICIT () {0x20;}' unless defined(&OCSP_NOEXPLICIT);
	eval 'sub OCSP_NOCASIGN () {0x40;}' unless defined(&OCSP_NOCASIGN);
	eval 'sub OCSP_NODELEGATED () {0x80;}' unless defined(&OCSP_NODELEGATED);
	eval 'sub OCSP_NOCHECKS () {0x100;}' unless defined(&OCSP_NOCHECKS);
	eval 'sub OCSP_TRUSTOTHER () {0x200;}' unless defined(&OCSP_TRUSTOTHER);
	eval 'sub OCSP_RESPID_KEY () {0x400;}' unless defined(&OCSP_RESPID_KEY);
	eval 'sub OCSP_NOTIME () {0x800;}' unless defined(&OCSP_NOTIME);
	eval 'sub OCSP_RESPONSE_STATUS_SUCCESSFUL () {0;}' unless defined(&OCSP_RESPONSE_STATUS_SUCCESSFUL);
	eval 'sub OCSP_RESPONSE_STATUS_MALFORMEDREQUEST () {1;}' unless defined(&OCSP_RESPONSE_STATUS_MALFORMEDREQUEST);
	eval 'sub OCSP_RESPONSE_STATUS_INTERNALERROR () {2;}' unless defined(&OCSP_RESPONSE_STATUS_INTERNALERROR);
	eval 'sub OCSP_RESPONSE_STATUS_TRYLATER () {3;}' unless defined(&OCSP_RESPONSE_STATUS_TRYLATER);
	eval 'sub OCSP_RESPONSE_STATUS_SIGREQUIRED () {5;}' unless defined(&OCSP_RESPONSE_STATUS_SIGREQUIRED);
	eval 'sub OCSP_RESPONSE_STATUS_UNAUTHORIZED () {6;}' unless defined(&OCSP_RESPONSE_STATUS_UNAUTHORIZED);
	eval 'sub V_OCSP_RESPID_NAME () {0;}' unless defined(&V_OCSP_RESPID_NAME);
	eval 'sub V_OCSP_RESPID_KEY () {1;}' unless defined(&V_OCSP_RESPID_KEY);
	eval 'sub V_OCSP_CERTSTATUS_GOOD () {0;}' unless defined(&V_OCSP_CERTSTATUS_GOOD);
	eval 'sub V_OCSP_CERTSTATUS_REVOKED () {1;}' unless defined(&V_OCSP_CERTSTATUS_REVOKED);
	eval 'sub V_OCSP_CERTSTATUS_UNKNOWN () {2;}' unless defined(&V_OCSP_CERTSTATUS_UNKNOWN);
	eval 'sub PEM_STRING_OCSP_REQUEST () {"OCSP REQUEST";}' unless defined(&PEM_STRING_OCSP_REQUEST);
	eval 'sub PEM_STRING_OCSP_RESPONSE () {"OCSP RESPONSE";}' unless defined(&PEM_STRING_OCSP_RESPONSE);
	eval 'sub d2i_OCSP_REQUEST_bio {
	    my($bp,$p) = @_;
    	    eval q( &ASN1_d2i_bio_of( &OCSP_REQUEST, &OCSP_REQUEST_new, &d2i_OCSP_REQUEST,$bp,$p));
	}' unless defined(&d2i_OCSP_REQUEST_bio);
	eval 'sub d2i_OCSP_RESPONSE_bio {
	    my($bp,$p) = @_;
    	    eval q( &ASN1_d2i_bio_of( &OCSP_RESPONSE, &OCSP_RESPONSE_new, &d2i_OCSP_RESPONSE,$bp,$p));
	}' unless defined(&d2i_OCSP_RESPONSE_bio);
	eval 'sub PEM_read_bio_OCSP_REQUEST {
	    my($bp,$x,$cb) = @_;
    	    eval q(( &OCSP_REQUEST *) &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_OCSP_REQUEST, &PEM_STRING_OCSP_REQUEST, $bp,($x),$cb, &NULL));
	}' unless defined(&PEM_read_bio_OCSP_REQUEST);
	eval 'sub PEM_read_bio_OCSP_RESPONSE {
	    my($bp,$x,$cb) = @_;
    	    eval q(( &OCSP_RESPONSE *) &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_OCSP_RESPONSE, &PEM_STRING_OCSP_RESPONSE, $bp,($x),$cb, &NULL));
	}' unless defined(&PEM_read_bio_OCSP_RESPONSE);
	eval 'sub PEM_write_bio_OCSP_REQUEST {
	    my($bp,$o) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_REQUEST, &PEM_STRING_OCSP_REQUEST, $bp,($o),  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_OCSP_REQUEST);
	eval 'sub PEM_write_bio_OCSP_RESPONSE {
	    my($bp,$o) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_RESPONSE, &PEM_STRING_OCSP_RESPONSE, $bp,($o),  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_OCSP_RESPONSE);
	eval 'sub i2d_OCSP_RESPONSE_bio {
	    my($bp,$o) = @_;
    	    eval q( &ASN1_i2d_bio_of( &OCSP_RESPONSE, &i2d_OCSP_RESPONSE,$bp,$o));
	}' unless defined(&i2d_OCSP_RESPONSE_bio);
	eval 'sub i2d_OCSP_REQUEST_bio {
	    my($bp,$o) = @_;
    	    eval q( &ASN1_i2d_bio_of( &OCSP_REQUEST, &i2d_OCSP_REQUEST,$bp,$o));
	}' unless defined(&i2d_OCSP_REQUEST_bio);
	eval 'sub ASN1_BIT_STRING_digest {
	    my($data,$type,$md,$len) = @_;
    	    eval q( &ASN1_item_digest( &ASN1_ITEM_rptr( &ASN1_BIT_STRING),$type,$data,$md,$len));
	}' unless defined(&ASN1_BIT_STRING_digest);
	eval 'sub OCSP_CERTSTATUS_dup {
	    my($cs) = @_;
    	    eval q(( &OCSP_CERTSTATUS*) &ASN1_dup(( &int(*)()) &i2d_OCSP_CERTSTATUS, (\'char\' *(*)()) &d2i_OCSP_CERTSTATUS,($cs)));
	}' unless defined(&OCSP_CERTSTATUS_dup);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
