/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.SampleFileIt;
import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.Data;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.MarkerIndices;
import vcf.Markers;
import vcf.RefGT;
import vcf.RefGTRec;
import vcf.RestrictedVcfWindow;
import vcf.Samples;
import vcf.Window;
import vcf.WindowIt;

public class AllData
implements Data {
    private final Pedigree ped;
    private Window<RefGTRec> refWindow;
    private RefGT refGT;
    private RefGT restrictRefGT;
    private GTRec[] targRecs;
    private GT targGT;
    private MarkerIndices markerIndices;
    private int window = 0;
    private final WindowIt<RefGTRec> refWindowIt;
    private final RestrictedVcfWindow targWindow;
    private int cumMarkerCnt = 0;

    public static AllData allData(Supplier<SampleFileIt<RefGTRec>> supplier, SampleFileIt<GTRec> sampleFileIt, Par par) {
        GeneticMap geneticMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        WindowIt<RefGTRec> windowIt = WindowIt.newInstance(supplier, geneticMap, par.window(), par.overlap());
        if (windowIt.samples().size() == 0 || sampleFileIt.samples().size() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        RestrictedVcfWindow restrictedVcfWindow = new RestrictedVcfWindow(sampleFileIt);
        AllData allData = new AllData(par, windowIt, restrictedVcfWindow);
        assert (allData.canAdvanceWindow());
        allData.advanceWindow();
        return allData;
    }

    private AllData(Par par, WindowIt<RefGTRec> windowIt, RestrictedVcfWindow restrictedVcfWindow) {
        this.ped = new Pedigree(restrictedVcfWindow.samples(), par.ped());
        this.refWindowIt = windowIt;
        this.targWindow = restrictedVcfWindow;
        this.refWindow = null;
        this.refGT = null;
        this.restrictRefGT = null;
        this.targRecs = new GTRec[0];
        this.targGT = AllData.targGT(restrictedVcfWindow.samples(), this.targRecs, this.ped);
        this.markerIndices = null;
    }

    private static GT targGT(Samples samples, GTRec[] gTRecArray, Pedigree pedigree) {
        return new BasicGT(samples, gTRecArray);
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.refWindowIt.genMap();
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.refWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.refWindowIt.hasNext();
    }

    @Override
    public void advanceWindow() {
        this.refWindow = this.refWindowIt.next();
        this.cumMarkerCnt += this.refWindow.nMarkers() - this.refWindow.prevOverlap();
        RefGTRec[] refGTRecArray = this.refWindow.recList().toArray(new RefGTRec[0]);
        this.refGT = new RefGT(refGTRecArray);
        this.targRecs = this.targWindow.advanceWindow(this.refGT.markers());
        this.markerIndices = new MarkerIndices(AllData.inTarg(this.targRecs), this.refWindow.prevOverlap(), this.refWindow.nextOverlap());
        int[] nArray = this.markerIndices.targMarkerToMarker();
        this.targGT = AllData.targGTWindow(this.targWindow.samples(), this.targRecs, nArray, this.ped);
        this.restrictRefGT = this.restrictRecs(this.targGT.markers(), refGTRecArray, nArray);
        ++this.window;
    }

    @Override
    public IntArray[][] carriers(int n3) {
        return (IntArray[][])IntStream.range(0, this.targGT.nMarkers()).parallel().mapToObj(n2 -> this.carriers(n2, n3)).toArray(n -> new IntArray[n][]);
    }

    private IntArray[] carriers(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.targGT.marker(n2).nAlleles();
        IntList[] intListArray = (IntList[])IntStream.range(0, n7).mapToObj(n -> new IntList(16)).toArray(IntList[]::new);
        int n8 = this.targGT.nSamples();
        int n9 = this.restrictRefGT != null ? this.restrictRefGT.nSamples() : 0;
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = this.targGT.allele1(n2, n6);
            n4 = this.targGT.allele2(n2, n6);
            if (n5 >= 0 && intListArray[n5].size() <= n3) {
                intListArray[n5].add(n6);
            }
            if (n4 < 0 || n4 == n5 || intListArray[n4].size() > n3) continue;
            intListArray[n4].add(n6);
        }
        for (n6 = 0; n6 < n9; ++n6) {
            n5 = this.restrictRefGT.allele1(n2, n6);
            n4 = this.restrictRefGT.allele2(n2, n6);
            if (n5 >= 0 && intListArray[n5].size() <= n3) {
                intListArray[n5].add(n8 + n6);
            }
            if (n4 < 0 || n4 == n5 || intListArray[n4].size() > n3) continue;
            intListArray[n4].add(n8 + n6);
        }
        return (IntArray[])Arrays.stream(intListArray).map(intList -> {
            if (intList.isEmpty()) {
                return Data.ZERO_FREQ_ARRAY;
            }
            if (intList.size() <= n3) {
                return new WrappedIntArray((IntList)intList);
            }
            return Data.HIGH_FREQ_ARRAY;
        }).toArray(IntArray[]::new);
    }

    @Override
    public int windowIndex() {
        return this.window;
    }

    public static boolean[] inTarg(GTRec[] gTRecArray) {
        boolean[] blArray = new boolean[gTRecArray.length];
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (gTRecArray[i] == null) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private static GT targGTWindow(Samples samples, GTRec[] gTRecArray, int[] nArray, Pedigree pedigree) {
        GTRec[] gTRecArray2 = new GTRec[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            gTRecArray2[i] = gTRecArray[nArray[i]];
        }
        return new BasicGT(samples, gTRecArray2);
    }

    private RefGT restrictRecs(Markers markers, RefGTRec[] refGTRecArray, int[] nArray) {
        assert (markers.size() == nArray.length);
        RefGTRec[] refGTRecArray2 = new RefGTRec[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            refGTRecArray2[i] = refGTRecArray[nArray[i]];
        }
        return new RefGT(markers, this.refWindowIt.samples(), refGTRecArray2);
    }

    @Override
    public int nTargMarkersSoFar() {
        return this.targWindow.cumMarkerCnt();
    }

    @Override
    public int nMarkers() {
        return this.refGT.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public GT targGT() {
        return this.targGT;
    }

    @Override
    public Optional<RefGT> refGT() {
        return Optional.of(this.refGT);
    }

    @Override
    public Optional<RefGT> restrictRefGT() {
        return Optional.of(this.restrictRefGT);
    }

    @Override
    public void close() {
        this.refWindowIt.close();
        this.targWindow.close();
    }

    @Override
    public MarkerIndices markerIndices() {
        return this.markerIndices;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.getClass().toString());
        return stringBuilder.toString();
    }
}

