/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XIncludeFilter
extends EventFilter
implements Locator {
    private Hashtable extEntities;
    private int ignoreCount;
    private Stack uris;
    private Locator locator;
    private Vector inclusions;
    private boolean savingPrefixes;

    private final void fatal(SAXParseException e) throws SAXException {
        ErrorHandler eh = this.getErrorHandler();
        if (eh != null) {
            eh.fatalError(e);
        }
        throw e;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(this);
    }

    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    public void setSavingPrefixes(boolean flag) {
        this.savingPrefixes = flag;
    }

    public boolean isSavingPrefixes() {
        return this.savingPrefixes;
    }

    private final String addMarker(String uri) throws SAXException {
        if (this.locator != null && this.locator.getSystemId() != null) {
            uri = this.locator.getSystemId();
        }
        if (uri == null) {
            this.fatal(new SAXParseException("Entity URI is unknown", this.locator));
        }
        try {
            URL url = new URL(uri);
            uri = url.toString();
            if (this.inclusions.contains(uri)) {
                this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
            }
            this.inclusions.addElement(uri);
            this.uris.push(url);
        }
        catch (IOException e) {
            this.fatal(new SAXParseException("parser bug: relative URI", this.locator, e));
        }
        return uri;
    }

    private final void pop(String uri) {
        this.inclusions.removeElement(uri);
        this.uris.pop();
    }

    public void startDocument() throws SAXException {
        this.ignoreCount = 0;
        this.addMarker(null);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.inclusions.setSize(0);
        this.extEntities.clear();
        this.uris.setSize(0);
        super.endDocument();
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (name.charAt(0) == '%') {
            return;
        }
        try {
            URL url = new URL(this.locator.getSystemId());
            systemId = new URL(url, systemId).toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.extEntities.put(name, systemId);
    }

    public void startEntity(String name) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        String uri = (String)this.extEntities.get(name);
        if (uri != null) {
            this.addMarker(uri);
        }
        super.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        if (this.ignoreCount != 0 && --this.ignoreCount != 0) {
            return;
        }
        String uri = (String)this.extEntities.get(name);
        if (uri != null) {
            this.pop(uri);
        }
        super.endEntity(name);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        URL baseURI = (URL)this.uris.peek();
        String base = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (base == null) {
            this.uris.push(baseURI);
        } else {
            if (base.indexOf(35) != -1) {
                this.fatal(new SAXParseException("xml:base with fragment: " + base, this.locator));
            }
            try {
                baseURI = new URL(baseURI, base);
                this.uris.push(baseURI);
            }
            catch (Exception e) {
                this.fatal(new SAXParseException("xml:base with illegal uri: " + base, this.locator, e));
            }
        }
        if (!"http://www.w3.org/2001/XInclude".equals(uri)) {
            super.startElement(uri, localName, qName, atts);
            return;
        }
        if ("include".equals(localName)) {
            String href = atts.getValue("href");
            String parse = atts.getValue("parse");
            String encoding = atts.getValue("encoding");
            URL url = (URL)this.uris.peek();
            SAXParseException x = null;
            if (href == null) {
                this.fatal(new SAXParseException("XInclude missing href", this.locator));
            }
            if (href.indexOf(35) != -1) {
                this.fatal(new SAXParseException("XInclude with fragment: " + href, this.locator));
            }
            if (parse == null || "xml".equals(parse)) {
                x = this.xinclude(url, href);
            } else if ("text".equals(parse)) {
                x = this.readText(url, href, encoding);
            } else {
                this.fatal(new SAXParseException("unknown XInclude parsing mode: " + parse, this.locator));
            }
            if (x == null) {
                ++this.ignoreCount;
                return;
            }
            this.fatal(x);
        } else if ("fallback".equals(localName)) {
            this.fatal(new SAXParseException("illegal top level XInclude 'fallback' element", this.locator));
        } else {
            ErrorHandler eh = this.getErrorHandler();
            if (eh != null) {
                eh.warning(new SAXParseException("unrecognized toplevel XInclude element: " + localName, this.locator));
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.ignoreCount != 0 && --this.ignoreCount != 0) {
            return;
        }
        this.uris.pop();
        if (!"http://www.w3.org/2001/XInclude".equals(uri) || !"include".equals(localName)) {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreCount == 0) {
            super.characters(ch, start, length);
        }
    }

    public void processingInstruction(String target, String value) throws SAXException {
        if (this.ignoreCount == 0) {
            super.processingInstruction(target, value);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreCount == 0) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreCount == 0) {
            super.comment(ch, start, length);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.endCDATA();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.ignoreCount == 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.ignoreCount == 0) {
            super.endPrefixMapping(prefix);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.ignoreCount == 0) {
            super.skippedEntity(name);
        }
    }

    void setLocator(Locator l) {
        this.locator = l;
    }

    Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SAXParseException xinclude(URL url, String href) throws SAXException {
        Locator savedLocator = this.locator;
        XMLReader helper = XMLReaderFactory.createXMLReader();
        helper.setErrorHandler(this.getErrorHandler());
        helper.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        Scrubber scrubber = new Scrubber(this);
        this.locator = null;
        XIncludeFilter.bind(helper, scrubber);
        try {
            url = new URL(url, href);
            href = url.toString();
            if (this.inclusions.contains(href)) {
                this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
            }
            this.inclusions.addElement(href);
            this.uris.push(url);
            helper.parse(new InputSource(href));
            SAXParseException sAXParseException = null;
            Object var7_8 = null;
            this.pop(href);
            this.locator = savedLocator;
            return sAXParseException;
        }
        catch (IOException e) {
            try {
                SAXParseException sAXParseException = new SAXParseException(href, this.locator, e);
                Object var7_9 = null;
                this.pop(href);
                this.locator = savedLocator;
                return sAXParseException;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.pop(href);
                this.locator = savedLocator;
                throw throwable;
            }
        }
    }

    private final SAXParseException readText(URL url, String href, String encoding) throws SAXException {
        InputStream in = null;
        try {
            int count;
            InputStreamReader reader;
            char[] buf = new char[4096];
            url = new URL(url, href);
            URLConnection conn = url.openConnection();
            in = conn.getInputStream();
            if (encoding == null) {
                encoding = Resolver.getEncoding(conn.getContentType());
            }
            if (encoding == null) {
                ErrorHandler eh = this.getErrorHandler();
                if (eh != null) {
                    eh.warning(new SAXParseException("guessing text encoding for URL: " + url, this.locator));
                }
                reader = new InputStreamReader(in);
            } else {
                reader = new InputStreamReader(in, encoding);
            }
            while ((count = reader.read(buf, 0, buf.length)) != -1) {
                super.characters(buf, 0, count);
            }
            in.close();
            return null;
        }
        catch (IOException e) {
            return new SAXParseException("can't XInclude text", this.locator, e);
        }
    }

    private final /* synthetic */ void this() {
        this.extEntities = new Hashtable(5, 5);
        this.uris = new Stack();
        this.inclusions = new Vector(5, 5);
    }

    public XIncludeFilter(EventConsumer next) throws SAXException {
        super(next);
        this.this();
        this.setContentHandler(this);
        this.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Scrubber
    extends EventFilter {
        public void setDocumentLocator(Locator l) {
            XIncludeFilter.this.setLocator(l);
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        private final void reject(String message) throws SAXException {
            XIncludeFilter.this.fatal(new SAXParseException(message, XIncludeFilter.this.getLocator()));
        }

        public void startDTD(String root, String publicId, String systemId) throws SAXException {
            this.reject("XIncluded DTD: " + systemId);
        }

        public void endDTD() throws SAXException {
            this.reject("XIncluded DTD");
        }

        public void skippedEntity(String name) throws SAXException {
            this.reject("XInclude skipped entity: " + name);
        }

        Scrubber(EventFilter f) throws SAXException {
            super(f);
            super.setContentHandler(this);
            super.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            super.setDTDHandler(null);
            super.setProperty("http://xml.org/sax/properties/declaration-handler", null);
        }
    }
}

