package Installer::Item;
# $Id: Item.pm,v 1.11 2000/09/04 02:37:13 tom Exp $
################################################################

=head1 NAME

Installer::Item - item for installing

=head1 SYNOPSIS

 use Installer::Item;

 $i = new Installer::Item(name=>foo, data=>bar, type=>int);
 $i->Input;
 print $i->data;

=cut

use strict;
use vars qw(@ISA @EXPORT
	    $Number $MaxCommentLength);

use Exporter;
@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes);

use ObjectTemplate;
use Input;

=head1 STATIC VARIABLES

 $Number                   accumrated item number. automatically incremented
                           in new-ed.
 $MaxCommentLength         maximum length of comment strings.

=cut

$Number = 0;
$MaxCommentLength = 0;     


=cut


=head1 MEMBER VARIABLES

 name        name
 type        type('int', 'bool', 'string', 'path', 'absolute_path', 'mailaddress', 'select')
 data        data value
 comment     comment string
 comment2    added comment string

=cut

attributes qw(name type
	      class
	      data comment comment2
	      comment_ja
	      options
	      unshow
	      unsave
	      loaded
	      num);                # set automatically

sub initialize($)
{
    my $self = shift;

    $self->num($Number);

    $Number++;
    my $length = length($self->comment);
    $MaxCommentLength = $length if $MaxCommentLength < $length;

    $self->SUPER::initialize;
}

sub Input($)
{
    my $self = shift;

    my $prompt .= $self->comment || $self->name;
    $prompt .= "\n(" . $self->comment2 . ")"
	if $self->comment2;
    my $value = $self->data;
    my $type = $self->type;
    if ($type eq 'bool'){
	$value = InputYN($prompt, $value);
    } elsif ($type eq 'string'){
	$value = InputString($prompt, $value);
    } elsif ($type eq 'mailaddress'){
	$value = InputMailAddress($prompt, $value);
    } elsif ($type eq 'int'){
	$value = InputInteger($prompt, $value);
    } elsif ($type =~ 'path'){
	$value = InputPath($prompt, $value, $type =~ /^absolute/);
    } elsif ($type =~ /select/){
	$value = InputSelect($prompt, $value, $self->options);
    } else {
	die "illegal type: $type";
    }
    $self->data($value);
    return $self->data;
}

sub AsConfirm($)
{
    my $self = shift;

    my $line = sprintf("  %-${MaxCommentLength}s ", $self->comment);
    if ($self->type eq 'bool'){
	$line .= (($self->data) ? 'yes' : 'no');
    } else {
	$line .= $self->data;
    }
    $line .= "\n";
    return $line;
}
1;
