/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resheader;

import javax.swing.table.AbstractTableModel;
import org.wiztools.commons.MultiValueMap;

class ResponseHeaderTableModel
extends AbstractTableModel {
    private final String[] title = new String[]{"HTTP Header", "Value"};
    private String[][] headers;

    ResponseHeaderTableModel() {
    }

    public void setHeaders(MultiValueMap<String, String> mapHeaders) {
        if (mapHeaders == null) {
            this.headers = new String[0][0];
        } else {
            this.headers = new String[mapHeaders.values().size()][2];
            int i = 0;
            for (String key : mapHeaders.keySet()) {
                for (String value : mapHeaders.get(key)) {
                    this.headers[i][0] = key;
                    this.headers[i][1] = value;
                    ++i;
                }
            }
        }
        this.fireTableDataChanged();
    }

    public String[][] getHeaders() {
        return this.headers;
    }

    @Override
    public String getColumnName(int col) {
        return this.title[col];
    }

    @Override
    public int getRowCount() {
        if (this.headers == null) {
            return 0;
        }
        return this.headers.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.headers[row][0];
        }
        return this.headers[row][1];
    }
}

