/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class PortingUtils {
    @Deprecated
    public static boolean INITIALIZE_SCREEN_AREA_USING_THREAD = true;

    public static Component getCurrentFocusComponent(AWTEvent event) {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public static int getFrameState(Frame frame) {
        return frame.getExtendedState();
    }

    public static void setFrameState(Frame frame, int state) {
        frame.setExtendedState(state);
    }

    public static int getMouseModifiers(MouseEvent e) {
        return e.getModifiersEx();
    }

    public static void removeFocus(JComponent component) {
        component.setRequestFocusEnabled(false);
        component.setFocusable(false);
    }

    public static void removeButtonBorder(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(BorderFactory.createEmptyBorder());
    }

    public static Rectangle containsInScreenBounds(Component invoker, Rectangle rect) {
        return PortingUtils.containsInScreenBounds(invoker, rect, false);
    }

    public static Rectangle containsInScreenBounds(Component invoker, Rectangle rect, boolean useInvokerDevice) {
        Rectangle screenBounds = PortingUtils.getScreenBounds(invoker, useInvokerDevice);
        Point p = rect.getLocation();
        if (p.x + rect.width > screenBounds.x + screenBounds.width) {
            p.x = screenBounds.x + screenBounds.width - rect.width;
        }
        if (p.y + rect.height > screenBounds.y + screenBounds.height) {
            p.y = screenBounds.y + screenBounds.height - rect.height;
        }
        if (p.x < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return new Rectangle(p, rect.getSize());
    }

    public static Rectangle overlapWithScreenBounds(Component invoker, Rectangle rect) {
        Rectangle screenBounds = PortingUtils.getScreenBounds(invoker);
        Point p = rect.getLocation();
        if (p.x > screenBounds.x + screenBounds.width) {
            p.x = screenBounds.x + screenBounds.width - rect.width;
        }
        if (p.y > screenBounds.y + screenBounds.height) {
            p.y = screenBounds.y + screenBounds.height - rect.height;
        }
        if (p.x + rect.width < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y + rect.height < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return new Rectangle(p, rect.getSize());
    }

    public static Dimension getScreenSize(Component invoker) {
        Dimension screenSize = PortingUtils.getScreenBounds().getSize();
        if (invoker != null && !(invoker instanceof JApplet) && invoker.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(invoker.getGraphicsConfiguration());
            screenSize.width -= insets.left + insets.right;
            screenSize.height -= insets.top + insets.bottom;
        }
        return screenSize;
    }

    public static Dimension getLocalScreenSize(Component invoker) {
        if (invoker != null && !(invoker instanceof JApplet) && invoker.getGraphicsConfiguration() != null) {
            GraphicsConfiguration gc = invoker.getGraphicsConfiguration();
            Rectangle bounds = gc.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            return bounds.getSize();
        }
        return PortingUtils.getScreenSize(invoker);
    }

    public static Rectangle getScreenBounds(Component invoker, boolean useInvokerDevice) {
        Rectangle bounds;
        Rectangle rectangle = bounds = !useInvokerDevice || invoker == null || invoker.getGraphicsConfiguration() == null ? (Rectangle)PortingUtils.getScreenBounds().clone() : invoker.getGraphicsConfiguration().getBounds();
        if (invoker != null && !(invoker instanceof JApplet) && invoker.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(invoker.getGraphicsConfiguration());
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        return bounds;
    }

    public static Rectangle getScreenBounds(Component invoker) {
        return PortingUtils.getScreenBounds(invoker, false);
    }

    public static Rectangle getLocalScreenBounds() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return e.getMaximumWindowBounds();
    }

    private static Rectangle getScreenBounds() {
        GraphicsDevice[] gs;
        Rectangle SCREEN_BOUNDS = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            SCREEN_BOUNDS = SCREEN_BOUNDS.union(gc.getBounds());
        }
        return SCREEN_BOUNDS;
    }

    @Deprecated
    public static synchronized void initializeScreenArea() {
        PortingUtils.initializeScreenArea(5);
    }

    @Deprecated
    public static synchronized void invalidateScreenArea() {
    }

    @Deprecated
    public static synchronized void initializeScreenArea(int priority) {
        Thread _initializationThread = new Thread(){

            public void run() {
                GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            }
        };
        _initializationThread.setPriority(priority);
        if (INITIALIZE_SCREEN_AREA_USING_THREAD) {
            _initializationThread.start();
        } else {
            _initializationThread.run();
        }
    }

    @Deprecated
    public static boolean isInitializationThreadAlive() {
        return false;
    }

    @Deprecated
    public static boolean isInitializationThreadStarted() {
        return false;
    }

    public static Rectangle ensureVisible(Component invoker, Rectangle bounds) {
        Rectangle mainScreenBounds = PortingUtils.getLocalScreenBounds();
        if (!mainScreenBounds.contains(bounds.getLocation())) {
            Rectangle screenBounds = PortingUtils.getScreenBounds(invoker, false);
            if (bounds.x > screenBounds.x + screenBounds.width || bounds.x < screenBounds.x) {
                bounds.x = screenBounds.x;
            }
            if (bounds.y > screenBounds.y + screenBounds.height || bounds.y < screenBounds.y) {
                bounds.y = screenBounds.y;
            }
        }
        return bounds;
    }

    public static Rectangle ensureOnScreen(Rectangle rect) {
        return PortingUtils.ensureOnScreen(rect, true);
    }

    public static Rectangle ensureOnScreen(Rectangle rect, boolean allowCrossScreen) {
        int screenBottom;
        int rectBottom;
        Rectangle localScreenBounds = PortingUtils.getLocalScreenBounds();
        if (localScreenBounds.contains(rect)) {
            return rect;
        }
        Rectangle[] SCREENS = PortingUtils.getScreens();
        if (allowCrossScreen && PortingUtils.getScreenArea().contains(rect)) {
            return rect;
        }
        Rectangle containingScreen = null;
        Point rectPos = rect.getLocation();
        for (Rectangle screenBounds : SCREENS) {
            if (!screenBounds.contains(rectPos)) continue;
            containingScreen = screenBounds;
            break;
        }
        for (Rectangle screenBounds : SCREENS) {
            if (!screenBounds.intersects(rect)) continue;
            containingScreen = screenBounds;
            break;
        }
        if (containingScreen == null) {
            rect.x = (SCREENS[0].width - rect.width) / 2;
            rect.y = (SCREENS[0].height - rect.height) / 2;
            return rect;
        }
        int rectRight = rect.x + rect.width;
        int screenRight = containingScreen.x + containingScreen.width;
        if (rectRight > screenRight) {
            rect.x = screenRight - rect.width;
        }
        if (rect.x < containingScreen.x) {
            rect.x = containingScreen.x;
        }
        if ((rectBottom = rect.y + rect.height) > (screenBottom = containingScreen.y + containingScreen.height)) {
            rect.y = screenBottom - rect.height;
        }
        if (rect.y < containingScreen.y) {
            rect.y = containingScreen.y;
        }
        return rect;
    }

    public static Rectangle getContainingScreenBounds(Rectangle rect, boolean considerInsets) {
        Rectangle screenBounds;
        int i;
        Insets[] INSETS = PortingUtils.getInsets();
        Rectangle[] SCREENS = PortingUtils.getScreens();
        Rectangle containingScreen = null;
        Insets insets = null;
        Point rectPos = rect.getLocation();
        for (i = 0; i < SCREENS.length; ++i) {
            screenBounds = SCREENS[i];
            if (!screenBounds.contains(rectPos)) continue;
            containingScreen = screenBounds;
            insets = INSETS[i];
            break;
        }
        for (i = 0; i < SCREENS.length; ++i) {
            screenBounds = SCREENS[i];
            if (!screenBounds.intersects(rect)) continue;
            containingScreen = screenBounds;
            insets = INSETS[i];
            break;
        }
        if (containingScreen == null) {
            containingScreen = SCREENS[0];
            insets = INSETS[0];
        }
        Rectangle bounds = new Rectangle(containingScreen);
        if (considerInsets && insets != null) {
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        return bounds;
    }

    public static Area getScreenArea() {
        GraphicsDevice[] screenDevices;
        Area SCREEN_AREA = new Area();
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : screenDevices = environment.getScreenDevices()) {
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Rectangle screenBounds = configuration.getBounds();
            SCREEN_AREA.add(new Area(screenBounds));
        }
        return SCREEN_AREA;
    }

    private static Rectangle[] getScreens() {
        GraphicsDevice[] screenDevices;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<Rectangle> screensList = new ArrayList<Rectangle>();
        for (GraphicsDevice device : screenDevices = environment.getScreenDevices()) {
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Rectangle screenBounds = configuration.getBounds();
            screensList.add(screenBounds);
        }
        return screensList.toArray(new Rectangle[screensList.size()]);
    }

    private static Insets[] getInsets() {
        GraphicsDevice[] screenDevices;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<Insets> insetsList = new ArrayList<Insets>();
        for (GraphicsDevice device : screenDevices = environment.getScreenDevices()) {
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Rectangle screenBounds = configuration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(configuration);
            insetsList.add(insets);
        }
        return insetsList.toArray(new Insets[insetsList.size()]);
    }

    public static void notifyUser() {
        PortingUtils.notifyUser(null);
    }

    public static void notifyUser(Component component) {
        String beep = SecurityUtils.getProperty("jide.beepNotifyUser", "true");
        if ("true".equals(beep)) {
            UIManager.getLookAndFeel().provideErrorFeedback(component);
        }
    }

    public static void prerequisiteChecking() {
        if (!SystemInfo.isJdk14Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4 or above is required for this demo.", "JIDE Software, Inc.", 2);
            System.exit(0);
        }
        if (!SystemInfo.isJdk142Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4.2 or above is recommended for this demo for the best experience of seamless integration with Windows XP.", "JIDE Software, Inc.", 2);
        }
        if (SystemInfo.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
    }

    public static void setPreferredSize(Component component, Dimension size) {
        if (SystemInfo.isJdk15Above()) {
            component.setPreferredSize(size);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setPreferredSize(size);
        }
    }

    public static void setMinimumSize(Component component, Dimension size) {
        if (SystemInfo.isJdk15Above()) {
            component.setMinimumSize(size);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setMinimumSize(size);
        }
    }
}

